package com.ejianc.certify.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.certify.bean.CertifregBEntity;
import com.ejianc.certify.bean.CertifregFEntity;

/**
 * 证照登记单-表头
 *
 * @author generator
 */
@TableName("jzctm_certifreg")
public class CertifyregHEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "pk_group")
    private String pkGroup; // 集团
    @TableField(value = "dbilldate")
    private String dbilldate; // 单据日期
    @TableField(value = "pk_org")
    private Long pkOrg; // 管理组织
    @TableField(value = "pk_managedept")
    private Long pkManagedept; // 管理部门
    @TableField(value = "vbillcode")
    private String vbillcode; // 单据编码
    @TableField(value = "pk_certiftype")
    private Long pkCertiftype; // 证照名称（引用证照类别）
    @TableField(value = "certifcode")
    private String certifcode; // 证书编号（证书上的编号）
    @TableField(value = "zj_code")
    private String zjCode; // 证件编码（自动生成）
    @TableField(value = "pk_certpsn")
    private Long pkCertpsn; // 持证人员
    @TableField(value = "sb_total")
    private Integer sbTotal; // 累计购买月份
    @TableField(value = "sb_month")
    private String sbMonth; // 最新社保月份
    @TableField(value = "cert_status")
    private String certStatus; // 证照状态（0-未生效 1-生效 2-失效）
    @TableField(value = "effect_time")
    private String effectTime; // 生效时间
    @TableField(value = "expire_time")
    private String expireTime; // 失效时间
    @TableField(value = "vgrantcertunit")
    private String vgrantcertunit; // 发证机构
    @TableField(value = "dgrantcertdate")
    private String dgrantcertdate; // 发证日期
    @TableField(value = "receiver")
    private Long receiver; // 证件接收人
    @TableField(value = "receivedate")
    private String receivedate; // 证件接收日期
    @TableField(value = "validbegindate")
    private String validbegindate; // 有效期开始日期
    @TableField(value = "validenddate")
    private String validenddate; // 有效期截止日期
    @TableField(value = "pk_vcertcorp")
    private Long pkVcertcorp; // 持证区域（人力公司）
    @TableField(value = "voutcertcorp")
    private String voutcertcorp; // 持证外单位
    @TableField(value = "boutunit")
    private String boutunit; // 持证外单位资质
    @TableField(value = "has_effective_date")
    private String hasEffectiveDate; // 是否控制有效期
    @TableField(value = "bisfee")
    private String bisfee; // 是否计费
    @TableField(value = "pk_billtype")
    private String pkBilltype; // 单据类型
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "vmemo")
    private String vmemo; // 备注
    @TableField(value = "pk_dept")
    private Long pkDept; // 部门
    @TableField(value = "vbusitype")
    private String vbusitype; // 业务类型
    @TableField(value = "approver")
    private String approver; // 审批人
    @TableField(value = "taudittime")
    private Date taudittime; // 审批时间
    @TableField(value = "vapprovenote")
    private String vapprovenote; // 审批附言
    @TableField(value = "vdef1")
    private String vdef1; // 
    @TableField(value = "vdef10")
    private String vdef10; // 
    @TableField(value = "vdef2")
    private String vdef2; // 
    @TableField(value = "vdef3")
    private String vdef3; // 
    @TableField(value = "vdef4")
    private String vdef4; // 
    @TableField(value = "vdef5")
    private String vdef5; // 
    @TableField(value = "vdef6")
    private String vdef6; // 
    @TableField(value = "vdef7")
    private String vdef7; // 
    @TableField(value = "vdef8")
    private String vdef8; // 
    @TableField(value = "vdef9")
    private String vdef9; // 
    @TableField(value = "voperscope")
    private String voperscope; // 经营范围
    @TableField(value = "enablestate")
    private Integer enablestate; // 0-未启用 1-已启用 2-已停用
    @TableField(value = "card_id")
    private String cardId; // 身份证号码
    @TableField(value = "psn_phone")
    private String psnPhone; // 电话号码
    @TableField(value = "pk_special_type")
    private String pkSpecialType; // 特殊证件类型标记
    @TableField(value = "pk_sbzt")
    private String pkSbzt; // 社保主体
    @TableField(value = "pk_yjdw")
    private String pkYjdw; // 引进单位
    @TableField(value = "is_zyzj")
    private String isZyzj; // 是否自有证件
    @TableField(value = "pk_glzyz")
    private Long pkGlzyz; // 关联执业证件（注册证件）
    @TableField(value = "pk_glzcz")
    private Long pkGlzcz; // 关联注册证（B证）
    @TableField(value = "ts")
    private Date ts; // 时间戳
    @TableField(value = "applydate")
    private String applydate; // 申请日期
//    @TableField(value = "applyorg")
//    private String applyorg; // 注册主体(引进单位)，主键值
    @TableField(value = "applyorgtype")
    private String applyorgtype; // 资质类别
    @TableField(value = "applyprofessor")
    private String applyprofessor; // 证照专业
    @TableField(value = "applyregdate")
    private String applyregdate; // 注册日期
    @TableField(value = "applyer")
    private Long applyer; // 发起人
    @TableField(value = "applyerorg")
    private Long applyerorg; // 发起人组织
    @TableField(value = "applyisinstore")
    private String applyisinstore; // 是否原件在库
    @TableField(value = "is_dzzj")
    private String isDzzj; // 是否电子证件
    @TableField(value = "yj_isrecevie")
    private String yjIsrecevie; // 是否收到原件
    @TableField(value = "dableddate")
    private String dableddate; // 
    @TableField(value = "pk_usedept")
    private String pkUsedept; // 
    @TableField(value = "dalterdate")
    private String dalterdate; // 
    @TableField(value = "pk_usecorp")
    private String pkUsecorp; // 
    @TableField(value = "applybusicode")
    private String applybusicode; // 
    @TableField(value = "applybuzitype")
    private String applybuzitype; // 
    @TableField(value = "applycertowner")
    private String applycertowner; // 
    @TableField(value = "applycontacttype")
    private String applycontacttype; // 
    @TableField(value = "applystandermny")
    private BigDecimal applystandermny; // 
    @TableField(value = "applybasemny")
    private BigDecimal applybasemny; // 
    @TableField(value = "applyregcert")
    private String applyregcert; // 
    @TableField(value = "applyisreg")
    private String applyisreg; // 是否注册
    @TableField(value = "applyisuse")
    private String applyisuse; // 是否报建占用
    @TableField(value = "applyispleg")
    private String applyispleg; // 是否押证
    @TableField(value = "applyislock")
    private String applyislock; // 是否工程投标锁定
    @TableField(value = "applyisusemore")
    private String applyisusemore; // 是否允许一证多用证
    @TableField(value = "applyiscrosarea")
    private String applyiscrosarea; // 是否允许跨区域用证
    @TableField(value = "applyischanging")
    private String applyischanging; // 是否变更中
    @TableField(value = "applyisborraw")
    private String applyisborraw; // 能否借出引用
    @TableField(value = "applyiseffect")
    private String applyiseffect; // 是否失效
    @TableField(value = "expire_reason")
    private String expireReason; // 失效原因
    @TableField(value = "name")
    private String name;        //登记单显示名称


    @TableField(exist = false)
    @SubEntity(serviceName = "certifregBService", pidName = "pkCertifreg")//此处有pid="xxx"，默认值pid="pid"
    private List<CertifregBEntity> certifregBList = new ArrayList<>(); // 证照登记-变更记录
    @TableField(exist = false)
    @SubEntity(serviceName = "certifregFService", pidName = "pkCertifreg")//此处有pid="xxx"，默认值pid="pid"
    private List<CertifregFEntity> certifregFList = new ArrayList<>(); // 证照登记-基本补贴调整额


    public String getPkGroup() {
        return pkGroup;
    }

    public void setPkGroup(String pkGroup) {
        this.pkGroup = pkGroup;
    }

    public String getDbilldate() {
        return dbilldate;
    }

    public void setDbilldate(String dbilldate) {
        this.dbilldate = dbilldate;
    }

    public Long getPkOrg() {
        return pkOrg;
    }

    public void setPkOrg(Long pkOrg) {
        this.pkOrg = pkOrg;
    }

    public Long getPkManagedept() {
        return pkManagedept;
    }

    public void setPkManagedept(Long pkManagedept) {
        this.pkManagedept = pkManagedept;
    }

    public String getVbillcode() {
        return vbillcode;
    }

    public void setVbillcode(String vbillcode) {
        this.vbillcode = vbillcode;
    }

    public Long getPkCertiftype() {
        return pkCertiftype;
    }

    public void setPkCertiftype(Long pkCertiftype) {
        this.pkCertiftype = pkCertiftype;
    }

    public String getCertifcode() {
        return certifcode;
    }

    public void setCertifcode(String certifcode) {
        this.certifcode = certifcode;
    }

    public String getZjCode() {
        return zjCode;
    }

    public void setZjCode(String zjCode) {
        this.zjCode = zjCode;
    }

    public Long getPkCertpsn() {
        return pkCertpsn;
    }

    public void setPkCertpsn(Long pkCertpsn) {
        this.pkCertpsn = pkCertpsn;
    }

    public Integer getSbTotal() {
        return sbTotal;
    }

    public void setSbTotal(Integer sbTotal) {
        this.sbTotal = sbTotal;
    }

    public String getSbMonth() {
        return sbMonth;
    }

    public void setSbMonth(String sbMonth) {
        this.sbMonth = sbMonth;
    }

    public String getCertStatus() {
        return certStatus;
    }

    public void setCertStatus(String certStatus) {
        this.certStatus = certStatus;
    }

    public String getEffectTime() {
        return effectTime;
    }

    public void setEffectTime(String effectTime) {
        this.effectTime = effectTime;
    }

    public String getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getVgrantcertunit() {
        return vgrantcertunit;
    }

    public void setVgrantcertunit(String vgrantcertunit) {
        this.vgrantcertunit = vgrantcertunit;
    }

    public String getDgrantcertdate() {
        return dgrantcertdate;
    }

    public void setDgrantcertdate(String dgrantcertdate) {
        this.dgrantcertdate = dgrantcertdate;
    }

    public Long getReceiver() {
        return receiver;
    }

    public void setReceiver(Long receiver) {
        this.receiver = receiver;
    }

    public String getReceivedate() {
        return receivedate;
    }

    public void setReceivedate(String receivedate) {
        this.receivedate = receivedate;
    }

    public String getValidbegindate() {
        return validbegindate;
    }

    public void setValidbegindate(String validbegindate) {
        this.validbegindate = validbegindate;
    }

    public String getValidenddate() {
        return validenddate;
    }

    public void setValidenddate(String validenddate) {
        this.validenddate = validenddate;
    }

    public Long getPkVcertcorp() {
        return pkVcertcorp;
    }

    public void setPkVcertcorp(Long pkVcertcorp) {
        this.pkVcertcorp = pkVcertcorp;
    }

    public String getVoutcertcorp() {
        return voutcertcorp;
    }

    public void setVoutcertcorp(String voutcertcorp) {
        this.voutcertcorp = voutcertcorp;
    }

    public String getBoutunit() {
        return boutunit;
    }

    public void setBoutunit(String boutunit) {
        this.boutunit = boutunit;
    }

    public String getHasEffectiveDate() {
        return hasEffectiveDate;
    }

    public void setHasEffectiveDate(String hasEffectiveDate) {
        this.hasEffectiveDate = hasEffectiveDate;
    }

    public String getBisfee() {
        return bisfee;
    }

    public void setBisfee(String bisfee) {
        this.bisfee = bisfee;
    }

    public String getPkBilltype() {
        return pkBilltype;
    }

    public void setPkBilltype(String pkBilltype) {
        this.pkBilltype = pkBilltype;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getVmemo() {
        return vmemo;
    }

    public void setVmemo(String vmemo) {
        this.vmemo = vmemo;
    }

    public Long getPkDept() {
        return pkDept;
    }

    public void setPkDept(Long pkDept) {
        this.pkDept = pkDept;
    }

    public String getVbusitype() {
        return vbusitype;
    }

    public void setVbusitype(String vbusitype) {
        this.vbusitype = vbusitype;
    }

    public String getApprover() {
        return approver;
    }

    public void setApprover(String approver) {
        this.approver = approver;
    }

    public Date getTaudittime() {
        return taudittime;
    }

    public void setTaudittime(Date taudittime) {
        this.taudittime = taudittime;
    }

    public String getVapprovenote() {
        return vapprovenote;
    }

    public void setVapprovenote(String vapprovenote) {
        this.vapprovenote = vapprovenote;
    }

    public String getVdef1() {
        return vdef1;
    }

    public void setVdef1(String vdef1) {
        this.vdef1 = vdef1;
    }

    public String getVdef10() {
        return vdef10;
    }

    public void setVdef10(String vdef10) {
        this.vdef10 = vdef10;
    }

    public String getVdef2() {
        return vdef2;
    }

    public void setVdef2(String vdef2) {
        this.vdef2 = vdef2;
    }

    public String getVdef3() {
        return vdef3;
    }

    public void setVdef3(String vdef3) {
        this.vdef3 = vdef3;
    }

    public String getVdef4() {
        return vdef4;
    }

    public void setVdef4(String vdef4) {
        this.vdef4 = vdef4;
    }

    public String getVdef5() {
        return vdef5;
    }

    public void setVdef5(String vdef5) {
        this.vdef5 = vdef5;
    }

    public String getVdef6() {
        return vdef6;
    }

    public void setVdef6(String vdef6) {
        this.vdef6 = vdef6;
    }

    public String getVdef7() {
        return vdef7;
    }

    public void setVdef7(String vdef7) {
        this.vdef7 = vdef7;
    }

    public String getVdef8() {
        return vdef8;
    }

    public void setVdef8(String vdef8) {
        this.vdef8 = vdef8;
    }

    public String getVdef9() {
        return vdef9;
    }

    public void setVdef9(String vdef9) {
        this.vdef9 = vdef9;
    }

    public String getVoperscope() {
        return voperscope;
    }

    public void setVoperscope(String voperscope) {
        this.voperscope = voperscope;
    }

    public Integer getEnablestate() {
        return enablestate;
    }

    public void setEnablestate(Integer enablestate) {
        this.enablestate = enablestate;
    }

    public String getCardId() {
        return cardId;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }

    public String getPsnPhone() {
        return psnPhone;
    }

    public void setPsnPhone(String psnPhone) {
        this.psnPhone = psnPhone;
    }

    public String getPkSpecialType() {
        return pkSpecialType;
    }

    public void setPkSpecialType(String pkSpecialType) {
        this.pkSpecialType = pkSpecialType;
    }

    public String getPkSbzt() {
        return pkSbzt;
    }

    public void setPkSbzt(String pkSbzt) {
        this.pkSbzt = pkSbzt;
    }

    public String getPkYjdw() {
        return pkYjdw;
    }

    public void setPkYjdw(String pkYjdw) {
        this.pkYjdw = pkYjdw;
    }

    public String getIsZyzj() {
        return isZyzj;
    }

    public void setIsZyzj(String isZyzj) {
        this.isZyzj = isZyzj;
    }

    public Long getPkGlzyz() {
        return pkGlzyz;
    }

    public void setPkGlzyz(Long pkGlzyz) {
        this.pkGlzyz = pkGlzyz;
    }

    public Long getPkGlzcz() {
        return pkGlzcz;
    }

    public void setPkGlzcz(Long pkGlzcz) {
        this.pkGlzcz = pkGlzcz;
    }

    public Date getTs() {
        return ts;
    }

    public void setTs(Date ts) {
        this.ts = ts;
    }

    public String getApplydate() {
        return applydate;
    }

    public void setApplydate(String applydate) {
        this.applydate = applydate;
    }

    public String getApplyorgtype() {
        return applyorgtype;
    }

    public void setApplyorgtype(String applyorgtype) {
        this.applyorgtype = applyorgtype;
    }

    public String getApplyprofessor() {
        return applyprofessor;
    }

    public void setApplyprofessor(String applyprofessor) {
        this.applyprofessor = applyprofessor;
    }

    public String getApplyregdate() {
        return applyregdate;
    }

    public void setApplyregdate(String applyregdate) {
        this.applyregdate = applyregdate;
    }

    public Long getApplyer() {
        return applyer;
    }

    public void setApplyer(Long applyer) {
        this.applyer = applyer;
    }

    public Long getApplyerorg() {
        return applyerorg;
    }

    public void setApplyerorg(Long applyerorg) {
        this.applyerorg = applyerorg;
    }

    public String getApplyisinstore() {
        return applyisinstore;
    }

    public void setApplyisinstore(String applyisinstore) {
        this.applyisinstore = applyisinstore;
    }

    public String getIsDzzj() {
        return isDzzj;
    }

    public void setIsDzzj(String isDzzj) {
        this.isDzzj = isDzzj;
    }

    public String getYjIsrecevie() {
        return yjIsrecevie;
    }

    public void setYjIsrecevie(String yjIsrecevie) {
        this.yjIsrecevie = yjIsrecevie;
    }

    public String getDableddate() {
        return dableddate;
    }

    public void setDableddate(String dableddate) {
        this.dableddate = dableddate;
    }

    public String getPkUsedept() {
        return pkUsedept;
    }

    public void setPkUsedept(String pkUsedept) {
        this.pkUsedept = pkUsedept;
    }

    public String getDalterdate() {
        return dalterdate;
    }

    public void setDalterdate(String dalterdate) {
        this.dalterdate = dalterdate;
    }

    public String getPkUsecorp() {
        return pkUsecorp;
    }

    public void setPkUsecorp(String pkUsecorp) {
        this.pkUsecorp = pkUsecorp;
    }

    public String getApplybusicode() {
        return applybusicode;
    }

    public void setApplybusicode(String applybusicode) {
        this.applybusicode = applybusicode;
    }

    public String getApplybuzitype() {
        return applybuzitype;
    }

    public void setApplybuzitype(String applybuzitype) {
        this.applybuzitype = applybuzitype;
    }

    public String getApplycertowner() {
        return applycertowner;
    }

    public void setApplycertowner(String applycertowner) {
        this.applycertowner = applycertowner;
    }

    public String getApplycontacttype() {
        return applycontacttype;
    }

    public void setApplycontacttype(String applycontacttype) {
        this.applycontacttype = applycontacttype;
    }

    public BigDecimal getApplystandermny() {
        return applystandermny;
    }

    public void setApplystandermny(BigDecimal applystandermny) {
        this.applystandermny = applystandermny;
    }

    public BigDecimal getApplybasemny() {
        return applybasemny;
    }

    public void setApplybasemny(BigDecimal applybasemny) {
        this.applybasemny = applybasemny;
    }

    public String getApplyregcert() {
        return applyregcert;
    }

    public void setApplyregcert(String applyregcert) {
        this.applyregcert = applyregcert;
    }

    public String getApplyisreg() {
        return applyisreg;
    }

    public void setApplyisreg(String applyisreg) {
        this.applyisreg = applyisreg;
    }

    public String getApplyisuse() {
        return applyisuse;
    }

    public void setApplyisuse(String applyisuse) {
        this.applyisuse = applyisuse;
    }

    public String getApplyispleg() {
        return applyispleg;
    }

    public void setApplyispleg(String applyispleg) {
        this.applyispleg = applyispleg;
    }

    public String getApplyislock() {
        return applyislock;
    }

    public void setApplyislock(String applyislock) {
        this.applyislock = applyislock;
    }

    public String getApplyisusemore() {
        return applyisusemore;
    }

    public void setApplyisusemore(String applyisusemore) {
        this.applyisusemore = applyisusemore;
    }

    public String getApplyiscrosarea() {
        return applyiscrosarea;
    }

    public void setApplyiscrosarea(String applyiscrosarea) {
        this.applyiscrosarea = applyiscrosarea;
    }

    public String getApplyischanging() {
        return applyischanging;
    }

    public void setApplyischanging(String applyischanging) {
        this.applyischanging = applyischanging;
    }

    public String getApplyisborraw() {
        return applyisborraw;
    }

    public void setApplyisborraw(String applyisborraw) {
        this.applyisborraw = applyisborraw;
    }

    public String getApplyiseffect() {
        return applyiseffect;
    }

    public void setApplyiseffect(String applyiseffect) {
        this.applyiseffect = applyiseffect;
    }

    public String getExpireReason() {
        return expireReason;
    }

    public void setExpireReason(String expireReason) {
        this.expireReason = expireReason;
    }

    public List<CertifregBEntity> getCertifregBList() {
        return certifregBList;
    }

    public void setCertifregBList(List<CertifregBEntity> certifregBList) {
        this.certifregBList = certifregBList;
    }

    public List<CertifregFEntity> getCertifregFList() {
        return certifregFList;
    }

    public void setCertifregFList(List<CertifregFEntity> certifregFList) {
        this.certifregFList = certifregFList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
