package com.ejianc.certify.mapper;

import com.ejianc.certify.vo.SocialInsuranceVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.certify.bean.SocialInsuranceEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 社保档案
 *
 * @author generator
 *
 */
@Mapper
public interface SocialInsuranceMapper extends BaseCrudMapper<SocialInsuranceEntity> {

    @Select("SELECT pk_sbzt,sb_month FROM     bd_social_insurance " +
            "                        WHERE    pk_psnid = #{psnId} " +
            "                        AND      dr = 0 " +
            "                        ORDER BY sb_month desc")
    public List<SocialInsuranceEntity> getSubInfoByEmplID(@Param("psnId")Long psnId);

    @Select("SELECT * FROM bd_social_insurance WHERE dr = 0 and card_id = #{cardId} and sb_month = #{sbMonth}")
    SocialInsuranceVO getSocialInsuranceVoByCardId(@Param("cardId") String cardId, @Param("sbMonth") String sbMonth);
}
