package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifChangeFEntity;
import com.ejianc.certify.bean.CertifyChangeHEntity;
import com.ejianc.certify.bean.CertifySpecialReqBEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.service.ICertifySpecialReqBService;
import com.ejianc.certify.utils.RpcUtil;
import com.ejianc.certify.vo.*;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifySpecialReqMapper;
import com.ejianc.certify.bean.CertifySpecialReqEntity;
import com.ejianc.certify.service.ICertifySpecialReqService;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 特殊请示-表头
 * 
 * @author generator
 * 
 */
@Service("certifySpecialReqService")
public class CertifySpecialReqServiceImpl extends BaseServiceImpl<CertifySpecialReqMapper, CertifySpecialReqEntity> implements ICertifySpecialReqService{
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;

    @Autowired
    private ICertifySpecialReqBService bservice;


    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifySpecialReqEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifySpecialReqVO> vos = BeanMapper.mapList(list, CertifySpecialReqVO.class);
        return exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifySpecialReqVO> vos) {
        for (CertifySpecialReqVO vo : vos) {
            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            RpcUtil.checkRespData(org, true, "查询管理组织信息异常:" , org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            RpcUtil.checkRespData(applyer, true, "查询发起人员信息异常:" , applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            RpcUtil.checkRespData(applyerorg, true, "查询发起人组织信息异常:" , applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            Optional.ofNullable(vo.getVbusitype()).ifPresent(type -> {
                switch (vo.getVbusitype()){
                    case "1":
                        vo.setVbusitype("跨区借用");
                        break;
                    case "2":
                        vo.setVbusitype("一证多用");
                        break;
                    default:
                        break;
                }
            });


            Optional.ofNullable(vo.getBillState()).ifPresent(t -> vo.setBillStateName(BillStatusEnum.getDesc(t)));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }

    /**
     * @param param
     * @description 根据证照变更单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/25
     */
    @Override
    public CommonResponse<IPage<CertifySpecialReqBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifySpecialReqBEntity> page = bservice.queryPage(param, false);
        IPage<CertifySpecialReqBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifySpecialReqBVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @Override
    public IPage<CertifySpecialReqVO> refCertifyregHData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        /**用户权限*/
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /**处理SearchObject*/
        if (StringUtils.isNotEmpty(searchObject)) {
            //todo 处理SearchObject
            param.getParams().putAll(dealRefObject(searchObject,param));
        }
        IPage<CertifySpecialReqEntity> page = queryPage(param, false);
        IPage<CertifySpecialReqVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(),CertifySpecialReqVO.class));
        return pageData;
    }

    private Map<String, Parameter> dealRefObject(String searchObject, QueryParam param) {
        JSONObject object = JSONObject.parseObject(searchObject);
        Map<String, Parameter> result = new HashMap<>();

        for (String key : object.keySet()) {
            switch (key){
                case "applyer.name":            //申请人
                    //todo 需要平台提供根据姓名查询 api
//                    result.put("pkCertpsn",new Parameter(QueryParam.EQ,eid));
                    break;
                case "applyerorg.name":         //申请人组织
                    CommonResponse<OrgVO> applyerorgResp = iOrgApi.findByNameAndTenantId((String) object.get(key), InvocationInfoProxy.getTenantid());
                    OrgVO applyerorg = (OrgVO)RpcUtil.getRespData(applyerorgResp, true, "查询发起人组织异常:", applyerorgResp.getMsg());
                    result.put("applyerorg",new Parameter(QueryParam.EQ,applyerorg.getId()));
                    break;
                case "pkOrg.name":              //管理组织
                    CommonResponse<OrgVO> pkOrgResp = iOrgApi.findByNameAndTenantId((String) object.get(key), InvocationInfoProxy.getTenantid());
                    OrgVO pkOrg = (OrgVO)RpcUtil.getRespData(pkOrgResp, true, "查询发起人组织异常:", pkOrgResp.getMsg());
                    result.put("pkOrg",new Parameter(QueryParam.EQ,pkOrg.getId()));
                    break;
                default:
                    result.put(key,new Parameter(QueryParam.EQ,object.get(key)));
                    break;
            }
        }
        return result;
    }
}
