package com.ejianc.certify.service.impl;

import com.ejianc.certify.vo.CorpCertifHVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CorpCertifHMapper;
import com.ejianc.certify.bean.CorpCertifHEntity;
import com.ejianc.certify.service.ICorpCertifHService;

/**
 * 证件借用配件-表头
 * 
 * @author generator
 * 
 */
@Service("corpCertifHService")
public class CorpCertifHServiceImpl extends BaseServiceImpl<CorpCertifHMapper, CorpCertifHEntity> implements ICorpCertifHService{

    private static final String BILL_CODE = "H513";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public boolean scbill(CorpCertifHVO saveOrUpdateVO) {
        CorpCertifHEntity entity = BeanMapper.map(saveOrUpdateVO, CorpCertifHEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setVbillcode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            CommonResponse<BillTypeVO> billType = billTypeApi.getByCode("BT202205000009");
            if(billType.isSuccess()){
                entity.setPkBilltype(billType.getData().getId());
            }else{
                throw new BusinessException("网络异常， 单据类型获取失败， 请稍后再试");
            }
        }
        return this.saveOrUpdate(entity, false);
    }
}
