package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.InspectionBEntity;
import com.ejianc.certify.mapper.InspectionBMapper;
import com.ejianc.certify.service.IInspectionBService;
import com.ejianc.certify.vo.InspectionBVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 迎检登记-表体
 *
 * @author generator
 *
 */
@Service("inspectionBService")
public class InspectionBServiceImpl extends BaseServiceImpl<InspectionBMapper, InspectionBEntity> implements IInspectionBService{

    @Override
    public CommonResponse<IPage<InspectionBVO>> queryBPageByHParm(QueryParam param) {
        IPage<InspectionBEntity> page = this.queryPage(param,false);
        IPage<InspectionBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InspectionBVO.class));

        return CommonResponse.success("查询明细数据成功！",pageData);
    }
}
