package com.ejianc.certify.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.vo.SocialInsuranceVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.SocialInsuranceMapper;
import com.ejianc.certify.bean.SocialInsuranceEntity;
import com.ejianc.certify.service.ISocialInsuranceService;

import java.util.List;

/**
 * 社保档案
 *
 * @author generator
 *
 */
@Service("socialInsuranceService")
public class SocialInsuranceServiceImpl extends BaseServiceImpl<SocialInsuranceMapper, SocialInsuranceEntity> implements ISocialInsuranceService{
    @Autowired
    private IDefdocApi iDefdocApi;


    private static final String SOCIAL_SUBJECT_DEF_CODE = "credentials-social_security_subjects";

    @Override
    public SocialInsuranceVO getSocialInsuranceVoByCardId(String cardId, String sbMonth) {
        return this.getBaseMapper().getSocialInsuranceVoByCardId(cardId,sbMonth);
    }

    @Autowired
    private SocialInsuranceMapper socialInsuranceMapper;

    /**
     * @description  根据员工ID获取最新社保主体相关信息
     * @author yxm
     * @date 2022/5/12
     */
    @Override
    public CommonResponse<SocialInsuranceVO> getSubInfoByEmplID(Long pkPsnid) {
        SocialInsuranceVO result = new SocialInsuranceVO();
        List<SocialInsuranceEntity> infos = socialInsuranceMapper.getSubInfoByEmplID(pkPsnid);
        if (infos.size() > 0) {
            result.setPkSbzt(infos.get(0).getPkSbzt());
            result.setLastSbMonth(infos.get(0).getSbMonth());
            result.setTotalSbMonth(infos.size());
            return CommonResponse.success(result);
        }else{
            return CommonResponse.error("没有找到社保缴纳记录");
        }
    }

    @Override
    public CommonResponse<IPage<DefdocDetailVO>> refSocialSubjectData(String condition, String searchObject, String searchText) {

        CommonResponse<List<DefdocDetailVO>> defCode = iDefdocApi.getDefDocByDefCode(SOCIAL_SUBJECT_DEF_CODE);
        if (defCode.isSuccess()) {
            IPage<DefdocDetailVO> pageData = new Page<>(1L,defCode.getData().size(),defCode.getData().size());
            pageData.setRecords(defCode.getData());
            return CommonResponse.success(pageData);
        }else{
            return CommonResponse.error(defCode.getMsg());
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public SocialInsuranceVO getSubIdByName(String name) {
        CommonResponse<DefdocVO> defdoc = iDefdocApi.getDefdocByDefCode(SOCIAL_SUBJECT_DEF_CODE);
        getRespData(defdoc, true, "获取社保主体信息失败:"+defdoc.getMsg());
        CommonResponse<DefdocDetailVO> subInfo = iDefdocApi.getDefDocByName(defdoc.getData().getId(), name);
        getRespData(subInfo, true, "获取社保主体信息失败:"+defdoc.getMsg());
        SocialInsuranceVO sbzt = new SocialInsuranceVO();
        sbzt.setPkSbzt(subInfo.getData().getId());
        sbzt.setSbztType(subInfo.getData().getDescription());
        return sbzt;
    }
}
