package com.ejianc.certify.aop;

import com.ejianc.certify.annotation.AccPostOperation;
import com.ejianc.certify.el.ExpressionEvaluator;
import com.ejianc.certify.service.IAccPostService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/***
 * @ClassName CertifyOperationAop
 * @author kuangpengfei
 * @date 2022年06月15日 10:50
 * @Version 1.0
 * @Description TODO 自定义切面方法实现
 */

@Component
@Aspect
@Slf4j
public class AccPostOperationAop {

    @Autowired
    public IAccPostService accountBaseService;

    private ExpressionEvaluator evaluator = new ExpressionEvaluator<>();

    @Pointcut("@annotation(com.ejianc.certify.annotation.AccPostOperation)")
    private void handleMethod() {

    }

    /**
     * 后置通知
     * @AccPostOperation(attachmentId = "#id")
     * returnVal,切点方法执行后的返回值
     */
    @AfterReturning(value = "handleMethod()",returning="returnVal" )
    public void afterReturning(JoinPoint joinPoint,Object returnVal) {
        String attachmentId = getAttachmentId(joinPoint);
        log.info("=====================attachmentId:{}",attachmentId);
        accountBaseService.insertPost(attachmentId);
    }

    private AccPostOperation getDistributeHandler(JoinPoint joinPoint){
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        return method.getAnnotation(AccPostOperation.class);
    }

    private String getAttachmentId(JoinPoint joinPoint) {
        AccPostOperation handler = getDistributeHandler(joinPoint);
        if (joinPoint.getArgs() == null) {
            return null;
        }
        EvaluationContext evaluationContext = evaluator.createEvaluationContext(joinPoint.getTarget(), joinPoint.getTarget().getClass(), ((MethodSignature) joinPoint.getSignature()).getMethod(), joinPoint.getArgs());
        AnnotatedElementKey methodKey = new AnnotatedElementKey(((MethodSignature) joinPoint.getSignature()).getMethod(), joinPoint.getTarget().getClass());
        return (String) evaluator.condition(handler.attachmentId(), methodKey, evaluationContext, String.class);
    }
}