package com.ejianc.certify.bip;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.certify.log.OtherLogUtil;
import com.ejianc.certify.utils.HttpClientTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/***
 * @ClassName BipUtil
 * @author kuangpengfei
 * @date 2022年06月14日 9:55
 * @Version 1.0
 * @Description TODO
 */
@Component
public class BipUtil {
    @Value("${bip.fsaddr}")
    public String fsUrl;
    @Value("${bip.deladdr}")
    public String delUrl;
    @Value("${bip.ybaddr}")
    public String ybUrl;
    @Value("${bip.APIKey}")
    public String apikey;
    @Autowired
    private OtherLogUtil otherLogUtil;

    /**
     * 待办发送
     * @param pkOrg
     * @param id
     * @param billCode
     * @param billType
     * @param new_url
     * @param type
     * @param subject
     * @param username
     * @param mobileLink
     * @param doccreator
     */
    public void sendNotify(String pkOrg,String id,String billCode,String billType,String new_url,int type,String subject,
                           String username,String mobileLink,String doccreator) {
        NotifyTodoSendContext context = new NotifyTodoSendContext();
        context.setAppName("certificat");
        //待办唯一标识，待办在原系统唯一标识，不允许为空。
        context.setModelId(id);
        context.setLink(new_url);
        //待办类型，1:表示审批类待办 2:表示为通知类待办 3; 表示为沟通类待办，待办中心列表会显示沟通状态图标，不允许为空
        context.setType(type);
        context.setModelName("certificat");
        context.setSubject(subject);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String nowTime = dtf.format(Instant.now());
        context.setCreateTime(nowTime);
        context.setTargets("{\"LoginName\":\"" + username + "\"}");
        context.setLevel(3);
        context.setMobileLink(mobileLink);
        //是否红黄灯 默认为否，暂时没有该功能bip要求不允许为空，所以默认个0
        context.setIsdeadline("0");
        // 单据的提交人
        context.setDocCreator("{\"LoginName\":\"" + doccreator + "\"}");
        //待办关键字，用于区分不同组织体系的待办， 如 01:2007体系，02：物业服务，03：战略联盟，04：博实乐教育，可为空。
        context.setZtxfl("");

        Boolean isscuess = Boolean.FALSE;
        String msg = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arg0", JSONObject.parseObject(JSONObject.toJSONString(context)));
        String request = jsonObject.toString();
        String result = "";
        try {
            long begin = System.currentTimeMillis();
            result = HttpClientTool.sendJsonPostApikey(fsUrl, request, apikey);
            JSONObject resultJson =JSONObject.parseObject(result).getJSONObject("return");
            long end = System.currentTimeMillis();
            if (resultJson != null) {
                // 正常的情况
                if ("2".equals(String.valueOf(resultJson.get("returnState")))) {
                    isscuess = Boolean.TRUE;
                    msg +=  "单据[" + id + "]推送成功，BIP返回成功,耗时：["+ (end - begin) / 1000 + "]秒,";
                } else {
                    String bipmsg = String.valueOf(resultJson.get("message"));
                    msg += "单据[" + id + "]推送失败，BIP返回失败,耗时：[" + (end - begin) / 1000 + "]秒,原因是" + bipmsg + ",";
                }
            }else{
                msg += "单据[" + id + "]推送时，bip返回的resultJson为空";
            }
        } catch (Exception e) {
            msg = e.getMessage();
            e.printStackTrace();
        }
        //记录日志表
        otherLogUtil.insertLogRequst(pkOrg,id,
                billCode,billType,request, result,msg,isscuess.toString(),"bip-send");
    }

    /**
     * 待办删除
     * @param pkOrg
     * @param id
     * @param billCode
     * @param billType
     */
    public void deleteNotify(String pkOrg,String id,String billCode,String billType) {
        NotifyTodoRemoveContext context = new NotifyTodoRemoveContext();
        context.setAppName("certificat");
        context.setModelName("certificat");
        context.setModelId(id);
        context.setOptType(1);
        context.setZtxfl("02");

        Boolean isscuess = Boolean.FALSE;
        String msg = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arg0", JSONObject.parseObject(JSONObject.toJSONString(context)));
        String request = jsonObject.toString();
        String result = "";
        try {
            long begin = System.currentTimeMillis();
            result = HttpClientTool.sendJsonPostApikey(delUrl, request, apikey);
            JSONObject resultJson =JSONObject.parseObject(result).getJSONObject("return");
            long end = System.currentTimeMillis();
            if (resultJson != null) {
                // 正常的情况
                if ("2".equals(String.valueOf(resultJson.get("returnState")))) {
                    isscuess = Boolean.TRUE;
                    msg +=  "单据[" + id + "]推送成功，BIP返回成功,耗时：["+ (end - begin) / 1000 + "]秒,";
                } else {
                    String bipmsg = String.valueOf(resultJson.get("message"));
                    msg += "单据[" + id + "]推送失败，BIP返回失败,耗时：[" + (end - begin) / 1000 + "]秒,原因是" + bipmsg + ",";
                }
            }else{
                msg += "单据[" + id + "]推送时，bip返回的resultJson为空";
            }
        } catch (Exception e) {
            msg = e.getMessage();
            e.printStackTrace();
        }
        //记录日志表
        otherLogUtil.insertLogRequst(pkOrg,id,
                billCode,billType,request, result,msg,isscuess.toString(),"bip-del");
    }

    /**
     * 待办已办
     * @param pkOrg
     * @param id
     * @param billCode
     * @param billType
     */
    public void doneNotify(String pkOrg,String id,String billCode,String billType) {
        NotifyTodoRemoveContext context = new NotifyTodoRemoveContext();
        context.setAppName("certificat");
        context.setModelName("certificat");
        context.setModelId(id);
        context.setOptType(1);
        context.setZtxfl("02");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        context.setEndTime(dtf.format(LocalDateTime.now()));
        context.setOpinion("已处理");

        Boolean isscuess = Boolean.FALSE;
        String msg = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arg0", JSONObject.parseObject(JSONObject.toJSONString(context)));
        String request = jsonObject.toString();
        String result = "";
        try {
            long begin = System.currentTimeMillis();
            result = HttpClientTool.sendJsonPostApikey(ybUrl, request, apikey);
            JSONObject resultJson =JSONObject.parseObject(result).getJSONObject("return");
            long end = System.currentTimeMillis();
            if (resultJson != null) {
                // 正常的情况
                if ("2".equals(String.valueOf(resultJson.get("returnState")))) {
                    isscuess = Boolean.TRUE;
                    msg +=  "单据[" + id + "]推送成功，BIP返回成功,耗时：["+ (end - begin) / 1000 + "]秒,";
                } else {
                    String bipmsg = String.valueOf(resultJson.get("message"));
                    msg += "单据[" + id + "]推送失败，BIP返回失败,耗时：[" + (end - begin) / 1000 + "]秒,原因是" + bipmsg + ",";
                }
            }else{
                msg += "单据[" + id + "]推送时，bip返回的resultJson为空";
            }
        } catch (Exception e) {
            msg = e.getMessage();
            e.printStackTrace();
        }
        //记录日志表
        otherLogUtil.insertLogRequst(pkOrg,id,
                billCode,billType,request, result,msg,isscuess.toString(),"bip-done");
    }
}
