package com.ejianc.certify.config;

import com.ejianc.certify.threadpool.MdgThreadPool;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author yxm
 * @date 2022/6/14
 * @description 主数据线程池
 */
@Configuration
@EnableAsync
public class MdgThradPoolConfig {
    /**
     * 核心线程数（默认线程数）
     */
    @Value("${mdg.pool.corePoolSize}")
    private int corePoolSize;
    /**
     * 最大线程数
     */
    @Value("${mdg.pool.maxPoolSize}")
    private int maxPoolSize;
    /**
     * 允许线程空闲时间（单位：默认为秒）
     */
    @Value("${mdg.pool.keepAliveTime}")
    private  int keepAliveTime;
    /**
     * 缓冲队列大小
     */
    @Value("${mdg.pool.queueCapacity}")
    private  int queueCapacity;
    /**
     * 线程池名前缀
     */
    private static final String threadNamePrefix = "mdg-callback-";

    @Bean("mdgExecutor") // bean的名称，默认为首字母小写的方法名
    public ThreadPoolTaskExecutor taskExecutor() {
        MdgThreadPool executor = new MdgThreadPool();

//        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setKeepAliveSeconds(keepAliveTime);
        executor.setThreadNamePrefix(threadNamePrefix);

        // 线程池对拒绝任务的处理策略
        // CallerRunsPolicy：由调用线程（提交任务的线程）处理该任务
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        // 初始化
        executor.initialize();
        return executor;
    }

}
