package com.ejianc.certify.runner;

import com.ejianc.certify.bean.MdgLogEntity;
import com.ejianc.certify.service.IMdgLogService;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * @author yxm
 * @date 2022/6/14
 * @description 主数据线程池任务初始化
 */
@Component
public class MdgTaskRunner implements CommandLineRunner {
    @Autowired
    private IMdgLogService mdgService;


    /**
     * @description  将主数据日志表中接口成功标识为空的数据进行处理后回调
     * @author yxm
     * @date 2022/6/14
     * @return
     */
    @Override
    public void run(String... args) throws Exception {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("issuccessNs",new Parameter(QueryParam.EQ,null));
        queryParam.setPageSize(-1);
        List<MdgLogEntity> entities = mdgService.queryList(queryParam);
        entities.forEach(entity -> {
            mdgService.callBackMdg(entity);
        });
    }
}
