package com.ejianc.certify.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.certify.vo.CertifregBVO;
import com.ejianc.certify.vo.CertifregFVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.certify.bean.CertifyregHEntity;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;

/**
 * 证照登记单-表头
 * 
 * @author generator
 * 
 */
public interface ICertifyregHService extends IBaseService<CertifyregHEntity> {

    /**
     * @description    根据证照登记单参数分页查询变更记录
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param);

    /**
     * @description    根据证照登记单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param);

    /**
     * @description    excel导出
     * @author yxm
     * @date 2022/5/13
     * @param param
     */
    public Map<String, Object> excelExport(QueryParam param);

    /**
     * @description    excel导出
     * @author yxm
     * @date 2022/5/13
     * @param fileMap
     */
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap);

    /**
     * @description  批量上传扫描单
     * @author yxm
     * @date 2022/5/20
     */
    public CommonResponse<String> scanBillImport(List<AttachmentVO> attachs);

    /**
     * @description  生成条形码
     * @author yxm
     * @date 2022/5/20
     * @param id
     */
    public CommonResponse<String> GenBarCode(Long id);

    public IPage<CertifyregHVO> refCertifyregHData(Integer pageNumber,Integer pageSize,
                                                   String condition, String searchObject,
                                                   String searchText);
}
