package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccInspectionEntity;
import com.ejianc.certify.bean.InspectionBEntity;
import com.ejianc.certify.bean.InspectionEntity;
import com.ejianc.certify.mapper.AccInspectionMapper;
import com.ejianc.certify.service.IAccInspectionService;
import com.ejianc.certify.service.IInspectionService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 迎检登记补贴表
 * 费用核算时，判断人员id、pk_inspection以及迎检登记费用类型是否存在费用核算表中，若存在则表明已经计费过
 * @author generator
 * 
 */
@Slf4j
@Service("accInspectionService")
public class AccInspectionServiceImpl extends BaseServiceImpl<AccInspectionMapper, AccInspectionEntity> implements IAccInspectionService {
    @Autowired
    private IInspectionService iInspectionService;
    @Autowired
    private IEmployeeApi iEmplApi;

    @Override
    public List<AccInspectionEntity> selectInspection(String id) {
        List<AccInspectionEntity> accInspectionList = new ArrayList<>();
        InspectionEntity inspection = iInspectionService.selectById(id);
        List<InspectionBEntity> inspectionBList = inspection.getInspectionBList();

        for (InspectionBEntity inspectionB : inspectionBList) {
            if ("0".equals(inspectionB.getIsxyyj()) && "0".equals(inspectionB.getIscc())) {
                CommonResponse<EmployeeVO> resp = iEmplApi.getById(inspectionB.getPkCertpsn());
                if (!resp.isSuccess()) {
                    log.error("******************调用人员查询rpc服务失败：{}", resp.getMsg());
                }
                //if 是 外部人员 则登记，待补充条件*******************************************************************
                AccInspectionEntity accInspection = new AccInspectionEntity();
                accInspection.setPkInspection(inspection.getId());
                accInspection.setPkPsndoc(inspectionB.getPkCertpsn());
                accInspection.setPkCertifreg(inspectionB.getPkCertifreg());
                accInspection.setPkCertiftype(inspectionB.getPkCertiftype());
                accInspection.setPsncode(resp.getData().getCode());
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowTime = dtf.format(Instant.now());
                accInspection.setDjmonth(nowTime);
                accInspection.setIsjf("0");
                accInspection.setLastjfdate(nowTime);
                accInspection.setPkProject(inspection.getPkProject());
                accInspection.setPkPmproject(inspection.getPkPmproject());
                accInspection.setPkPmprojectJlb(inspection.getPkPmprojectJlb());

                accInspectionList.add(accInspection);
            }
        }
        return accInspectionList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void insertAccInspection(String id) {
        List<AccInspectionEntity> entityList = selectInspection(id);
        if(CollectionUtils.isNotEmpty(entityList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("pkInspection", new Parameter(QueryParam.EQ, id));
            List<AccInspectionEntity> accInspectionList = this.queryList(param);

            if (CollectionUtils.isNotEmpty(accInspectionList)) {
            /*Map<Long, AccInspectionEntity> wifeMap = entityList.stream().collect(
                    Collectors.toMap(w -> w.getPkPsndoc(),
                            w -> w));
            List<AccInspectionEntity> families = accInspectionList.stream().map(husband -> {
                AccInspectionEntity wife = wifeMap.get(husband.getPkPsndoc());
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowTime = dtf.format(Instant.now());
                husband.setDjmonth(nowTime);
                return husband;
            }).collect(Collectors.toList());*/
                this.removeByIds(accInspectionList.stream().map(AccInspectionEntity::getId).collect(Collectors.toList()), true);
            }
            this.saveOrUpdateBatch(entityList, 50);
        }
    }
}
