package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccPostEntity;
import com.ejianc.certify.bean.PostAllowanceBEntity;
import com.ejianc.certify.bean.PostAllowanceEntity;
import com.ejianc.certify.mapper.AccPostMapper;
import com.ejianc.certify.service.IAccPostService;
import com.ejianc.certify.service.IPostAllowanceService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 岗位补贴表
 * 费用核算时，根据最后计费日期\补贴起算时间(哪个日期大，则以此日期算起)和核算日期来计费用
 * @author generator
 * 
 */
@Slf4j
@Service("accPostService")
public class AccPostServiceImpl extends BaseServiceImpl<AccPostMapper, AccPostEntity> implements IAccPostService{
    @Autowired
    private IEmployeeApi iEmplApi;
    @Autowired
    private IPostAllowanceService postAllowanceService;

    @Override
    public List<AccPostEntity> selectPost(String id) {
        List<AccPostEntity> accPostEntityList = new ArrayList<>();
        PostAllowanceEntity postAll = postAllowanceService.selectById(id);
        List<PostAllowanceBEntity> postAllowanceBList = null;//postAll.get;

       for (PostAllowanceBEntity bEntity : postAllowanceBList) {
           AccPostEntity accPost = new AccPostEntity();
           accPost.setPkPost(postAll.getId());
           accPost.setPkPsndoc(bEntity.getPkPsndoc());
           CommonResponse<EmployeeVO> resp = iEmplApi.getById(bEntity.getPkPsndoc());
           if (!resp.isSuccess()) {
               log.error("******************调用人员查询rpc服务失败：{}", resp.getMsg());
           }
           accPost.setPsncode(resp.getData().getCode());
           accPost.setStartTime(bEntity.getBtStarttime());
           accPost.setExpireTime(bEntity.getBtEndtime());
           accPost.setIsstop(StringUtils.isNotEmpty(bEntity.getBtEndtime())?"0":"1");
           accPost.setIsjf("0".equals(accPost.getIsstop())?"1":"0");
           accPostEntityList.add(accPost);
        }
        return accPostEntityList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void insertPost(String id) {
        List<AccPostEntity> entityList = selectPost(id);
        if (CollectionUtils.isNotEmpty(entityList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("pkPost", new Parameter(QueryParam.EQ, id));
            List<AccPostEntity> baseEntityList = this.queryList(param);
            List<AccPostEntity> updateList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(baseEntityList)) {
                Map<Long, AccPostEntity> oldMap = baseEntityList.stream().collect(
                        Collectors.toMap(w -> w.getPkPsndoc(),
                                w -> w));
                entityList.forEach(e -> {
                    if (oldMap.containsKey(e.getPkPsndoc())) {
                        AccPostEntity accPost = oldMap.get(e.getPkPsndoc());
                        accPost.setStartTime(e.getStartTime());
                        accPost.setExpireTime(e.getExpireTime());
                        accPost.setIsstop(e.getIsstop());
                        accPost.setIsjf(e.getIsjf());
                        updateList.add(accPost);
                    } else {
                        e.setLastjfdate(e.getStartTime());
                        updateList.add(e);
                    }
                });
                if (updateList.size() > 0) {
                    this.saveOrUpdateBatch(updateList, 50);
                }
            } else {
                entityList.forEach(e -> e.setLastjfdate(e.getStartTime()));
                this.saveOrUpdateBatch(entityList, 50);
            }
        }
    }
}
