package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccSealEntity;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.bean.CorpSealApplyEntity;
import com.ejianc.certify.mapper.AccSealMapper;
import com.ejianc.certify.service.IAccSealService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.certify.service.ICorpSealApplyService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用印补贴表
 * 费用核算时，判断人员id、pk_seal以及用印补贴费用类型是否存在费用核算表中，若存在则表明已经计费过
 * @author generator
 * 
 */
@Slf4j
@Service("accSealService")
public class AccSealServiceImpl extends BaseServiceImpl<AccSealMapper, AccSealEntity> implements IAccSealService{
    @Autowired
    private ICorpSealApplyService sealApplyService;
    @Autowired
    private IEmployeeApi iEmplApi;
    @Autowired
    private ICertifyregHService certifyregHService;

    @Override
    public AccSealEntity selectAccSeal(String id) {
        CorpSealApplyEntity sealApply = sealApplyService.selectById(id);
        //若同一个印章在同一个项目盖过一次，则后面的不再算补贴
        Long pkCertifreg = sealApply.getPkCertifreg();
        Long pkProject = sealApply.getPkProject();
        AccSealEntity accSeal = new AccSealEntity();
        QueryParam param = new QueryParam();
        param.getParams().put("pkCertifreg", new Parameter(QueryParam.EQ, pkCertifreg));
        param.getParams().put("pkProject", new Parameter(QueryParam.EQ, pkProject));
        List<CorpSealApplyEntity> sealApplyList = sealApplyService.queryList(param);
        if(CollectionUtils.isNotEmpty(sealApplyList) && sealApplyList.size() > 1){
           //如该印章为首次使用至该该标书/项目/用途，则计算一次使用补贴。如该次补贴非持证人的首次印章补贴，则按一证多用标准，计算多使用的次数。
            accSeal.setFeetype("2");
        }else {
            accSeal.setFeetype("1");
        }
        CommonResponse<EmployeeVO> resp = iEmplApi.getById(sealApply.getPkFqr());
        if (!resp.isSuccess()) {
            log.error("******************调用人员查询rpc服务失败：{}", resp.getMsg());
        }
        accSeal.setPkSeal(sealApply.getId());
        CertifyregHEntity certifyregH = certifyregHService.getById(sealApply.getPkCertifreg());
        accSeal.setPkPsndoc(certifyregH.getPkCertpsn());
        accSeal.setPkCertiftype(certifyregH.getPkCertiftype());
        accSeal.setPkCertifreg(sealApply.getPkCertifreg());
        accSeal.setPsncode(resp.getData().getCode());
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String nowTime = dtf.format(Instant.now());
        accSeal.setDjmonth(nowTime);
        accSeal.setIsjf("0");
        accSeal.setLastjfdate(nowTime);
        accSeal.setPkProject(sealApply.getPkProject());
        accSeal.setPkPmproject(sealApply.getPkPmproject());
        accSeal.setPkPmprojectJlb(sealApply.getPkPmprojectJlb());

        return accSeal;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void insertAccSeal(String id) {
        AccSealEntity entityList = selectAccSeal(id);
        if(entityList != null) {
            QueryParam param = new QueryParam();
            param.getParams().put("pkSeal", new Parameter(QueryParam.EQ, id));
            List<AccSealEntity> accSealList = this.queryList(param);

            if (CollectionUtils.isNotEmpty(accSealList)) {
                this.removeByIds(accSealList.stream().map(AccSealEntity::getId).collect(Collectors.toList()), true);
            }
            this.saveOrUpdate(entityList);
        }
    }
}
