package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccUseEntity;
import com.ejianc.certify.bean.CertifySpecialReqEntity;
import com.ejianc.certify.bean.CorpCertifFEntity;
import com.ejianc.certify.bean.CorpCertifHEntity;
import com.ejianc.certify.mapper.AccUseMapper;
import com.ejianc.certify.service.IAccUseService;
import com.ejianc.certify.service.ICertifySpecialReqService;
import com.ejianc.certify.service.ICorpCertifHService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 用证补贴表
 * 
 * @author generator
 * 
 */
@Slf4j
@Service("accUseService")
public class AccUseServiceImpl extends BaseServiceImpl<AccUseMapper, AccUseEntity> implements IAccUseService{
    @Autowired
    private IEmployeeApi iEmplApi;
    @Autowired
    private ICorpCertifHService certifHService;
    @Autowired
    private ICertifySpecialReqService specialReqService;

    @Override
    public List<AccUseEntity> selectUse(String id) {
        List<AccUseEntity> useEntityList = new ArrayList<>();
        CorpCertifHEntity corpCertifH = certifHService.selectById(id);
        List<CorpCertifFEntity> corpCertifFVOList =corpCertifH.getCorpCertifFVOList();

        for (CorpCertifFEntity bEntity : corpCertifFVOList) {
            if("1".equals(corpCertifH.getVbusitype())) {
                AccUseEntity useEntity = new AccUseEntity();
                useEntity.setPkUse(corpCertifH.getId());
                useEntity.setPkPsndoc(bEntity.getPkCertpsn());
                CommonResponse<EmployeeVO> resp = iEmplApi.getById(bEntity.getPkCertpsn());
                if (!resp.isSuccess()) {
                    log.error("******************调用人员查询rpc服务失败：{}", resp.getMsg());
                }
                useEntity.setPsncode(resp.getData().getCode());
                useEntity.setPkCertifreg(bEntity.getPkCertifreg());
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowTime = dtf.format(Instant.now());
                useEntity.setStartTime(nowTime);
                if ("1".equals(bEntity.getIsbjsuccess()) || bEntity.getPkReplaceCertifreg() != null) {
                    useEntity.setExpireTime(nowTime);
                    useEntity.setIsstop("0");
                    useEntity.setIsjf("1");
                } else{
                    useEntity.setIsstop("1");
                    useEntity.setIsjf("0");
                }
                if(null !=corpCertifH.getPkSpecialreq()){
                    CertifySpecialReqEntity specialReq = specialReqService.getById(corpCertifH.getPkSpecialreq());
                    if("2".equals(specialReq.getVbusitype())){

                        useEntity.setFeetype("2");
                    }
                }else{
                    useEntity.setFeetype("1");
                }
                useEntity.setPkProject(corpCertifH.getPkProject());
                useEntity.setPkPmproject(corpCertifH.getPkPmproject());
                useEntity.setPkPmprojectJlb(corpCertifH.getPkPmprojectJlb());

                useEntityList.add(useEntity);
            }
        }
        return useEntityList;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void insertUse(String id) {
        List<AccUseEntity> entityList = selectUse(id);
        if (CollectionUtils.isNotEmpty(entityList)) {
            QueryParam param = new QueryParam();
            param.getParams().put("pkUse", new Parameter(QueryParam.EQ, id));
            List<AccUseEntity> baseEntityList = this.queryList(param);
            List<AccUseEntity> updateList = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(baseEntityList)) {
                Map<Long, AccUseEntity> oldMap = baseEntityList.stream().collect(
                        Collectors.toMap(w -> w.getPkPsndoc(),
                                w -> w));
                entityList.forEach(e -> {
                    if (oldMap.containsKey(e.getPkPsndoc())) {
                        AccUseEntity accPost = oldMap.get(e.getPkPsndoc());
                        accPost.setStartTime(e.getStartTime());
                        accPost.setExpireTime(e.getExpireTime());
                        accPost.setIsstop(e.getIsstop());
                        accPost.setIsjf(e.getIsjf());
                        updateList.add(accPost);
                    } else {
                        e.setLastjfdate(e.getStartTime());
                        updateList.add(e);
                    }
                });
                if (updateList.size() > 0) {
                    this.saveOrUpdateBatch(updateList, 50);
                }
            } else {
                entityList.forEach(e -> e.setLastjfdate(e.getStartTime()));
                this.saveOrUpdateBatch(entityList, 50);
            }
        }
    }
}
