package com.ejianc.certify.service.impl;

import com.ejianc.certify.bean.AccountBaseEntity;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.mapper.AccountBaseMapper;
import com.ejianc.certify.service.IAccountBaseService;
import com.ejianc.certify.service.ICertifyregHService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 基本补贴表
 * 费用核算时，根据最后计费日期和核算日期来计费用
 * @author generator
 * 
 */
@Slf4j
@Service("accountBaseService")
public class AccountBaseServiceImpl extends BaseServiceImpl<AccountBaseMapper, AccountBaseEntity> implements IAccountBaseService{
    @Autowired
    private ICertifyregHService certifyregHService;
    @Autowired
    private IEmployeeApi iEmplApi;

    /**
     * @param id 证件登记id
     * @return
     */
    @Override
    public AccountBaseEntity selectCertifyInfo(String id) {
        CertifyregHEntity certifyregH = certifyregHService.selectById(id);
        CommonResponse<EmployeeVO> resp = iEmplApi.getById(certifyregH.getPkCertpsn());
        if(!resp.isSuccess()) {
            log.error("******************调用人员查询rpc服务失败：{}",resp.getMsg());
            //throw new BusinessException(StringUtils.isNoneBlank(resp.getMsg()) ? resp.getMsg() : "调用Rpc服务失败");
        }
        AccountBaseEntity accountBase = new AccountBaseEntity();
        accountBase.setPkPsndoc(certifyregH.getPkCertpsn());
        accountBase.setPsncode(resp.getData().getCode());
        accountBase.setPkCertifreg(certifyregH.getId());
        accountBase.setPkCertiftype(certifyregH.getPkCertiftype());
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String nowTime = dtf.format(Instant.now());
        accountBase.setDjmonth(certifyregH.getEffectTime());
        accountBase.setExpireTime(certifyregH.getExpireTime());
        //accountBase.setLastjfdate(certifyregH.getEffectTime());
        accountBase.setCreateTime(certifyregH.getCreateTime());
        accountBase.setCreateUserCode(certifyregH.getCreateUserCode());
        if(nowTime.compareTo(certifyregH.getExpireTime()) == -1) {
            accountBase.setIsstop("1");
            accountBase.setStopTime("");
        }else {
            accountBase.setIsstop("0");
            accountBase.setStopTime("有效期过期");
        }
        return accountBase;
    }

    /**
     *
     * @param id
     * @param saveOrUpdate
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void insertAccBase(String id,String saveOrUpdate) {
        if ("1".equals(saveOrUpdate)){
            AccountBaseEntity accountBase = selectCertifyInfo(id);
            accountBase.setLastjfdate(accountBase.getDjmonth());
            AccountBaseEntity baseEntity = BeanMapper.map(accountBase, AccountBaseEntity.class);

            accountBase.setBttype("1");
            this.saveOrUpdate(accountBase);

            baseEntity.setBttype("2");
            this.saveOrUpdate(baseEntity);
        } else{
            CertifyregHEntity certifyregH = certifyregHService.getById(id);

            QueryParam param = new QueryParam();
            param.getParams().put("pkCertifreg", new Parameter(QueryParam.EQ, id));
            param.getParams().put("bttype", new Parameter(QueryParam.EQ, "2"));
            List<AccountBaseEntity> baseEntityList = this.queryList(param);

            if(CollectionUtils.isNotEmpty(baseEntityList)) {
                AccountBaseEntity accountBase = baseEntityList.get(0);
                accountBase.setDjmonth(certifyregH.getEffectTime());
                accountBase.setExpireTime(certifyregH.getExpireTime());
                accountBase.setUpdateTime(certifyregH.getUpdateTime());
                accountBase.setUpdateUserCode(certifyregH.getUpdateUserCode());
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowTime = dtf.format(Instant.now());
                if (nowTime.compareTo(certifyregH.getExpireTime()) == -1) {
                    accountBase.setIsstop("1");
                    accountBase.setStopTime("");
                } else {
                    accountBase.setIsstop("0");
                    accountBase.setStopTime("有效期过期");
                }
                this.saveOrUpdate(accountBase);
            }
        }
    }
}
