package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifTypeEntity;
import com.ejianc.certify.bean.CertifyChangeHEntity;
import com.ejianc.certify.bean.CertifyregHEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.service.ICertifTypeService;
import com.ejianc.certify.utils.RpcUtil;
import com.ejianc.certify.vo.CertifyChangeHVO;
import com.ejianc.certify.vo.CertifyTransferVO;
import com.ejianc.certify.vo.CertifyregHVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifyTransferMapper;
import com.ejianc.certify.bean.CertifyTransferEntity;
import com.ejianc.certify.service.ICertifyTransferService;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 证照调动单
 * 
 * @author generator
 * 
 */
@Service("certifyTransferService")
public class CertifyTransferServiceImpl extends BaseServiceImpl<CertifyTransferMapper, CertifyTransferEntity> implements ICertifyTransferService{

    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;

    @Autowired
    private ICertifTypeService tservice;

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifyTransferEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifyTransferVO> vos = BeanMapper.mapList(list, CertifyTransferVO.class);
        return exportTranslate(vos);
    }


    private Map<String, Object> exportTranslate(List<CertifyTransferVO> vos) {
        for (CertifyTransferVO vo : vos) {
            CommonResponse<EmployeeVO> certpsn = iEmplApi.getById(vo.getPkCertpsn());
            RpcUtil.checkRespData(certpsn, true, "查询持证人员信息异常:" , certpsn.getMsg());
            vo.setPkCertpsnName(certpsn.getData().getName());

            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            RpcUtil.checkRespData(org, true, "查询原管理组织信息异常:" , org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<OrgVO> pkDrorg = iOrgApi.getOneById(vo.getPkDrorg());
            RpcUtil.checkRespData(pkDrorg, true, "查询调入管理组织信息异常:" , pkDrorg.getMsg());
            vo.setPkDrorgName(pkDrorg.getData().getName());

            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc(certStatus));

            CertifTypeEntity certifTypeEntity = tservice.selectById(vo.getPkCertiftype());
            Optional.ofNullable(certifTypeEntity).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            RpcUtil.checkRespData(applyer, true, "查询调出发起人员信息异常:" , applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            RpcUtil.checkRespData(applyerorg, true, "查询调出发起人组织信息异常:" , applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getBillState()).ifPresent(t -> vo.setBillStateName(BillStatusEnum.getDesc(t)));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }

    @Override
    public IPage<CertifyTransferVO> refCertifyregHData(Integer pageNumber, Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        /**用户权限*/
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /**处理SearchObject*/
        if (StringUtils.isNotEmpty(searchObject)) {
            //todo 处理SearchObject
            param.getParams().putAll(dealRefObject(searchObject,param));
        }
        IPage<CertifyTransferEntity> page = queryPage(param, false);
        IPage<CertifyTransferVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifyTransferVO.class));
        return pageData;
    }

    private Map<String, Parameter> dealRefObject(String searchObject, QueryParam param) {
        JSONObject object = JSONObject.parseObject(searchObject);
        Map<String, Parameter> result = new HashMap<>();

        for (String key : object.keySet()) {
            switch (key){
                case "pkCertpsn.name":
                    //todo 需要平台提供根据姓名查询 api
//                    result.put("pkCertpsn",new Parameter(QueryParam.EQ,eid));
                    break;
                case "pkCertiftype.name":
                    Long tid = tservice.getIdByName((String) object.get(key));
                    result.put("pkCertiftype",new Parameter(QueryParam.EQ,tid));
                    break;
                default:
                    result.put(key,new Parameter(QueryParam.EQ,object.get(key)));
                    break;
            }
        }
        return result;
    }
}
