package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.certify.bean.CertifTypeEntity;
import com.ejianc.certify.bean.CertifregBEntity;
import com.ejianc.certify.bean.CertifregFEntity;
import com.ejianc.certify.enums.BillStatusEnum;
import com.ejianc.certify.enums.CertStatusEnum;
import com.ejianc.certify.enums.YesNoEnum;
import com.ejianc.certify.service.*;
import com.ejianc.certify.utils.AuthUtil;
import com.ejianc.certify.utils.BarCodeUtils;
import com.ejianc.certify.utils.RpcUtil;
import com.ejianc.certify.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.CertifyregHMapper;
import com.ejianc.certify.bean.CertifyregHEntity;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

import javax.annotation.Resource;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * 证照登记单-表头
 *
 * @author generator
 */
@Service("certifyregHService")
public class CertifyregHServiceImpl extends BaseServiceImpl<CertifyregHMapper, CertifyregHEntity> implements ICertifyregHService {
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IEmployeeApi iEmplApi;
    @Resource
    private IDefdocApi defdocApi;
    @Resource
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private ICertifregBService bService;
    @Autowired
    private ICertifregFService fService;
    @Autowired
    private ICertifTypeService tservice;
    @Autowired
    private ISocialInsuranceService sservice;
    @Autowired
    private ICertifySpecialReqService sreqService;

    @Autowired
    private CertifyregHMapper mapper;



    private static final String PKBILLTYPE = "ZJ001";      //单据类型默认值
    private static final String EMPL_CODE_PREFIX = "EMP";  //人员编码前缀
    private static final String TYPEATTRIBUTE_CODE = "GTZZ-006";   //特殊证照类别自定义档案的档案编码
    private static final String BILL_TYPE = "BT202205000006";   //证照登记-单据编码
    private static final String SOURCE_TYPE = "barCode";   //证照登记-单据编码


    /**
     * @param param
     * @description 根据证照登记单参数分页查询变更记录
     * @author yxm
     * @date 2022/5/13
     */
    @Override
    public CommonResponse<IPage<CertifregBVO>> queryBPageByHParm(QueryParam param) {
        IPage<CertifregBEntity> page = bService.queryPage(param, false);
        IPage<CertifregBVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifregBVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @description 根据证照登记单参数分页查询基本补贴调整额
     * @author yxm
     * @date 2022/5/13
     */
    @Override
    public CommonResponse<IPage<CertifregFVO>> queryFPageByHParm(QueryParam param) {
        IPage<CertifregFEntity> page = fService.queryPage(param, false);
        IPage<CertifregFVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifregFVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @Override
    public Map<String, Object> excelExport(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("pkOrg", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CertifyregHEntity> list = queryList(param);
        //todo:字段翻译等等
        List<CertifyregHVO> vos = BeanMapper.mapList(list, CertifyregHVO.class);
        return exportTranslate(vos);
    }

    private Map<String, Object> exportTranslate(List<CertifyregHVO> vos) {
        for (CertifyregHVO vo : vos) {
            CommonResponse<OrgVO> org = iOrgApi.getOneById(vo.getPkOrg());
            RpcUtil.checkRespData(org, true, "查询管理组织信息异常:" , org.getMsg());
            vo.setPkOrgName(org.getData().getName());

            CommonResponse<OrgVO> applyerorg = iOrgApi.getOneById(vo.getApplyerorg());
            RpcUtil.checkRespData(applyerorg, true, "查询发起人组织信息异常:" , applyerorg.getMsg());
            vo.setApplyerorgName(applyerorg.getData().getName());

            CommonResponse<OrgVO> vcertcorp = iOrgApi.getOneById(vo.getPkVcertcorp());
            RpcUtil.checkRespData(vcertcorp, true, "查询持证区域异常:" , vcertcorp.getMsg());
            vo.setPkVcertcorpName(vcertcorp.getData().getName());

            CommonResponse<EmployeeVO> certpsn = iEmplApi.getById(vo.getPkCertpsn());
            RpcUtil.checkRespData(certpsn, true, "查询持证人员信息异常:" , certpsn.getMsg());
            vo.setPkCertpsnName(certpsn.getData().getName());

            CommonResponse<EmployeeVO> receiver = iEmplApi.getById(vo.getReceiver());
            RpcUtil.checkRespData(receiver, true, "查询接收人员信息异常:" , receiver.getMsg());
            vo.setReceiverName(receiver.getData().getName());

            CommonResponse<EmployeeVO> applyer = iEmplApi.getById(vo.getApplyer());
            RpcUtil.checkRespData(applyer, true, "查询发起人员信息异常:" , applyer.getMsg());
            vo.setApplyerName(applyer.getData().getName());

            CommonResponse<DefdocDetailVO> yjdw = defdocApi.getDefDocById(vo.getPkYjdw());
            RpcUtil.checkRespData(yjdw, true, "查询引进单位信息异常:" , yjdw.getMsg());
            vo.setPkYjdwName(yjdw.getData().getName());

            CommonResponse<DefdocDetailVO> sbzt = defdocApi.getDefDocById(vo.getPkSbzt());
            RpcUtil.checkRespData(sbzt, true, "查询社保主体信息异常:" , sbzt.getMsg());
            vo.setPkSbztName(sbzt.getData().getName());

            Optional.ofNullable(tservice.selectById(vo.getPkCertiftype())).ifPresent(t -> vo.setPkCertiftypeName(t.getName()));
            Optional.ofNullable(vo.getPkGlzcz()).ifPresent(glzcz -> {
                Optional.ofNullable(selectById(glzcz)).ifPresent(t -> vo.setPkGlzczName(t.getName()));
            });
            Optional.ofNullable(vo.getPkGlzyz()).ifPresent(glzyz -> {
                Optional.ofNullable(selectById(glzyz)).ifPresent(t -> vo.setPkGlzyzName(t.getName()));
            });

            String certStatus = Optional.ofNullable(vo.getCertStatus()).orElse("0");
            vo.setCertStatusName(CertStatusEnum.findDesc(certStatus));
            Optional.ofNullable(vo.getIsZyzj()).ifPresent(t -> vo.setIsZyzj(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getIsDzzj()).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getYjIsrecevie()).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisusemore()).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyiscrosarea()).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisinstore()).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisreg()).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyisuse()).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyispleg()).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyislock()).ifPresent(t -> vo.setApplyislock(YesNoEnum.findDesc(t)));
            Optional.ofNullable(vo.getApplyischanging()).ifPresent(t -> vo.setApplyischanging(YesNoEnum.findDesc(t)));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        return beans;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(Map<String, MultipartFile> fileMap) {
        //todo:添加excel导入代码
        List<CertifyregHVO> successList = new ArrayList<>();
        List<CertifyregHVO> failList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();
            String originalFileName = file.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                return CommonResponse.error("文件类型不正确");
            }

            List<List<String>> importList = ExcelReader.readExcel(file);
            Map<String, Object> importResult = importTranslate(importList);
            if ((boolean) importResult.get("errFlag")) {
                failList.addAll((List<CertifyregHVO>) importResult.get("list"));
            } else {
                successList.addAll((List<CertifyregHVO>) importResult.get("list"));
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", failList);
        return CommonResponse.success(json);
    }

    private Map<String, Object> importTranslate(List<List<String>> importList) {
        List<CertifyregHVO> successList = new ArrayList<>();
        List<CertifyregHVO> failList = new ArrayList<>();
        Map<String, Object> result = new HashMap<>();
        boolean errFlag = false;
        for (int i = 0; i < importList.size(); i++) {
            OrgVO orgQuery = new OrgVO();
            StringJoiner errMsg = new StringJoiner(";");
            CertifyregHVO vo = new CertifyregHVO();
            List<String> row = importList.get(i);

            //持证人
            CommonResponse<EmployeeVO> empl = iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(0));
            if (empl.isSuccess()) {
                vo.setPkCertpsn(empl.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("持证人-" + empl.getMsg());
            }
            vo.setPsnPhone(row.get(1));
            vo.setCardId(row.get(2));
            vo.setPkSbzt(sservice.getSubIdByName(row.get((3))).getPkSbzt());
            //持证区域
            orgQuery.setName(row.get(4));
            CommonResponse<OrgVO> pkVcertcorp = iOrgApi.findOneByOrgVO(orgQuery);
            if (pkVcertcorp.isSuccess()) {
                vo.setPkVcertcorp(pkVcertcorp.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("持证区域-" + pkVcertcorp.getMsg());
            }
            vo.setApplyprofessor(row.get(5));
            Long pkCertiftype = tservice.getIdByName(row.get(6));
            if (pkCertiftype == null || pkCertiftype == 0) {
                errFlag = true;
                errMsg.add("证照名称-没有找到对应的证照类别");
            } else {
                vo.setPkCertiftype(pkCertiftype);
            }

            //证照状态
            String certStatusName = Optional.ofNullable(row.get(7)).orElse(CertStatusEnum.INVALID.getDesc());
            vo.setCertStatus(CertStatusEnum.findCode(certStatusName));
            vo.setCertifcode(row.get(8));
            //管理组织
            orgQuery.setName(row.get(9));
            CommonResponse<OrgVO> pkOrg = iOrgApi.findOneByOrgVO(orgQuery);
            if (pkOrg.isSuccess()) {
                vo.setPkOrg(pkOrg.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("管理组织-" + pkOrg.getMsg());
            }
            //todo 管理部门-10

            //引进单位和资质类别
            SocialInsuranceVO yjdw = sservice.getSubIdByName(row.get((11)));
            vo.setPkYjdw(yjdw.getPkSbzt());
            vo.setApplyorgtype(yjdw.getSbztType());

            vo.setVgrantcertunit(row.get(12));
            vo.setApplyregdate(row.get(13));
            vo.setReceivedate(row.get(14));
            //接收人
            CommonResponse<EmployeeVO> receiver = iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(15));
            if (receiver.isSuccess()) {
                vo.setReceiver(receiver.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("接收人-" + receiver.getMsg());
            }
            vo.setEffectTime(row.get(16));
            vo.setExpireTime(row.get(17));
            vo.setExpireReason(row.get(18));
            vo.setDgrantcertdate(row.get(19));
            vo.setValidbegindate(row.get(20));
            vo.setValidbegindate(row.get(21));
            //todo 关联执业证件-22
            if (StringUtils.isNotBlank(row.get(22))) {
                Long pkGlzyzId = tservice.getIdByName(row.get(22));
                if (pkGlzyzId != null || pkGlzyzId != 0) {
                    QueryWrapper<CertifyregHEntity> pkGlzyzQuery = new QueryWrapper<>();
                    pkGlzyzQuery.eq("pk_certpsn", vo.getPkCertpsn());
                    pkGlzyzQuery.eq("pk_certiftype", pkGlzyzId);
                    CertifyregHEntity pkGlzyz = getOne(pkGlzyzQuery);
                    if (pkGlzyz != null) {
                        vo.setPkGlzyz(pkGlzyz.getId());
                    } else {
                        errFlag = true;
                        errMsg.add("关联执业证件-没有对应的执业证件");
                    }
                } else {
                    errFlag = true;
                    errMsg.add("关联执业证件-没有对应的证照类别");
                }
            }

            //todo 关联注册证-23
            if (StringUtils.isNotBlank(row.get(23))) {
                Long pkGlzczId = tservice.getIdByName(row.get(23));
                if (pkGlzczId != null || pkGlzczId != 0) {
                    QueryWrapper<CertifyregHEntity> pkGlzczQuery = new QueryWrapper<>();
                    pkGlzczQuery.eq("pk_certpsn", vo.getPkCertpsn());
                    pkGlzczQuery.eq("pk_certiftype", pkGlzczId);
                    CertifyregHEntity pkGlzcz = getOne(pkGlzczQuery);
                    if (pkGlzcz != null) {
                        vo.setPkGlzcz(pkGlzcz.getId());
                    } else {
                        errFlag = true;
                        errMsg.add("关联注册证-没有对应的注册证");
                    }
                } else {
                    errFlag = true;
                    errMsg.add("关联注册证-没有对应的注册证");
                }
            }

            vo.setIsZyzj(YesNoEnum.findCode(row.get(24)));
            vo.setApplydate(row.get(25));
            vo.setVoperscope(row.get(26));
            //发起人
            CommonResponse<EmployeeVO> applyer = iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + row.get(27));
            if (applyer.isSuccess()) {
                vo.setApplyer(applyer.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("发起人-" + applyer.getMsg());
            }
            //发起人组织
            orgQuery.setName(row.get(28));
            CommonResponse<OrgVO> applyerOrg = iOrgApi.findOneByOrgVO(orgQuery);
            if (applyerOrg.isSuccess()) {
                vo.setApplyerorg(applyerOrg.getData().getId());
            } else {
                errFlag = true;
                errMsg.add("发起人组织-" + applyerOrg.getMsg());
            }

            Optional.ofNullable(row.get(29)).ifPresent(t -> vo.setIsDzzj(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(30)).ifPresent(t -> vo.setYjIsrecevie(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(31)).ifPresent(t -> vo.setApplyisusemore(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(32)).ifPresent(t -> vo.setApplyiscrosarea(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(33)).ifPresent(t -> vo.setApplyisinstore(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(34)).ifPresent(t -> vo.setApplyisreg(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(35)).ifPresent(t -> vo.setApplyisuse(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(36)).ifPresent(t -> vo.setApplyispleg(YesNoEnum.findCode(t)));
            Optional.ofNullable(row.get(37)).ifPresent(t -> vo.setApplyislock(YesNoEnum.findCode(t)));

            DateFormater date = DateFormater.getInstance(DateFormater.getCurrentDate(), 8);
            vo.setDbilldate(date.format(DateFormater.SHORT_FORMAT));
            vo.setPkBilltype(PKBILLTYPE);

            if (errMsg.length() > 0) {
                vo.setErrorMessage("excel文档中第" + (i + 2) + "行数据异常:" + errMsg.toString());
                failList.add(vo);
            } else {
                vo.setBillState(BillStatusEnum.FREE.getId());
                successList.add(vo);
            }
        }
        result.put("errFlag", errFlag);
        if (errFlag) {
            result.put("list", failList);
        } else {
            result.put("list", successList);
        }
        return result;
    }

    @Override
    public CommonResponse<String> scanBillImport(List<AttachmentVO> attachs) {
        Map<Long, List<Long>> update = new HashMap<>();
        for (AttachmentVO attach : attachs) {
            List<Long> updateList = new ArrayList<>();
            //根据扫描单文件名(格式: 主数据员工编码-证照名称)获取对应的登记单
            String[] split = attach.getFileName().split("-");
            String pkCertpsnCode = split[0];
            CommonResponse<EmployeeVO> empl = iEmplApi.getByEmpmloyeeCode(EMPL_CODE_PREFIX + pkCertpsnCode);
            RpcUtil.checkRespData(empl, true, "查询持证人员信息异常:" , empl.getMsg());
            Long emplID = empl.getData().getId();
            String pkCertiftypeName = split[1].substring(0, split[1].indexOf("."));
            Long pkCertiftype = tservice.getIdByName(pkCertiftypeName);
            if (pkCertiftype != null || pkCertiftype != 0) {
                QueryWrapper<CertifyregHEntity> query = new QueryWrapper<>();
                query.eq("pk_certpsn", emplID);
                query.eq("pk_certiftype", pkCertiftype);
                CertifyregHEntity certifyregH = getOne(query);
                if (certifyregH != null) {
                    attach.setSourceId(certifyregH.getId());
                } else {
                    throw new BusinessException("根据文件名查找不到对应的登记单");
                }
            } else {
                throw new BusinessException("根据文件名查找不到证照类别");
            }
            //判断扫描单是更新还是新增
            CommonResponse<List<AttachmentVO>> attachResp = iAttachmentApi.queryListBySourceId(attach.getSourceId(), attach.getBillType(), attach.getSourceType(), null);
            RpcUtil.checkRespData(attachResp, true, "查询附件接口异常:" , attachResp.getMsg());
            if (attachResp.isSuccess() && ListUtil.isNotEmpty(attachResp.getData())) {
                for (AttachmentVO datum : attachResp.getData()) {
                    updateList.add(datum.getId());
                }
                update.put(attach.getSourceId(), updateList);
            }
        }

        for (Map.Entry<Long, List<Long>> item : update.entrySet()) {
            CommonResponse<String> updateResp = iAttachmentApi.updateAttachRef(item.getKey(), item.getValue());
            RpcUtil.checkRespData(updateResp, true, "更新附件接口异常:" , updateResp.getMsg());
        }
        CommonResponse<String> response = iAttachmentApi.insertBatch(attachs);
        RpcUtil.checkRespData(response, true, "扫描单保存失败:" , response.getMsg());
        return CommonResponse.success("上传扫描件成功!");
    }

    @Override
    public CommonResponse<String> GenBarCode(Long id) {
        UserContext userContextCache = sessionManager.getUserContext();
        String userCode = sessionManager.getUserContext().getUserCode();
        Long tenantid = sessionManager.getUserContext().getTenantid();
        CertifyregHEntity entity = selectById(id);
        if (entity == null) {
            throw new BusinessException("没有找到id：" + id + "的登记单数据");
        }
        //todo 判断是否条形码是否已经生成,是则删除插入最新的
        CommonResponse<List<AttachmentVO>> attachs = iAttachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, SOURCE_TYPE, null);
        if (attachs.isSuccess() && ListUtil.isNotEmpty(attachs.getData())) {
            StringJoiner sj = new StringJoiner(",");
            attachs.getData().forEach(item -> {
                sj.add(String.valueOf(item.getId()));
            });
            iAttachmentApi.delete(sj.toString());
        }

        BufferedImage image = BarCodeUtils.insertWords(BarCodeUtils.getBarCode(entity.getZjCode()), entity.getZjCode());
        AttachmentRequestVO attach = new AttachmentRequestVO();
        attach.setBillType(BILL_TYPE);
        attach.setSourceId(String.valueOf(entity.getId()));
        attach.setSourceType(SOURCE_TYPE);
        attach.setCreateTime(DateFormater.getCurrentDate());
        attach.setCreateUserCode(userCode);
        attach.setTenantId(tenantid);
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write(image, "png", stream);
            byte[] bytes = stream.toByteArray();
            BASE64Encoder encoder = new BASE64Encoder();
            String base64 = "data:image/png;base64," + encoder.encodeBuffer(bytes);
            List<String> files = new ArrayList<>();
            files.add(base64);
            attach.setFileList(files);
        } catch (IOException e) {
            throw new BusinessException("条形码图片转成base64异常");
        }
        CommonResponse<List<AttachmentVO>> response = iAttachmentApi.uploadForBase64(attach);
        RpcUtil.checkRespData(response, true, "条形码上传服务器失败:" , response.getMsg());
        return CommonResponse.success("成功");
    }

    /**
     * @param pageNumber
     * @param pageSize
     * @param condition    {"specialtype":"0/1",            0-注册证  1-B证
     *                      "specialReqId":特殊请示单ID,     特殊请示
     *                      "属性名":"属性值"}               其他
     * @param searchObject
     * @param searchText
     * @description 获取登记单参照
     * @author yxm
     * @date 2022/5/23
     */
    @Override
    public IPage<CertifyregHVO> refCertifyregHData(Integer pageNumber, Integer pageSize,
                                                   String condition, String searchObject,
                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        /**用户权限*/
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgAuths = AuthUtil.getOrgAuths();
        orgAuths.forEach(item -> System.out.println(item.toString()));
        Map<String, List<Long>> userAuths = AuthUtil.getOrgAndDeptAuths();
        for (String key : userAuths.keySet()) {
            param.getParams().put(key,new Parameter(QueryParam.IN,userAuths.get(key)));
        }
        /**处理SearchObject*/
        if (StringUtils.isNotEmpty(searchObject)) {
            //todo 处理SearchObject
            param.getParams().putAll(dealRefObject(searchObject));
        }
        /** 处理condition */
        if (StringUtils.isNotEmpty(condition)) {
            addParamByCon(condition,param);
        }
        //todo 待比较两种方案
        //单表方案
        IPage<CertifyregHEntity> page = queryPage(param, false);
        //多表方案
        /*IPage<CertifyregHEntity> page = new Page<>();
        if (ListUtil.isNotEmpty(param.getComplexParams())) {
            for (ComplexParam complexParam : param.getComplexParams()) {

                if (complexParam.getParams().containsKey("b.pkSpecialreq")) {
                    *//**特殊请示单需要在登记表参数(param.getParams)前加 "a."前缀 **//*
                    Map<String, Parameter> newParams = new HashMap<>();
                    Map<String, Parameter> oldParams = param.getParams();
                    Set<String> keys = oldParams.keySet();
                    for (String key : keys) {
                        newParams.put("a." + key,oldParams.get(key));
                    }
                    //需要手动添加删除标识
                    newParams.put("a.dr",new Parameter(QueryParam.EQ,0));
                    param.setParams(newParams);
                }
                QueryWrapper<Object> wrapper = changeToQueryWrapper(param);
                page.setSize(pageSize);
                page.setCurrent(pageNumber);
                //由于mybatis-plus规则,page参数必须放在第一位,否则会报错
                page = mapper.queryListUnionSpecialReqBId(page,wrapper);
            }
        }else {
            page = queryPage(param, false);
        }*/

        IPage<CertifyregHVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CertifyregHVO.class));
        return pageData;
    }

    private Map<String, Parameter> dealRefObject(String searchObject){
        JSONObject object = JSONObject.parseObject(searchObject);
        Map<String, Parameter> result = new HashMap<>();
        for (String key : object.keySet()) {
            switch (key){
                case "pkCertpsn.name":
                    //todo 需要平台提供根据姓名查询 api
//                    result.put("pkCertpsn",new Parameter(QueryParam.EQ,eid));
                    break;
                case "pkCertiftype.name":
                    Long tid = tservice.getIdByName((String) object.get(key));
                    result.put("pkCertiftype",new Parameter(QueryParam.EQ,tid));
                    break;
                default:
                    result.put(key,new Parameter(QueryParam.EQ,object.get(key)));
                    break;
            }
        }

        return result;

    }

    /**
     * @description  根据condition添加查询参数
     * @author yxm
     * @date 2022/6/1
     * @param condition 条件json字符串 {"属性名":"属性值"}
     * @param param
     */
    private void addParamByCon(String condition,QueryParam param){
        JSONObject _con = JSONObject.parseObject(condition);

        for (String key : _con.keySet()) {
            switch (key){
                case "specialReqId":    /** 获取特殊请示条件**/
                    long reqId = Long.parseLong(_con.get(key).toString());
                    //单表方案
                    QueryParam querySreq = new QueryParam();
                    querySreq.setPageIndex(1);
                    querySreq.setPageSize(-1);
                    querySreq.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
                    querySreq.getParams().put("pkSpecialreq", new Parameter(QueryParam.EQ, reqId));
                    CommonResponse<IPage<CertifySpecialReqBVO>> page = sreqService.queryBPageByHParm(querySreq);
                    RpcUtil.checkRespData(page,true,"获取特殊请示表头失败:",null);
                    List<Long> blist = page.getData().getRecords().stream()
                            .map(CertifySpecialReqBVO::getPkCertifreg)
                            .collect(Collectors.toList());
                    ComplexParam complexParam = new ComplexParam();
                    complexParam.setLogic(ComplexParam.OR);
                    complexParam.getParams().put("id",new Parameter(QueryParam.IN,blist));

                    //多表方案
                    /*ComplexParam complexParam = new ComplexParam();
                    complexParam.setLogic(ComplexParam.OR);
                    complexParam.getParams().put("b.pkSpecialreq",new Parameter(QueryParam.EQ,reqId));*/

                    param.getComplexParams().add(complexParam);
                    break;
                case "specialtype":     /** 根据参照类型过滤登记单 0-执业证  1-B证 **/
                    /**查询特殊证照类别自定义档案**/
                    List<Long> attrIds = new ArrayList<>();
                    String _var = (String) _con.get(key);
                    CommonResponse<List<DefdocDetailVO>> defdoc = defdocApi.getDefDocByDefCode(TYPEATTRIBUTE_CODE);
                    RpcUtil.checkRespData(defdoc, true, "获取社保主体信息失败:" , defdoc.getMsg());
                    defdoc.getData().forEach(attr -> {
                        //注册证
                        if ("0".equals(_var) && attr.getName().contains("注册")) {
                            attrIds.add(attr.getId());
                        }
                        //B证
                        if ("1".equals(_var) && attr.getName().equals("B证")) {
                            attrIds.add(attr.getId());
                        }
                    });
                    QueryWrapper<CertifTypeEntity> queryWrapper = new QueryWrapper();
                    if (attrIds.size() == 1) {
                        queryWrapper.eq("specialtype", attrIds.get(0));
                    } else if (attrIds.size() > 1) {
                        queryWrapper.in("specialtype", attrIds);
                    }
                    List<CertifTypeEntity> certifTypes = tservice.getBaseMapper().selectList(queryWrapper);
                    List<Long> ids = certifTypes.stream().map(CertifTypeEntity::getId).collect(Collectors.toList());
                    if (ListUtil.isNotEmpty(ids)) {
                        param.getParams().put("pkCertiftype", new Parameter(QueryParam.IN, ids));
                    }
                    break;
                case "pkOrg":   /** 获取管理组织条件**/
                    long orgId = Long.parseLong(_con.get(key).toString());
                    CommonResponse<List<OrgVO>> childResp = iOrgApi.findChildrenByParentId(orgId);
                    RpcUtil.checkRespData(childResp,true,"查找组织信息异常:",null);
                    List<OrgVO> childs = childResp.getData();
                    List<Long> pkOrgs = childs.stream().map(OrgVO::getId).collect(Collectors.toList());
                    param.getParams().put("pkOrg", new Parameter(QueryParam.IN, pkOrgs));
                    break;
                default:    /**非特殊处理参数**/
                    param.getParams().put(key,new Parameter(QueryParam.EQ,_con.get(key)));
                    break;
            }
        }
    }
}
