package com.ejianc.certify.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.MdgBankMapper;
import com.ejianc.certify.bean.MdgBankEntity;
import com.ejianc.certify.service.IMdgBankService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 银行联行号主数据
 * 
 * @author generator
 * 
 */
@Service("mdgBankService")
public class MdgBankServiceImpl extends BaseServiceImpl<MdgBankMapper, MdgBankEntity> implements IMdgBankService{
    private static final Long DEFAULT_TENANTID = 999999L;

    /**
     * @description  根据主数据请求的RequestData保存数据
     * @author yxm
     * @date 2022/6/15
     * @param dataList  格式:[{"BANKL" : "xx","RecordID": "xx",...},....]
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW,rollbackFor = Exception.class)
    public Map<String,Object> saveJsonArray(JSONArray dataList) {
        Map<String,Object> result = new HashMap<>();
        List<MdgBankEntity> list = dataList.toJavaList(MdgBankEntity.class);
        List<MdgBankEntity> updateList = new ArrayList<>();
        List<MdgBankEntity> saveList = new ArrayList<>();
        for (MdgBankEntity bank : list) {
            //根据银行联行号的唯一值确定此数据是新增还是更新
            QueryWrapper<MdgBankEntity> bankQuery = new QueryWrapper<>();
            bankQuery.eq("bankl", bank.getBankl());
            MdgBankEntity bankEntity = getOne(bankQuery);
            if (ObjectUtil.isNotNull(bankEntity)) {
                bank.setId(bankEntity.getId());
                bank.setTenantId(bankEntity.getTenantId());
                bank.setCreateTime(bankEntity.getCreateTime());
                bank.setCreateUserCode(bankEntity.getCreateUserCode());
                bank.setTs(bankEntity.getTs());
                bank.setUpdateTime(new Date());
                bank.setSyncEsFlag(bankEntity.getSyncEsFlag());
                bank.setVersion(bankEntity.getVersion());
                updateList.add(bank);
            } else {
                bank.setCreateTime(new Date());
                bank.setTenantId(DEFAULT_TENANTID);
                saveList.add(bank);
            }
        }
        try {
            if (ListUtil.isNotEmpty(updateList)) {
                updateBatchById(updateList);
            }
            if (ListUtil.isNotEmpty(saveList)) {
                saveBatch(saveList);
            }
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "S", "成功"));
            result.put("busiMsg","成功");
            result.put("busiSuccess","S");
        }catch (Exception e){
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "E", e.getCause().getMessage()));
            result.put("busiMsg",e.getCause().getMessage());
            result.put("busiSuccess","E");
        }
        return result;
    }

}
