package com.ejianc.certify.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.MdgCostMapper;
import com.ejianc.certify.bean.MdgCostEntity;
import com.ejianc.certify.service.IMdgCostService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 成本中心主数据
 * 
 * @author generator
 * 
 */
@Service("mdgCostService")
public class MdgCostServiceImpl extends BaseServiceImpl<MdgCostMapper, MdgCostEntity> implements IMdgCostService{
    private static final Long DEFAULT_TENANTID = 999999L;

    /**
     * @description  根据主数据请求的RequestData保存数据
     * @author yxm
     * @date 2022/6/15
     * @param dataList  格式:[{"ZKOSTL" : "xx","RecordID": "xx","ZCOSTIDX": "xx",...},...]
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW,rollbackFor = Exception.class)
    public Map<String,Object> saveJsonArray(JSONArray dataList) {
        Map<String,Object> result = new HashMap<>();
        List<MdgCostEntity> list = dataList.toJavaList(MdgCostEntity.class);
        List<MdgCostEntity> updateList = new ArrayList<>();
        List<MdgCostEntity> saveList = new ArrayList<>();
        for (MdgCostEntity cost : list) {
            //根据成本中心的唯一值确定此数据是新增还是更新
            QueryWrapper<MdgCostEntity> costQuery = new QueryWrapper<>();
            costQuery.eq("zcostidx", cost.getZcostidx());
            costQuery.eq("zkostl", cost.getZkostl());
            MdgCostEntity costEntity = getOne(costQuery);
            if (ObjectUtil.isNotNull(costEntity)) {
                cost.setId(costEntity.getId());
                cost.setTenantId(costEntity.getTenantId());
                cost.setCreateTime(costEntity.getCreateTime());
                cost.setCreateUserCode(costEntity.getCreateUserCode());
                cost.setTs(costEntity.getTs());
                cost.setUpdateTime(new Date());
                cost.setSyncEsFlag(costEntity.getSyncEsFlag());
                cost.setVersion(costEntity.getVersion());
                updateList.add(cost);
            } else {
                cost.setCreateTime(new Date());
                cost.setTenantId(DEFAULT_TENANTID);
                saveList.add(cost);
            }
        }
        try {
            if (ListUtil.isNotEmpty(updateList)) {
                updateBatchById(updateList);
            }
            if (ListUtil.isNotEmpty(saveList)) {
                saveBatch(saveList);
            }
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "S", "成功"));
            result.put("busiMsg","成功");
            result.put("busiSuccess","S");
        }catch (Exception e){
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "E", e.getCause().getMessage()));
            result.put("busiMsg",e.getCause().getMessage());
            result.put("busiSuccess","E");
        }
        return result;
    }

}
