package com.ejianc.certify.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.ejianc.certify.enums.MdgTypeEnum;
import com.ejianc.certify.service.IMdgBankService;
import com.ejianc.certify.service.IMdgCostService;
import com.ejianc.certify.service.IMdgProfitService;
import com.ejianc.certify.threadpool.MdgThreadPool;
import com.ejianc.certify.utils.HttpClientTool;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.MdgLogMapper;
import com.ejianc.certify.bean.MdgLogEntity;
import com.ejianc.certify.service.IMdgLogService;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.PostConstruct;
import java.util.*;

/**
 * 主数据日志
 * 
 * @author generator
 * 
 */
@Service("mdgLogService")
public class MdgLogServiceImpl extends BaseServiceImpl<MdgLogMapper, MdgLogEntity> implements IMdgLogService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${mdg.sourceSystem}")
    private String sourceSystem;
    @Value("${mdg.callBackUrl}")
    private String callBackUrl;
    @Value("${mdg.account}")
    private String account;
    @Value("${mdg.password}")
    private String password;

    @Autowired
    private IMdgCostService costService;
    @Autowired
    private IMdgProfitService profitService;
    @Autowired
    private IMdgBankService bankService;
    @Autowired
    private MdgThreadPool mdgThreadPool;


    @Async("mdgExecutor")
    public void callBackMdg(MdgLogEntity mdgLog){
        JSONObject callBack = new JSONObject();
        String interfaceID = mdgLog.getInterfaceid();
        String fragmentID = mdgLog.getFragmentid();
        JSONArray sdDatas = JSONObject.parseObject(mdgLog.getSendDataNs()).getJSONArray("RequestData");
        //构建回调接口的ControlInformation
        JSONObject control = new JSONObject();
        control.put("FragmentID", fragmentID);
        control.put("InterfaceID", interfaceID);
        List<String> sourceSystems = new ArrayList<>();
        sourceSystems.add(sourceSystem);
        control.put("SourceSystem", sourceSystems);
        callBack.put("ControlInformation", control);
        //校验InterfaceID
        MdgTypeEnum typeEnum = null;
        try {
            typeEnum = MdgTypeEnum.valueOf(interfaceID);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("interfaceID:" + interfaceID + "不属于证照系统接收的主数据类型!");
        }
        //构建回调接口的RequestData
        if (Objects.nonNull(typeEnum)) {
            Map<String, Object> map = saveMdgData(typeEnum, sdDatas);
            callBack.put("RequestData", map.get("RequestData"));
            mdgLog.setBusiMsg((String) map.get("busiMsg"));
            mdgLog.setBusiSuccess((String) map.get("busiSuccess"));
        }else{
            callBack.put("RequestData",buildResult(sdDatas,"E",interfaceID + "不属于证照系统接收的主数据类型!"));
            mdgLog.setBusiMsg("interfaceID:" + interfaceID + "不属于证照系统接收的主数据类型!");
            mdgLog.setBusiSuccess("E");
        }

        //调用主数据回调接口
        try {
            HttpClientTool.sendJsonPost(callBackUrl, callBack.toJSONString(), account, password);
            mdgLog.setIssuccessNs("S");
            mdgLog.setResultdataNs(callBack.toJSONString());
            mdgLog.setMsgNs("回调主数据成功!");
            updateById(mdgLog);
        } catch (Exception e) {
            logger.error("主数据回调接口异常:{}",e.getCause().getMessage());
            mdgLog.setIssuccessNs("E");
            mdgLog.setResultdataNs(callBack.isEmpty() ? null : callBack.toJSONString());
            mdgLog.setMsgNs(e.getMessage());
            updateById(mdgLog);
            e.printStackTrace();
        }
    }

    public Map<String,Object> saveMdgData(MdgTypeEnum typeEnum,JSONArray dataList){
        Map<String,Object> result = new HashMap<>();
        switch (typeEnum) {
            case ZC:
                result = costService.saveJsonArray(dataList);
                break;
            case ZB:
                result = profitService.saveJsonArray(dataList);
                break;
            case ZBNU:
                result = bankService.saveJsonArray(dataList);
                break;
        }
        return result;
    }


    /**
     * @description  构建主数据回调接口RequestData
     * @author yxm
     * @date 2022/6/15
     * @param dataList  请求的RequestData
     * @param code      ReturnCode
     * @param msg       ReturnMessage
     */
    public static List<Map<String,Object>> buildResult(JSONArray dataList,String code,String msg){
        List<Map<String,Object>> result = new ArrayList<>();
        for (int i = 0; i < dataList.size(); i++) {
            Map<String,Object> item = new HashMap<>();
            JSONObject data = dataList.getJSONObject(i);
            item.put("RecordID",data.get("RecordID"));
            item.put("ReturnCode", code);
            item.put("ReturnMessage", msg);
            result.add(item);
        }
        return result;
    }
}
