package com.ejianc.certify.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.certify.mapper.MdgProfitMapper;
import com.ejianc.certify.bean.MdgProfitEntity;
import com.ejianc.certify.service.IMdgProfitService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 利润中心主数据
 * 
 * @author generator
 * 
 */
@Service("mdgProfitService")
public class MdgProfitServiceImpl extends BaseServiceImpl<MdgProfitMapper, MdgProfitEntity> implements IMdgProfitService{
    private static final Long DEFAULT_TENANTID = 999999L;



    /**
     * @description  根据主数据请求的RequestData保存数据
     * @author yxm
     * @date 2022/6/15
     * @param dataList  格式:[{"ZPOFITCEN" : "xx","RecordID": "xx","ZPROCODE": "xx",...},...]
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW,rollbackFor = Exception.class)
    public Map<String,Object> saveJsonArray(JSONArray dataList) {
        Map<String,Object> result = new HashMap<>();
        List<MdgProfitEntity> list = dataList.toJavaList(MdgProfitEntity.class);
        List<MdgProfitEntity> updateList = new ArrayList<>();
        List<MdgProfitEntity> saveList = new ArrayList<>();
        for (MdgProfitEntity profit : list) {
            //根据利润中心的唯一值确定此数据是新增还是更新
            QueryWrapper<MdgProfitEntity> profitQuery = new QueryWrapper<>();
            profitQuery.eq("zpofitcen", profit.getZpofitcen());
            profitQuery.eq("zprocode", profit.getZprocode());
            MdgProfitEntity profitEntity = getOne(profitQuery);
            if (ObjectUtil.isNotNull(profitEntity)) {
                profit.setId(profitEntity.getId());
                profit.setTenantId(profitEntity.getTenantId());
                profit.setCreateTime(profitEntity.getCreateTime());
                profit.setCreateUserCode(profitEntity.getCreateUserCode());
                profit.setTs(profitEntity.getTs());
                profit.setUpdateTime(new Date());
                profit.setSyncEsFlag(profitEntity.getSyncEsFlag());
                profit.setVersion(profitEntity.getVersion());
                updateList.add(profit);
            } else {
                profit.setCreateTime(new Date());
                profit.setTenantId(DEFAULT_TENANTID);
                saveList.add(profit);
            }
        }
        try {
            if (ListUtil.isNotEmpty(updateList)) {
                updateBatchById(updateList);
            }
            if (ListUtil.isNotEmpty(saveList)) {
                saveBatch(saveList);
            }
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "S", "成功"));
            result.put("busiMsg","成功");
            result.put("busiSuccess","S");
        }catch (Exception e){
            result.put("RequestData",MdgLogServiceImpl.buildResult(dataList, "E", e.getCause().getMessage()));
            result.put("busiMsg",e.getCause().getMessage());
            result.put("busiSuccess","E");
        }
        return result;
    }

}
