package com.ejianc.business.dataexchange.controller.api;

import com.ejianc.business.dataexchange.bean.CertificateEntity;
import com.ejianc.business.dataexchange.service.ICertificateService;
import com.ejianc.business.dataexchange.vo.CertificateVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/certificateDelete/")
public class CertificateDeleteApi {
    @Autowired
    private ICertificateService certificateService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value ="query",method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<CertificateVO>> query(@RequestBody QueryParam param) {

        List<CertificateEntity> certificateEntities = certificateService.queryList(param);

        List<CertificateVO> certificateVOS = BeanMapper.mapList(certificateEntities, CertificateVO.class);

        logger.info("此次共查询出{}条数据1！",certificateEntities.size());
        return CommonResponse.success("查询成功！",certificateVOS);
    }
}
