package com.ejianc.business.dataexchange.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.IConstructorApi;
import com.ejianc.business.dataexchange.bean.JzsEntity;
import com.ejianc.business.dataexchange.service.IJzsService;
import com.ejianc.business.dataexchange.vo.JzsVo;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/constructor/")
public class ConstructorApi {
    @Autowired
    private IJzsService jzsService;

    @RequestMapping(value = "query", method= RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryConstructorInfo() {
        QueryParam param = new QueryParam();
        param.setPageSize(1);
        param.setPageIndex(600);
        param.setSearchText("");
        param.setSearchObject("");
        param.getParams().put("abdac",new Parameter(QueryParam.LIKE,"建造师"));
        IPage<JzsEntity> page = jzsService.queryPage(param);
        IPage<JzsVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), JzsVo.class));
        return CommonResponse.success("查询成功！");
    }
}
