/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.datav.bean.VisualEntity;
import com.ejianc.business.datav.service.IVisualService;
import com.ejianc.foundation.support.api.IReferApi;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referData/"})
public class ReferDataController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReferApi referApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${ejc.reportDataFieldsUrl}")
    private String reportDataFieldsUrl;
    @Value(value="${ejc.printDataFieldsUrl}")
    private String printDataFieldsUrl;
    @Value(value="${ejc.customAppDataFieldsUrl}")
    private String customAppDataFieldsUrl;
    @Autowired
    private IVisualService visualService;

    @GetMapping(value={"getReferDataByReferCode"})
    public CommonResponse<JSONObject> getReferDataByReferCode(@RequestParam(value="referCode") String referCode, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="pageNumber", required=false, defaultValue="1") int pageNumber, HttpServletRequest req) {
        JSONObject resp = null;
        CommonResponse referResp = this.referApi.findByCode(referCode);
        if (!referResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u7f16\u7801\u67e5\u8be2\u53c2\u7167\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)referResp.getMsg());
            return CommonResponse.error((String)("\u6839\u636e\u7f16\u7801\u67e5\u8be2\u53c2\u7167\u4fe1\u606f\u5931\u8d25\uff0c" + referResp.getMsg()));
        }
        ReferVO refer = (ReferVO)referResp.getData();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.put("searchText", searchText);
        }
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            param.put("relyCondition", relyCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            param.put("condition", condition);
        }
        param.put("pageSize", pageSize);
        param.put("pageNumber", pageNumber);
        resp = new JSONObject((Map)BeanMapper.map((Object)refer, Map.class));
        try {
            String dataReqResult = null;
            this.logger.info("\u67e5\u8be2\u53c2\u7167\uff0curl-{}, \u53c2\u6570-{}", (Object)refer.getDataurl(), (Object)refer.getDataurl());
            dataReqResult = "GET".equals(refer.getQueryMethod()) ? HttpTookit.get((String)refer.getDataurl(), param, (HttpServletRequest)req) : HttpTookit.postByJson((String)refer.getDataurl(), (String)JSONObject.toJSONString(param));
            this.logger.info("\u8bf7\u6c42\u53c2\u7167\u6570\u636e\u7ed3\u679c\uff1a{}", (Object)dataReqResult);
            CommonResponse referDataResp = (CommonResponse)JSONObject.parseObject((String)dataReqResult, CommonResponse.class);
            if (!referDataResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff0c{}", (Object)referDataResp.getMsg());
                return CommonResponse.error((String)("\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25\uff0c" + referDataResp.getMsg()));
            }
            resp.put("referData", referDataResp.getData());
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5f02\u5e38, ", (Throwable)e);
            return CommonResponse.error((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u5931\u8d25!");
        }
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"/dataFields"})
    public CommonResponse<Object> getFields(@RequestParam(value="dataType") String dataType, @RequestParam(value="dataSourceId") Long dataSourceId, HttpServletRequest req) throws Exception {
        return this.getFieldsByData(dataType, dataSourceId, req);
    }

    private CommonResponse<Object> getFieldsByData(String dataType, Long dataSourceId, HttpServletRequest req) throws Exception {
        String reqResult = null;
        String url = null;
        HashMap<String, String> param = new HashMap<String, String>();
        if ("1".equals(dataType)) {
            param.put("tblId", dataSourceId.toString());
            url = this.reportDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.reportDataFieldsUrl : this.reportDataFieldsUrl;
        } else if ("2".equals(dataType)) {
            param.put("id", dataSourceId.toString());
            url = this.printDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.printDataFieldsUrl : this.printDataFieldsUrl;
        } else {
            param.put("appId", dataSourceId.toString());
            url = this.customAppDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.customAppDataFieldsUrl : this.customAppDataFieldsUrl;
        }
        reqResult = HttpTookit.get((String)url, param, (HttpServletRequest)req);
        this.logger.info("\u8bf7\u6c42-{},\u53c2\u6570-{},\u7ed3\u679c-{}", new Object[]{url, JSONObject.toJSONString(param), reqResult});
        CommonResponse reqResp = (CommonResponse)JSONObject.parseObject((String)reqResult, CommonResponse.class);
        if (!reqResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5b57\u6bb5\u5931\u8d25\uff0c{}", (Object)reqResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return reqResp;
    }

    @GetMapping(value={"/getFieldsByVisualId"})
    public CommonResponse<Object> getFieldsByVisualId(@RequestParam Long visualId, HttpServletRequest req) throws Exception {
        VisualEntity visualEntity = (VisualEntity)((Object)this.visualService.selectById(visualId));
        return this.getFieldsByData(visualEntity.getDataType(), visualEntity.getDataSourceId(), req);
    }
}

