/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.datav.bean.QueryDict;
import com.ejianc.business.datav.bean.QueryParamResult;
import com.ejianc.business.datav.bean.ReportEntity;
import com.ejianc.business.datav.bean.ReportQueryParamEntity;
import com.ejianc.business.datav.service.IReportQueryParamService;
import com.ejianc.business.datav.service.IReportService;
import com.ejianc.business.datav.vo.ReportVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/report"})
public class ReportController
implements Serializable {
    private static final long serialVersionUID = -2057867671357638887L;
    @Autowired
    private IReportService reportService;
    @Autowired
    private IReportQueryParamService reportQueryParamService;
    @Autowired
    private IDefdocApi defdocApi;

    @PostMapping(value={"/importExcel"})
    @ResponseBody
    public CommonResponse<Map<String, Object>> importExcel(HttpServletRequest request, @RequestParam(value="file") MultipartFile file) throws IOException {
        Map<String, Object> resultMap = this.reportService.importExcel(file);
        return CommonResponse.success(resultMap);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    public CommonResponse<ReportEntity> save(HttpServletRequest request, @RequestBody JSONObject saveData) {
        ReportEntity reportEntity = this.reportService.saveReport(saveData);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)((Object)reportEntity));
    }

    @GetMapping(value={"/queryDetail"})
    @ResponseBody
    public CommonResponse<ReportEntity> queryDetail(@RequestParam Long visualId) {
        ReportEntity reportEntity = this.reportService.queryDetailByVisualId(visualId);
        return CommonResponse.success((Object)((Object)reportEntity));
    }

    @GetMapping(value={"/view"})
    @ResponseBody
    public CommonResponse<ReportVO> view(@RequestParam Long visualId, HttpServletRequest request) throws Exception {
        String params = request.getParameter("params");
        ReportVO reportVO = this.reportService.view(visualId, params, request);
        return CommonResponse.success((Object)reportVO);
    }

    @GetMapping(value={"/getQueryInfo"})
    @ResponseBody
    public CommonResponse<List<QueryParamResult>> getQueryInfo(@RequestParam Long reportId) {
        ReportEntity reportEntity = this.reportService.queryDetailByVisualId(reportId);
        List<ReportQueryParamEntity> queryParamEntities = this.reportQueryParamService.queryListByReportId(reportEntity.getId());
        if (queryParamEntities != null && queryParamEntities.size() > 0) {
            ArrayList<QueryParamResult> queryParamResultList = new ArrayList<QueryParamResult>();
            for (ReportQueryParamEntity queryParamEntity : queryParamEntities) {
                CommonResponse defdocDetailResponse;
                QueryDict queryDict;
                int i;
                QueryParamResult queryParamResult = new QueryParamResult();
                queryParamResult.setName(queryParamEntity.getQueryProperty());
                queryParamResult.setTitle(queryParamEntity.getQueryName());
                queryParamResult.setType(queryParamEntity.getQueryType());
                if ("enum".equals(queryParamEntity.getQueryType())) {
                    String queryValue = queryParamEntity.getQueryValue();
                    JSONArray jsonArray = JSON.parseArray((String)queryValue);
                    ArrayList<QueryDict> dictList = new ArrayList<QueryDict>();
                    for (i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        queryDict = new QueryDict();
                        queryDict.setTitle(jsonObject.getString("text"));
                        queryDict.setText(jsonObject.getString("text"));
                        queryDict.setValue(jsonObject.getString("value"));
                        dictList.add(queryDict);
                    }
                    queryParamResult.setDictList(dictList);
                } else if ("defdoc".equals(queryParamEntity.getQueryType()) && (defdocDetailResponse = this.defdocApi.getDefDocByDefId(Long.valueOf(Long.parseLong(queryParamEntity.getQueryValue())))).isSuccess()) {
                    ArrayList<QueryDict> dictList = new ArrayList<QueryDict>();
                    List defdocDetails = (List)defdocDetailResponse.getData();
                    for (i = 0; i < defdocDetails.size(); ++i) {
                        DefdocDetailVO defdocDetailVo = (DefdocDetailVO)defdocDetails.get(i);
                        queryDict = new QueryDict();
                        queryDict.setTitle(defdocDetailVo.getName());
                        queryDict.setText(defdocDetailVo.getName());
                        queryDict.setValue(defdocDetailVo.getName());
                        dictList.add(queryDict);
                    }
                    queryParamResult.setDictList(dictList);
                }
                queryParamResultList.add(queryParamResult);
            }
            return CommonResponse.success(queryParamResultList);
        }
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportAllExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> exportAllExcel(HttpServletRequest request, HttpServletResponse response, @RequestBody JSONObject jsonObject) throws NumberFormatException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(request.getParameterMap());
        JSONObject queryParam = jsonObject.getJSONObject("queryParam");
        queryParam.put("printAll", (Object)true);
        JSONArray base64Arry = jsonObject.getJSONArray("base64Arry");
        String visualId = queryParam.getString("visualId");
        String params = "";
        ReportVO reportVO = this.reportService.view(Long.parseLong(visualId), params, request);
        Map<String, Object> excelMap = this.reportService.exportExcel(reportVO, paramMap, base64Arry);
        File file = new File(excelMap.get("name").toString());
        response.setContentType("application/force-download");
        response.setHeader("Content-Disposition", "attachment; fileName=" + file.getName() + ";filename*=utf-8''" + URLEncoder.encode(file.getName(), "UTF-8"));
        XSSFWorkbook xssfWorkbook = (XSSFWorkbook)excelMap.get("workbook");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            xssfWorkbook.write((OutputStream)outputStream);
            String fileStr = Base64Utils.encodeToString((byte[])outputStream.toByteArray());
            resultMap.put("file", fileStr);
            resultMap.put("success", true);
            resultMap.put("name", file.getName());
        }
        catch (IOException e) {
            e.printStackTrace();
            resultMap.put("error", e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException arg25) {
                arg25.printStackTrace();
            }
        }
        return CommonResponse.success(resultMap);
    }
}

