/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.datav.bean.VisualCategoryEntity;
import com.ejianc.business.datav.bean.VisualEntity;
import com.ejianc.business.datav.service.IVisualCategoryService;
import com.ejianc.business.datav.service.IVisualService;
import com.ejianc.business.datav.vo.VisualCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/visual/category"})
public class VisualCategoryController
implements Serializable {
    private static final long serialVersionUID = -4668370123852212980L;
    @Autowired
    private IVisualCategoryService visualCategoryService;
    @Autowired
    private IVisualService visualService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody VisualCategoryVO visualCategoryVo) {
        if (visualCategoryVo.getId() != null && visualCategoryVo.getId() > 0L) {
            VisualCategoryEntity entity = (VisualCategoryEntity)((Object)this.visualCategoryService.getById(visualCategoryVo.getId()));
            entity.setCategoryKey(visualCategoryVo.getCategoryKey());
            entity.setCategoryType(visualCategoryVo.getCategoryType());
            entity.setSequence(visualCategoryVo.getSequence());
            this.visualCategoryService.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        VisualCategoryEntity entity = (VisualCategoryEntity)((Object)BeanMapper.map((Object)visualCategoryVo, VisualCategoryEntity.class));
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.visualCategoryService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<VisualCategoryVO> queryDetail(@RequestParam Long id) {
        VisualCategoryEntity entity = (VisualCategoryEntity)((Object)this.visualCategoryService.getById(id));
        if (entity != null) {
            VisualCategoryVO visualCategoryVO = (VisualCategoryVO)BeanMapper.map((Object)((Object)entity), VisualCategoryVO.class);
            return CommonResponse.success((Object)visualCategoryVO);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        List<VisualEntity> visualEntities = this.visualService.queryListByCategoryId(id);
        if (visualEntities == null || visualEntities.size() == 0) {
            this.visualCategoryService.removeById(id);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        return CommonResponse.error((String)"\u8be5\u5206\u7c7b\u4e0b\u5df2\u6709\u5927\u5c4f\u8bbe\u8ba1\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<VisualCategoryEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage pageData = this.visualCategoryService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<VisualCategoryEntity>> queryList(HttpServletRequest request) {
        String categoryType = request.getParameter("categoryType");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("categoryType", new Parameter("eq", (Object)categoryType));
        queryParam.getOrderMap().put("sequence", "asc");
        List resultList = this.visualCategoryService.queryList(queryParam, false);
        return CommonResponse.success((Object)resultList);
    }
}

