/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.datav.bean.VisualConfigEntity;
import com.ejianc.business.datav.bean.VisualEntity;
import com.ejianc.business.datav.service.IVisualConfigService;
import com.ejianc.business.datav.service.IVisualService;
import com.ejianc.business.datav.vo.VisualConfigVO;
import com.ejianc.business.datav.vo.VisualVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/visual/config"})
public class VisualConfigController
implements Serializable {
    private static final long serialVersionUID = 4361810168789479015L;
    @Autowired
    private IVisualConfigService visualConfigService;
    @Autowired
    private IVisualService visualService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody JSONObject saveData) {
        VisualVO visualVo = (VisualVO)saveData.getObject("visual", VisualVO.class);
        VisualEntity visualEntity = (VisualEntity)((Object)this.visualService.getById(visualVo.getId()));
        visualEntity.setBackgroundUrl(visualVo.getBackgroundUrl());
        this.visualService.saveOrUpdate((Object)visualEntity, false);
        VisualConfigVO visualConfigVo = (VisualConfigVO)saveData.getObject("config", VisualConfigVO.class);
        VisualConfigEntity visualConfigEntity = (VisualConfigEntity)((Object)this.visualConfigService.getById(visualConfigVo.getId()));
        visualConfigEntity.setDetail(visualConfigVo.getDetail());
        visualConfigEntity.setComponent(visualConfigVo.getComponent());
        this.visualConfigService.saveOrUpdate((Object)visualConfigEntity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetail(@RequestParam Long visualId) {
        VisualConfigEntity entity = this.visualConfigService.queryByVisualId(visualId);
        if (entity != null) {
            VisualEntity visualEntity = (VisualEntity)((Object)this.visualService.getById(visualId));
            JSONObject resultJson = new JSONObject();
            resultJson.put("visual", (Object)visualEntity);
            resultJson.put("config", (Object)entity);
            return CommonResponse.success((Object)resultJson);
        }
        return null;
    }
}

