/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.datav.bean.VisualConfigEntity;
import com.ejianc.business.datav.bean.VisualEntity;
import com.ejianc.business.datav.service.IVisualConfigService;
import com.ejianc.business.datav.service.IVisualService;
import com.ejianc.business.datav.vo.VisualConfigVO;
import com.ejianc.business.datav.vo.VisualVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/visual"})
public class VisualController
implements Serializable {
    private static final long serialVersionUID = 7043852107675563173L;
    @Autowired
    private IVisualService visualService;
    @Autowired
    private IVisualConfigService visualConfigService;

    @RequestMapping(value={"/report/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<VisualEntity> saveOrUpdateReport(@RequestBody VisualVO visualVo) {
        if (visualVo.getId() != null && visualVo.getId() > 0L) {
            VisualEntity entity = (VisualEntity)((Object)this.visualService.getById(visualVo.getId()));
            entity.setTitle(visualVo.getTitle());
            entity.setPassword(visualVo.getPassword());
            entity.setStatus(visualVo.getStatus());
            entity.setDataType(visualVo.getDataType());
            entity.setDataSourceName(visualVo.getDataSourceName());
            entity.setDataSourceId(visualVo.getDataSourceId());
            this.visualService.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((Object)((Object)entity));
        }
        Long pkId = IdWorker.getId();
        VisualEntity entity = (VisualEntity)((Object)BeanMapper.map((Object)visualVo, VisualEntity.class));
        entity.setId(pkId);
        entity.setBackgroundUrl("img/report_excel.jpg");
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.visualService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)((Object)entity));
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<VisualEntity> saveOrUpdate(@RequestBody JSONObject saveData) {
        VisualVO visualVo = (VisualVO)saveData.getObject("visual", VisualVO.class);
        if (visualVo.getId() != null && visualVo.getId() > 0L) {
            VisualEntity entity = (VisualEntity)((Object)this.visualService.getById(visualVo.getId()));
            entity.setTitle(visualVo.getTitle());
            entity.setBackgroundUrl(visualVo.getBackgroundUrl());
            entity.setCategory(visualVo.getCategory());
            entity.setPassword(visualVo.getPassword());
            entity.setStatus(visualVo.getStatus());
            this.visualService.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((Object)((Object)entity));
        }
        Long pkId = IdWorker.getId();
        VisualEntity entity = (VisualEntity)((Object)BeanMapper.map((Object)visualVo, VisualEntity.class));
        entity.setId(pkId);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.visualService.saveOrUpdate((Object)entity, false);
        VisualConfigVO visualConfigVo = (VisualConfigVO)saveData.getObject("config", VisualConfigVO.class);
        VisualConfigEntity configEntity = (VisualConfigEntity)((Object)BeanMapper.map((Object)visualConfigVo, VisualConfigEntity.class));
        configEntity.setVisualId(pkId);
        this.visualConfigService.saveOrUpdate((Object)configEntity, false);
        return CommonResponse.success((Object)((Object)entity));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<VisualVO> queryDetail(@RequestParam Long id) {
        VisualEntity entity = (VisualEntity)((Object)this.visualService.getById(id));
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), VisualVO.class));
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        this.visualService.deleteVisual(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<VisualEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.visualService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/copy"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> copy(@RequestParam Long id) {
        VisualEntity visualEntity = (VisualEntity)((Object)this.visualService.getById(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"visual_id", (Object)id);
        VisualConfigEntity visualConfigEntity = (VisualConfigEntity)((Object)this.visualConfigService.getOne((Wrapper)queryWrapper));
        Long visualId = IdWorker.getId();
        visualEntity.setId(visualId);
        this.visualService.saveOrUpdate((Object)visualEntity, false);
        visualConfigEntity.setId(IdWorker.getId());
        visualConfigEntity.setVisualId(visualId);
        this.visualConfigService.saveOrUpdate((Object)visualConfigEntity, false);
        return CommonResponse.success((String)"\u62f7\u8d1d\u6210\u529f");
    }
}

