/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.datav.bean.VisualMapEntity;
import com.ejianc.business.datav.service.IVisualMapService;
import com.ejianc.business.datav.vo.VisualMapVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/visual/map"})
public class VisualMapController
implements Serializable {
    private static final long serialVersionUID = 6365882043563591920L;
    @Autowired
    private IVisualMapService visualMapService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody VisualMapVO visualMapVo) {
        if (visualMapVo.getId() != null && visualMapVo.getId() > 0L) {
            VisualMapEntity entity = (VisualMapEntity)((Object)this.visualMapService.getById(visualMapVo.getId()));
            entity.setName(visualMapVo.getName());
            entity.setData(visualMapVo.getData());
            this.visualMapService.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        VisualMapEntity entity = (VisualMapEntity)((Object)BeanMapper.map((Object)visualMapVo, VisualMapEntity.class));
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.visualMapService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<VisualMapVO> queryDetail(@RequestParam Long id) {
        VisualMapEntity entity = (VisualMapEntity)((Object)this.visualMapService.getById(id));
        if (entity != null) {
            return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), VisualMapVO.class));
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        this.visualMapService.removeById(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<VisualMapEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.visualMapService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }
}

