/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.service.impl;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.datav.bean.MergedResult;
import com.ejianc.business.datav.bean.ReportEntity;
import com.ejianc.business.datav.bean.ReportQueryParamEntity;
import com.ejianc.business.datav.bean.VisualEntity;
import com.ejianc.business.datav.mapper.ReportMapper;
import com.ejianc.business.datav.mapper.VisualMapper;
import com.ejianc.business.datav.service.IReportQueryParamService;
import com.ejianc.business.datav.service.IReportService;
import com.ejianc.business.datav.util.ExcelUtil;
import com.ejianc.business.datav.util.HttpUtils;
import com.ejianc.business.datav.vo.ReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ReportServiceImpl
extends BaseServiceImpl<ReportMapper, ReportEntity>
implements IReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String[] JIMUREPORT_FUNCTION = new String[]{"=SUM", "=AVERAGE", "=MAX", "=MIN", "=IF", "=AND", "=OR", "=CONCAT"};
    @Autowired
    private ReportMapper reportMapper;
    @Autowired
    private VisualMapper visualMapper;
    @Value(value="${ejc.reportDataQueryUrl}")
    private String reportDataQueryUrl;
    @Value(value="${ejc.customAppDataQueryUrl}")
    private String customAppDataQueryUrl;
    @Value(value="${ejc.printDataDataQueryUrl}")
    private String printDataDataQueryUrl;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Value(value="${ejc.reportDataFieldsUrl}")
    private String reportDataFieldsUrl;
    @Value(value="${ejc.printDataFieldsUrl}")
    private String printDataFieldsUrl;
    @Value(value="${ejc.customAppDataFieldsUrl}")
    private String customAppDataFieldsUrl;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IReportQueryParamService reportQueryParamService;

    @Override
    public Map<String, Object> importExcel(MultipartFile file) throws IOException {
        InputStream inputStream = file.getInputStream();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
        XSSFSheet sheetAt = xssfWorkbook.getSheetAt(0);
        IdentityHashMap<String, Object> resultMap = new IdentityHashMap<String, Object>();
        IdentityHashMap<String, Map<String, Object>> styleMap = new IdentityHashMap<String, Map<String, Object>>();
        IdentityHashMap rowMap = new IdentityHashMap();
        int index = 0;
        for (Row row : sheetAt) {
            int rowNumber = row.getRowNum();
            IdentityHashMap<String, Serializable> cellsMap = new IdentityHashMap<String, Serializable>();
            IdentityHashMap columnMap = new IdentityHashMap();
            for (Cell cell : row) {
                Map<String, Object> mergeCell;
                int[] merges;
                MergedResult mergedResult;
                int columnIndex;
                cell.setCellType(CellType.STRING);
                IdentityHashMap<String, Object> cellMap = new IdentityHashMap<String, Object>();
                if (cell.getCellTypeEnum() != CellType.BLANK) {
                    switch (cell.getCellTypeEnum()) {
                        case STRING: {
                            cellMap.put("text", cell.getRichStringCellValue().getString());
                            break;
                        }
                        case NUMERIC: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                cellMap.put("text", cell.getRichStringCellValue());
                                break;
                            }
                            cellMap.put("text", cell.getNumericCellValue());
                            break;
                        }
                        case BOOLEAN: {
                            cellMap.put("text", cell.getRichStringCellValue());
                        }
                    }
                    columnIndex = cell.getColumnIndex();
                    mergedResult = this.toMergedResult((Sheet)sheetAt, rowNumber, columnIndex);
                    if (mergedResult.isMerged()) {
                        merges = new int[]{};
                        merges = new int[]{mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol()};
                        cellMap.put("merge", merges);
                    }
                    mergeCell = this.parseCell(cell, mergedResult.isMerged());
                    styleMap.put(Integer.valueOf(++index).toString(), mergeCell);
                    cellMap.put("style", index);
                    columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                } else {
                    columnIndex = cell.getColumnIndex();
                    mergedResult = this.toMergedResult((Sheet)sheetAt, rowNumber, columnIndex);
                    if (mergedResult.isMerged()) {
                        merges = new int[]{};
                        merges = new int[]{mergedResult.getEndRow() - mergedResult.getStartRow(), mergedResult.getEndCol() - mergedResult.getStartCol()};
                        cellMap.put("merge", merges);
                    }
                    if (!mergedResult.isMerged()) {
                        mergeCell = this.parseCell(cell, mergedResult.isMerged());
                        styleMap.put(Integer.valueOf(++index).toString(), mergeCell);
                        cellMap.put("style", index);
                        columnMap.put(Integer.valueOf(columnIndex).toString(), cellMap);
                    }
                }
                resultMap.put("style", styleMap);
            }
            cellsMap.put("cells", columnMap);
            cellsMap.put("height", Float.valueOf(row.getHeightInPoints()));
            rowMap.put(Integer.valueOf(rowNumber).toString(), cellsMap);
            resultMap.put("rows", rowMap);
        }
        return resultMap;
    }

    private MergedResult toMergedResult(Sheet sheet, int rowNum, int columnIndex) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            int firstColumn = cellRangeAddress.getFirstColumn();
            int lastColumn = cellRangeAddress.getLastColumn();
            int firstRow = cellRangeAddress.getFirstRow();
            int lastRow = cellRangeAddress.getLastRow();
            if (rowNum < firstRow || rowNum > lastRow || columnIndex < firstColumn || columnIndex > lastColumn) continue;
            return new MergedResult(true, firstRow, lastRow, firstColumn, lastColumn);
        }
        return new MergedResult(false, 0, 0, 0, 0);
    }

    private Map<String, Object> parseCell(Cell cell, boolean isMerged) {
        XSSFColor xssfColor;
        byte[] rgbs;
        XSSFFont xssfFont;
        CellStyle cellStyle = cell.getCellStyle();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String[]> borderMap = new HashMap<String, String[]>();
        HashMap<String, Comparable<Boolean>> fontMap = new HashMap<String, Comparable<Boolean>>();
        if (((XSSFCell)cell).getCellStyle().getFont().getBold()) {
            fontMap.put("bold", Boolean.valueOf(true));
        }
        fontMap.put("size", Short.valueOf(((XSSFCell)cell).getCellStyle().getFont().getFontHeightInPoints()));
        String[] thins = new String[]{"thin", "#000"};
        if (cellStyle.getBorderBottomEnum() == BorderStyle.THIN) {
            borderMap.put("bottom", thins);
        }
        if (cellStyle.getBorderLeftEnum() == BorderStyle.THIN) {
            borderMap.put("left", thins);
        }
        if (cellStyle.getBorderRightEnum() == BorderStyle.THIN) {
            borderMap.put("right", thins);
        }
        if (cellStyle.getBorderTopEnum() == BorderStyle.THIN) {
            borderMap.put("top", thins);
        }
        if (cellStyle.getAlignmentEnum() == HorizontalAlignment.CENTER) {
            resultMap.put("align", "center");
        }
        if (cellStyle.getBorderBottomEnum() == BorderStyle.THIN && cellStyle.getBorderLeftEnum() == BorderStyle.THIN && cellStyle.getBorderTopEnum() == BorderStyle.THIN && isMerged) {
            borderMap.put("right", thins);
        }
        if (cellStyle.getBorderRightEnum() != BorderStyle.NONE || cellStyle.getBorderBottomEnum() != BorderStyle.NONE || cellStyle.getBorderLeftEnum() != BorderStyle.NONE || cellStyle.getBorderTopEnum() != BorderStyle.NONE) {
            resultMap.put("border", borderMap);
        }
        if ((xssfFont = ((XSSFCell)cell).getCellStyle().getFont()).getXSSFColor() != null && (rgbs = (xssfColor = xssfFont.getXSSFColor()).getRGB()).length > 3) {
            String arg11 = String.format("#%02X%02X%02X", rgbs[0], rgbs[1], rgbs[2]);
            resultMap.put("color", arg11);
        }
        if (((XSSFCell)cell).getCellStyle().getFillPatternEnum() == FillPatternType.SOLID_FOREGROUND) {
            byte[] arg12 = ((XSSFCell)cell).getCellStyle().getFillForegroundColorColor().getRGB();
            String arg13 = String.format("#%02X%02X%02X", arg12[0], arg12[1], arg12[2]);
            resultMap.put("bgcolor", arg13);
        }
        resultMap.put("font", fontMap);
        return resultMap;
    }

    @Override
    public ReportEntity saveReport(JSONObject saveData) {
        Long reportId = 0L;
        Long visualId = saveData.getLong("visualId");
        VisualEntity visualEntity = (VisualEntity)((Object)this.visualMapper.selectById(visualId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"visual_id", (Object)visualId);
        ReportEntity reportEntity = (ReportEntity)((Object)this.reportMapper.selectOne((Wrapper)queryWrapper));
        String name = saveData.getString("name");
        String type = saveData.getString("type");
        saveData.remove((Object)"designerObj");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String code = dateFormat.format(new Date());
        if (reportEntity == null) {
            reportId = IdWorker.getId();
            reportEntity = new ReportEntity();
            reportEntity.setId(reportId);
            reportEntity.setTableId(visualEntity.getDataSourceId());
            reportEntity.setCode(code);
            reportEntity.setVisualId(visualId);
            reportEntity.setJsonStr(saveData.toJSONString());
            reportEntity.setName(name);
            reportEntity.setType(type);
            saveData.remove((Object)"excel_config_id");
            super.saveOrUpdate((Object)reportEntity, false);
        } else {
            reportId = reportEntity.getId();
            reportEntity.setName(name);
            reportEntity.setType(type);
            reportEntity.setJsonStr(saveData.toJSONString());
            super.saveOrUpdate((Object)reportEntity, false);
        }
        this.reportQueryParamService.deleteQueryParamByReportId(reportId);
        JSONObject rowJson = saveData.getJSONObject("rows");
        for (Map.Entry entry : rowJson.entrySet()) {
            try {
                String value = JSON.toJSONString(entry.getValue());
                JSONObject cellsJson = JSON.parseObject((String)value);
                for (Map.Entry cellEntry : cellsJson.entrySet()) {
                    String cellValue = JSON.toJSONString(cellEntry.getValue());
                    JSONObject cellObject = JSON.parseObject((String)cellValue);
                    for (Map.Entry resultEntry : cellObject.entrySet()) {
                        String searchFlag;
                        String resultValue = JSON.toJSONString(resultEntry.getValue());
                        JSONObject resultObject = JSON.parseObject((String)resultValue);
                        String text = resultObject.getString("text");
                        if (text.indexOf("#{") == -1 || !"1".equals(searchFlag = resultObject.getString("searchFlag"))) continue;
                        ReportQueryParamEntity queryParamEntity = new ReportQueryParamEntity();
                        queryParamEntity.setReportId(reportId);
                        text = text.replace("#{", "").replace("}", "");
                        String[] textArr = text.split("\\.");
                        queryParamEntity.setQueryProperty(textArr[textArr.length - 1]);
                        String queryType = resultObject.getString("searchType");
                        queryParamEntity.setQueryType(queryType);
                        if ("defdoc".equals(queryType)) {
                            DefdocVO defdocVo;
                            String defdocCode = resultObject.getString("defdocCode");
                            CommonResponse defdocResponse = this.defdocApi.getDefdocByDefCode(defdocCode);
                            if (defdocResponse.isSuccess() && (defdocVo = (DefdocVO)defdocResponse.getData()) != null) {
                                queryParamEntity.setQueryValue(defdocVo.getId() + "");
                            }
                        } else if ("enum".equals(queryType)) {
                            String enumValue = resultObject.getString("enumValue");
                            queryParamEntity.setQueryValue(enumValue);
                        }
                        String queryName = resultObject.getString("queryName");
                        queryParamEntity.setQueryName(queryName);
                        this.reportQueryParamService.saveOrUpdate((Object)queryParamEntity, false);
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return reportEntity;
    }

    @Override
    public ReportEntity queryDetailByVisualId(Long visualId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"visual_id", (Object)visualId);
        ReportEntity reportEntity = (ReportEntity)((Object)super.getOne((Wrapper)queryWrapper));
        if (reportEntity == null) {
            reportEntity = new ReportEntity();
            VisualEntity visualEntity = (VisualEntity)((Object)this.visualMapper.selectById(visualId));
            reportEntity.setName(visualEntity.getTitle());
        }
        return reportEntity;
    }

    @Override
    public ReportVO view(Long visualId, String params, HttpServletRequest req) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"visual_id", (Object)visualId);
        ReportEntity reportEntity = (ReportEntity)((Object)super.getOne((Wrapper)queryWrapper));
        ReportVO reportVo = (ReportVO)BeanMapper.map((Object)((Object)reportEntity), ReportVO.class);
        VisualEntity visual = (VisualEntity)((Object)this.visualMapper.selectById(reportVo.getVisualId()));
        JSONObject dataList = this.loadData(visual, params, req);
        JSONObject fieldsHandlerResult = this.getFieldsTree(visual, req);
        reportVo.setFieldsTree((JSONObject)fieldsHandlerResult.get((Object)"fieldsTree"));
        List imageList = (List)fieldsHandlerResult.get((Object)"sourceTypeFields");
        if (!imageList.isEmpty()) {
            this.loadAttachList(dataList, imageList);
        }
        reportVo.setDataList(dataList);
        return reportVo;
    }

    private void loadAttachList(JSONObject dataList, List<JSONObject> imageList) {
        JSONArray data = null;
        JSONObject row = null;
        JSONObject param = null;
        List sourceTypes = null;
        ArrayList<Long> sourceIds = null;
        Map sourceTypeFieldCodeMap = null;
        HashMap fieldAttachs = new HashMap();
        for (JSONObject sourceTypeInfo : imageList) {
            param = new JSONObject();
            sourceIds = new ArrayList<Long>();
            data = (JSONArray)((JSONObject)dataList.get((Object)sourceTypeInfo.getString("code"))).get((Object)"list");
            for (Object rowObj : data) {
                row = (JSONObject)rowObj;
                sourceIds.add(row.getLong("id"));
            }
            sourceTypes = (List)sourceTypeInfo.get((Object)"sourceTypeList");
            if (sourceTypes.isEmpty()) continue;
            sourceTypeFieldCodeMap = (Map)sourceTypeInfo.get((Object)"relation");
            param.put("sourceIds", sourceIds);
            param.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypes));
            param.put("orderType", (Object)"asc");
            CommonResponse attachResp = this.attachmentApi.queryAllBySourceIdList(param);
            if (!attachResp.isSuccess() || !CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) continue;
            for (AttachmentVO attachment : (List)attachResp.getData()) {
                if (null == fieldAttachs.get(attachment.getSourceType())) {
                    fieldAttachs.put(attachment.getSourceType(), new ArrayList());
                }
                ((List)fieldAttachs.get(attachment.getSourceType())).add(attachment);
            }
            for (String sourceType : sourceTypeFieldCodeMap.keySet()) {
                for (Object rowObj : data) {
                    row = (JSONObject)rowObj;
                    row.put((String)sourceTypeFieldCodeMap.get(sourceType), fieldAttachs.get(sourceType));
                }
            }
        }
    }

    private JSONObject loadData(VisualEntity visual, String params, HttpServletRequest req) {
        JSONObject resp = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)params)) {
            JSONObject paramJson = JSONObject.parseObject((String)params);
            if (StringUtils.isNotBlank((CharSequence)paramJson.getString("pageNo"))) {
                paramMap.put("pageIndex", paramJson.getString("pageNo"));
            }
            if (StringUtils.isNotBlank((CharSequence)paramJson.getString("pageSize"))) {
                paramMap.put("pageSize", paramJson.getString("pageSize"));
            }
            if (StringUtils.isNotBlank((CharSequence)paramJson.getString("visualId"))) {
                paramMap.put("visualId", paramJson.getString("visualId"));
            }
            Object params2 = new HashMap();
            for (Map.Entry entry : paramJson.entrySet()) {
                String key = (String)entry.getKey();
                if (!("pageNo".equals(key) || "pageSize".equals(key) || "visualId".equals(key))) {
                    if (params2.containsKey(key = key.replace("_begin", "").replace("_end", ""))) {
                        params2.put(key, new Parameter("in", (Object)(((Parameter)paramMap.get(key)).getValue() + "," + entry.getValue())));
                    } else {
                        params2.put(key, new Parameter("like", (Object)(entry.getValue() + "")));
                    }
                }
                paramMap.put("params", params2);
            }
        }
        String url = null;
        switch (visual.getDataType()) {
            case "1": {
                url = this.reportDataQueryUrl.indexOf("http") < 0 ? this.BASE_HOST + this.reportDataQueryUrl + "/" + visual.getDataSourceId() : this.reportDataQueryUrl + "/" + visual.getDataSourceId();
                resp = this.queryData(url, paramMap, "post", req);
                break;
            }
            case "2": {
                url = this.printDataDataQueryUrl.indexOf("http") < 0 ? this.BASE_HOST + this.printDataDataQueryUrl : this.printDataDataQueryUrl;
                paramMap.put("billId", "418826829908148304");
                paramMap.put("boId", visual.getDataSourceId().toString());
                resp = this.queryData(url, paramMap, "get", req);
                break;
            }
            case "3": {
                url = this.customAppDataQueryUrl.indexOf("http") < 0 ? this.BASE_HOST + this.customAppDataQueryUrl + "/" + visual.getDataSourceId() : this.customAppDataQueryUrl + "/" + visual.getDataSourceId();
                resp = this.queryData(url, paramMap, "post", req);
                break;
            }
            default: {
                resp = new JSONObject();
            }
        }
        JSONObject project = resp.getJSONObject("project");
        if (project != null && paramMap.get("pageSize") != null) {
            Long count = project.getLong("count");
            Integer pageSize = Integer.parseInt(paramMap.get("pageSize") + "");
            long remainCount = count % (long)pageSize.intValue();
            if (remainCount > 0L) {
                project.put("total", (Object)(Math.ceil(count / (long)pageSize.intValue()) + 1.0));
            } else {
                project.put("total", (Object)Math.ceil(count / (long)pageSize.intValue()));
            }
        }
        return resp;
    }

    private JSONObject queryData(String url, Map<String, Object> params, String reqType, HttpServletRequest req) {
        JSONObject resp = null;
        try {
            String reqResp = "";
            this.logger.info("\u8bf7\u6c42\u5730\u5740-{}\uff0c\u53c2\u6570-{}", (Object)url, params);
            reqResp = "post".equals(reqType) ? HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(params)) : HttpTookit.get((String)url, params, (HttpServletRequest)req);
            this.logger.info("\u8bf7\u6c42\u5730\u5740-{}\uff0c\u53c2\u6570-{}, \u7ed3\u679c-{}", new Object[]{url, params, reqResp});
            CommonResponse data = (CommonResponse)JSONObject.parseObject((String)reqResp, CommonResponse.class);
            resp = (JSONObject)data.getData();
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u5730\u5740-{}\uff0c\u53c2\u6570-{}\u5f02\u5e38", new Object[]{url, params, e});
        }
        return resp;
    }

    private JSONObject getFieldsTree(VisualEntity visual, HttpServletRequest req) throws Exception {
        String url = null;
        HashMap<String, String> param = new HashMap<String, String>();
        JSONObject resp = new JSONObject();
        ArrayList<String> sourceTypeList = null;
        ArrayList<JSONObject> imageFields = new ArrayList<JSONObject>();
        JSONObject imageField = null;
        JSONObject fields = new JSONObject();
        switch (visual.getDataType()) {
            case "1": {
                param.put("tblId", visual.getDataSourceId().toString());
                url = this.reportDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.reportDataFieldsUrl : this.reportDataFieldsUrl;
                break;
            }
            case "2": {
                param.put("id", visual.getDataSourceId().toString());
                url = this.printDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.printDataFieldsUrl : this.printDataFieldsUrl;
                break;
            }
            default: {
                param.put("appId", visual.getDataSourceId().toString());
                url = this.customAppDataFieldsUrl.indexOf("http") < 0 ? this.BASE_HOST + this.customAppDataFieldsUrl : this.customAppDataFieldsUrl;
            }
        }
        String reqResult = HttpTookit.get((String)url, param, (HttpServletRequest)req);
        this.logger.info("\u8bf7\u6c42-{},\u53c2\u6570-{},\u7ed3\u679c-{}", new Object[]{url, JSONObject.toJSONString(param), reqResult});
        CommonResponse reqResp = (CommonResponse)JSONObject.parseObject((String)reqResult, CommonResponse.class);
        if (!reqResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5b57\u6bb5\u5931\u8d25\uff0c{}", (Object)reqResp.getMsg());
        }
        JSONArray fieldsArr = (JSONArray)reqResp.getData();
        JSONObject fieldsTree = null;
        JSONObject attrJson = null;
        HashMap<String, String> sourceTypeFieldCodeMap = null;
        List attrs = null;
        for (Object sigleFieldsTree : fieldsArr) {
            fieldsTree = new JSONObject();
            imageField = new JSONObject();
            sourceTypeList = new ArrayList<String>();
            JSONObject fieldsTreeJson = (JSONObject)sigleFieldsTree;
            attrs = JSONArray.parseArray((String)fieldsTreeJson.getString("children"), JSONObject.class);
            sourceTypeFieldCodeMap = new HashMap<String, String>();
            for (JSONObject attr : attrs) {
                attrJson = new JSONObject();
                attrJson.put("dataFormat", (Object)attr.getString("dataFormat"));
                fieldsTree.put(attr.getString("code"), (Object)attrJson);
                if (null == attr.get((Object)"fieldtype") || !"image".equals(attr.getString("fieldtype")) || null == attr.get((Object)"sourceType")) continue;
                sourceTypeList.add(attr.getString("sourceType"));
                sourceTypeFieldCodeMap.put(attr.getString("sourceType"), attr.getString("code"));
            }
            fieldsTree.put("fieldsTree", (Object)fieldsTreeJson.getString("dataFormat"));
            imageField.put("sourceTypeList", sourceTypeList);
            imageField.put("code", (Object)fieldsTreeJson.getString("code"));
            imageField.put("relation", sourceTypeFieldCodeMap);
            imageFields.add(imageField);
            fields.put(fieldsTreeJson.getString("code"), (Object)fieldsTree);
        }
        resp.put("fieldsTree", (Object)fields);
        resp.put("sourceTypeFields", imageFields);
        return resp;
    }

    @Override
    public Map<String, Object> exportExcel(ReportVO reportVO, Map<String, Object> paramMap, JSONArray base64Arry) {
        JSONObject jsonObject = JSON.parseObject((String)reportVO.getJsonStr());
        XSSFWorkbook workbook = this.getWorkbook(jsonObject, base64Arry);
        String fileName = reportVO.getName() + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()).toString();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("name", fileName + ".xlsx");
        resultMap.put("workbook", workbook);
        return resultMap;
    }

    private XSSFWorkbook getWorkbook(JSONObject jsonObject, JSONArray base64Arry) {
        JSONObject rowsJson;
        JSONArray imgList = null;
        JSONArray chartList = null;
        JSONArray barcodeList = null;
        JSONArray qrcodeList = null;
        if (jsonObject.containsKey((Object)"imgList")) {
            imgList = jsonObject.getJSONArray("imgList");
        }
        if (jsonObject.containsKey((Object)"chartList")) {
            chartList = jsonObject.getJSONArray("chartList");
        }
        if (jsonObject.containsKey((Object)"barcodeList")) {
            barcodeList = jsonObject.getJSONArray("barcodeList");
        }
        if (jsonObject.containsKey((Object)"qrcodeList")) {
            qrcodeList = jsonObject.getJSONArray("qrcodeList");
        }
        if (chartList != null && chartList.size() > 0 && base64Arry.size() > 0) {
            for (int i = 0; i < chartList.size(); ++i) {
                rowsJson = chartList.getJSONObject(i);
                String layerId = (String)rowsJson.get((Object)"layer_id");
                JSONArray base64Object = base64Arry;
                String base64Str = "";
                for (int k = 0; k < base64Object.size(); ++k) {
                    Map bas64eMap = (Map)base64Object.get(k);
                    if (!((String)bas64eMap.get("id")).equals(layerId)) continue;
                    base64Str = (String)bas64eMap.get("base64");
                }
                String[] base64Arr = base64Str.split("base64,");
                rowsJson.put("url", (Object)base64Arr[1]);
            }
        }
        XSSFWorkbook xssWorkbook = new XSSFWorkbook();
        rowsJson = jsonObject.getJSONObject("rows");
        JSONObject colsJson = jsonObject.getJSONObject("cols");
        if (colsJson.containsKey((Object)"len")) {
            colsJson.remove((Object)"len");
        }
        if (rowsJson.containsKey((Object)"-1")) {
            rowsJson.remove((Object)"-1");
        }
        String jsonName = jsonObject.getString("name");
        Object styles = jsonObject.get((Object)"styles");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (styles instanceof JSONArray) {
            JSONArray stylesArray = jsonObject.getJSONArray("styles");
            for (int i = 0; i < stylesArray.size(); ++i) {
                paramMap.put(String.valueOf(i), stylesArray.get(i));
            }
        }
        XSSFSheet xssfSheet = xssWorkbook.createSheet(jsonName);
        this.fillSheet((Sheet)xssfSheet, colsJson);
        xssfSheet.setDefaultRowHeightInPoints(19.5f);
        this.fillCell(xssWorkbook, rowsJson, paramMap, (Sheet)xssfSheet);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        this.mergeCell(rowsJson, (Sheet)xssfSheet, xssWorkbook, paramMap, paramMap1);
        if (imgList != null) {
            this.fillImgList((Sheet)xssfSheet, xssWorkbook, imgList, paramMap1);
        }
        if (chartList != null) {
            this.fillChartList((Sheet)xssfSheet, xssWorkbook, chartList);
        }
        if (barcodeList != null) {
            this.fillBarOrQrCode((Sheet)xssfSheet, (Workbook)xssWorkbook, barcodeList, base64Arry);
        }
        if (qrcodeList != null) {
            this.fillBarOrQrCode((Sheet)xssfSheet, (Workbook)xssWorkbook, qrcodeList, base64Arry);
        }
        return xssWorkbook;
    }

    private void mergeCell(JSONObject paramJSONObject, Sheet paramSheet, XSSFWorkbook paramXSSFWorkbook, Map<String, Object> paramMap, Map<String, String> paramMap1) {
        for (String str1 : paramJSONObject.keySet()) {
            JSONObject localJSONObject1;
            if ("len".equals(str1) || "cells".equals(str1) || "isDrag".equals(str1) || null == (localJSONObject1 = paramJSONObject.getJSONObject(str1).getJSONObject("cells"))) continue;
            for (String str2 : localJSONObject1.keySet()) {
                String str4;
                JSONObject localJSONObject3;
                JSONObject localJSONObject2 = localJSONObject1.getJSONObject(str2);
                if (!localJSONObject2.containsKey((Object)"merge")) continue;
                String str3 = localJSONObject2.getString("merge");
                String[] arrayOfString = ReportServiceImpl.mergeStr(str3, "[", "]").split(",");
                int i = Integer.parseInt(arrayOfString[0]);
                int j = Integer.parseInt(arrayOfString[1]);
                if (str3 == null || "".equals(str3)) continue;
                int k = Integer.parseInt(str1);
                int m = i + k;
                int n = Integer.parseInt(str2);
                int i1 = j + n;
                CellRangeAddress localCellRangeAddress = new CellRangeAddress(k, m, n, i1);
                try {
                    paramSheet.addMergedRegion(localCellRangeAddress);
                }
                catch (IllegalArgumentException localIllegalArgumentException) {
                    this.logger.info("\u5408\u5e76\u5355\u5143\u683c\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u91cd\u590d\u6216\u5355\u4e2a\u5355\u5143\u683c\u4e0d\u5141\u8bb8\u5408\u5e76");
                }
                paramMap1.put(String.valueOf(k) + "," + String.valueOf(n), String.valueOf(m));
                if (!localJSONObject2.containsKey((Object)"style") || !(localJSONObject3 = (JSONObject)paramMap.get(str4 = localJSONObject2.getString("style"))).containsKey((Object)"border")) continue;
                JSONObject localJSONObject4 = localJSONObject3.getJSONObject("border");
                Iterator localIterator3 = localJSONObject4.keySet().iterator();
                while (localIterator3.hasNext()) {
                    String str5;
                    switch (str5 = (String)localIterator3.next()) {
                        case "top": {
                            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)localCellRangeAddress, (Sheet)paramSheet);
                            break;
                        }
                        case "left": {
                            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)localCellRangeAddress, (Sheet)paramSheet);
                            break;
                        }
                        case "bottom": {
                            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)localCellRangeAddress, (Sheet)paramSheet);
                            break;
                        }
                        case "right": {
                            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)localCellRangeAddress, (Sheet)paramSheet);
                        }
                    }
                }
            }
        }
    }

    public static String mergeStr(String paramString1, String paramString2, String paramString3) {
        int i = paramString1.indexOf(paramString2);
        int j = paramString1.indexOf(paramString3);
        if (i < 0) {
            return "";
        }
        if (j < 0) {
            return "";
        }
        String str = paramString1.substring(i, j).substring(paramString2.length());
        return str;
    }

    private void fillBarOrQrCode(Sheet paramSheet, Workbook paramWorkbook, JSONArray paramJSONArray, JSONArray paramList) {
        XSSFDrawing localXSSFDrawing = (XSSFDrawing)paramSheet.createDrawingPatriarch();
        for (int i = 0; i < paramJSONArray.size(); ++i) {
            Object localObject1;
            JSONObject localJSONObject = paramJSONArray.getJSONObject(i);
            int j = 0;
            int k = 0;
            String str1 = "";
            String str2 = "";
            k = Integer.valueOf(localJSONObject.getString("col"));
            j = Integer.valueOf(localJSONObject.getString("row"));
            str1 = String.valueOf(localJSONObject.get((Object)"width"));
            str2 = String.valueOf(localJSONObject.get((Object)"height"));
            String str3 = (String)localJSONObject.get((Object)"layer_id");
            String str4 = "";
            for (int m = 0; m < paramList.size(); ++m) {
                localObject1 = (Map)paramList.get(m);
                Object localObject2 = localObject1.get("id");
                if (!str3.equals(localObject2.toString())) continue;
                str4 = (String)localObject1.get("base64");
            }
            byte[] arrayOfByte = new byte[]{};
            arrayOfByte = Base64.decode((CharSequence)str4.replace("data:image/png;base64,", ""));
            localObject1 = arrayOfByte;
            float f = Float.parseFloat(str2);
            Integer localInteger1 = this.sheetCalcute(paramSheet, j, f);
            Integer localInteger2 = this.sheetCalcute2(paramSheet, j, k, Float.parseFloat(str1));
            if (localInteger2 == 0 || localInteger1 == 0) {
                int n = j + Integer.parseInt(String.format("%.0f", Float.valueOf(Float.parseFloat(str2) / 25.0f)));
                int i1 = Integer.parseInt(String.format("%.0f", Float.valueOf(Float.parseFloat(str1) / 100.0f)));
                XSSFClientAnchor localXSSFClientAnchor2 = new XSSFClientAnchor(0, 0, Integer.parseInt(str1), Integer.parseInt(str2), k, j, k + i1, i + n);
                localXSSFDrawing.createPicture(localXSSFClientAnchor2, paramWorkbook.addPicture((byte[])localObject1, 5));
                continue;
            }
            XSSFClientAnchor localXSSFClientAnchor1 = new XSSFClientAnchor(0, 0, Integer.parseInt(str1), Integer.parseInt(str2), k, j, localInteger2 + 1, localInteger1.intValue());
            localXSSFDrawing.createPicture(localXSSFClientAnchor1, paramWorkbook.addPicture((byte[])localObject1, 5));
        }
    }

    private void fillSheet(Sheet sheet, JSONObject jsonObject) {
        sheet.setDefaultColumnWidth(12);
        for (String columnIndex : jsonObject.keySet()) {
            JSONObject columnObject = (JSONObject)jsonObject.get((Object)columnIndex);
            sheet.setColumnWidth(Integer.parseInt(columnIndex), 35 * (int)((double)columnObject.getInteger("width").intValue() + 0.72));
        }
    }

    private void fillCell(XSSFWorkbook paramXSSFWorkbook, JSONObject paramJSONObject, Map<String, Object> paramMap, Sheet paramSheet) {
        for (String str1 : paramJSONObject.keySet()) {
            if ("cells".equals(str1) || "isDrag".equals(str1)) continue;
            int i = -1;
            try {
                i = Integer.parseInt(str1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i < 0) continue;
            Row localRow = paramSheet.createRow(i);
            if (paramJSONObject.getJSONObject(str1).containsKey((Object)"height")) {
                int localObject = paramJSONObject.getJSONObject(str1).getInteger("height");
                localRow.setHeightInPoints((float)Integer.valueOf(localObject).intValue() - 9.0f);
            }
            JSONObject localObject = paramJSONObject.getJSONObject(str1).getJSONObject("cells");
            localObject = this.toJsonObject(localObject);
            for (String str2 : localObject.keySet()) {
                if ("-1".equals(str2)) continue;
                JSONObject localJSONObject = localObject.getJSONObject(str2);
                Cell localCell = localRow.createCell(Integer.parseInt(str2));
                if (localJSONObject.containsKey((Object)"style")) {
                    this.fillCellStyle(localJSONObject, paramMap, paramXSSFWorkbook, localCell);
                }
                if (!localJSONObject.containsKey((Object)"text")) continue;
                String str3 = localJSONObject.getString("text");
                String str4 = "";
                try {
                    str4 = this.formatStr(localJSONObject, paramMap, str3);
                }
                catch (Exception localException) {
                    localException.printStackTrace();
                }
                boolean bool = str3.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
                if (ExcelUtil.isHave(JIMUREPORT_FUNCTION, str3)) {
                    localCell.setCellFormula(str3.split("=")[1]);
                    continue;
                }
                if (bool && StringUtils.isNotEmpty((CharSequence)str3) && str3.length() < 11 && !"0".equals(String.valueOf(str3.charAt(0)))) {
                    localCell.setCellValue(Double.parseDouble(str3));
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)str4)) {
                    localCell.setCellValue(str4);
                    continue;
                }
                localCell.setCellValue(str3);
            }
        }
    }

    private void fillCellStyle(JSONObject jsonObject, Map<String, Object> paramMap, XSSFWorkbook xssfWorkbook, Cell cell) {
        String styleStr;
        if (jsonObject.containsKey((Object)"style") && (styleStr = jsonObject.getString("style")) != null && !"null".equals(styleStr)) {
            String alignUpper;
            JSONObject styleObj = (JSONObject)paramMap.get(styleStr);
            XSSFCellStyle xssfCellStyle = xssfWorkbook.createCellStyle();
            if (!styleObj.containsKey((Object)"align")) {
                xssfCellStyle.setAlignment(HorizontalAlignment.LEFT);
            } else {
                alignUpper = styleObj.getString("align").toUpperCase();
                xssfCellStyle.setAlignment(HorizontalAlignment.valueOf((String)alignUpper));
            }
            if (!styleObj.containsKey((Object)"valign")) {
                xssfCellStyle.setVerticalAlignment(VerticalAlignment.valueOf((String)"CENTER"));
            } else {
                alignUpper = styleObj.getString("valign").toUpperCase();
                if ("MIDDLE".equals(alignUpper)) {
                    alignUpper = "CENTER";
                }
                xssfCellStyle.setVerticalAlignment(VerticalAlignment.valueOf((String)alignUpper));
            }
            if (styleObj.containsKey((Object)"bgcolor")) {
                alignUpper = styleObj.getString("bgcolor");
                XSSFColor xssfColor = new XSSFColor();
                if (alignUpper.indexOf("#") != -1) {
                    byte[] rgbByte = new byte[]{(byte)Integer.parseInt(alignUpper.substring(1, 3), 16), (byte)Integer.parseInt(alignUpper.substring(3, 5), 16), (byte)Integer.parseInt(alignUpper.substring(5, 7), 16)};
                    xssfColor.setRGB(rgbByte);
                }
                xssfCellStyle.setFillForegroundColor(xssfColor);
                xssfCellStyle.setFillBackgroundColor(xssfColor);
                xssfCellStyle.setFillPattern(FillPatternType.BIG_SPOTS);
            }
            if (styleObj.containsKey((Object)"font") || styleObj.containsKey((Object)"underline") || styleObj.containsKey((Object)"strike")) {
                XSSFFont xssfFont = xssfWorkbook.createFont();
                JSONObject fontObj = (JSONObject)styleObj.get((Object)"font");
                Object underline = styleObj.get((Object)"underline");
                Object strike = styleObj.get((Object)"strike");
                if (fontObj != null && fontObj.containsKey((Object)"name")) {
                    xssfFont.setFontName(fontObj.getString("name"));
                }
                if (fontObj != null && fontObj.containsKey((Object)"italic")) {
                    xssfFont.setItalic(true);
                }
                if (null != underline) {
                    xssfFont.setUnderline((byte)1);
                }
                if (null != strike) {
                    xssfFont.setStrikeout(true);
                }
                if (fontObj != null && fontObj.containsKey((Object)"size")) {
                    xssfFont.setFontHeightInPoints(fontObj.getShort("size").shortValue());
                }
                if (fontObj != null && fontObj.containsKey((Object)"bold")) {
                    boolean bold = fontObj.getBoolean("bold");
                    xssfFont.setBold(bold);
                }
                if (styleObj.containsKey((Object)"color")) {
                    String color = styleObj.getString("color");
                    XSSFColor xssfColor = new XSSFColor();
                    if (color.length() > 7) {
                        byte[] colorByte = new byte[]{(byte)Integer.parseInt(color.substring(1, 3), 16), (byte)Integer.parseInt(color.substring(3, 5), 16), (byte)Integer.parseInt(color.substring(5, 7), 16)};
                        xssfColor.setRGB(colorByte);
                    }
                    xssfFont.setColor(xssfColor);
                }
                xssfCellStyle.setFont((Font)xssfFont);
            }
            if (styleObj.containsKey((Object)"border")) {
                JSONObject localObject1 = styleObj.getJSONObject("border");
                Iterator localObject2 = localObject1.keySet().iterator();
                while (localObject2.hasNext()) {
                    String localObject3;
                    switch (localObject3 = (String)localObject2.next()) {
                        case "top": {
                            xssfCellStyle.setBorderTop(BorderStyle.THIN);
                            break;
                        }
                        case "left": {
                            xssfCellStyle.setBorderLeft(BorderStyle.THIN);
                            break;
                        }
                        case "bottom": {
                            xssfCellStyle.setBorderBottom(BorderStyle.THIN);
                            break;
                        }
                        case "right": {
                            xssfCellStyle.setBorderRight(BorderStyle.THIN);
                        }
                    }
                }
            }
            xssfCellStyle.setWrapText(true);
            cell.setCellStyle((CellStyle)xssfCellStyle);
        }
    }

    public String formatStr(JSONObject paramJSONObject, Map<String, Object> paramMap, String paramString) throws Exception {
        SimpleDateFormat localSimpleDateFormat2;
        SimpleDateFormat localSimpleDateFormat1;
        JSONObject localJSONObject;
        Object localObject;
        String str1 = paramJSONObject.getString("style");
        if (str1 != null && !"null".equals(str1) && null != (localObject = (localJSONObject = (JSONObject)paramMap.get(str1)).get((Object)"format")) && null != (localSimpleDateFormat1 = ExcelUtil.getFormat(localObject.toString())) && StringUtils.isNotEmpty((CharSequence)paramString) && null != (localSimpleDateFormat2 = ExcelUtil.getDataFormat(paramString))) {
            Date localDate = localSimpleDateFormat2.parse(paramString);
            String str2 = localSimpleDateFormat1.format(localDate);
            this.logger.info("\u65e5\u671f\u683c\u5f0f\u5316\u4e4b\u540e\u7684\u6587\u672c\uff1a" + str2);
            return str2;
        }
        return "";
    }

    private JSONObject toJsonObject(JSONObject paramJSONObject) {
        String localObject2;
        ArrayList<Integer> localArrayList = new ArrayList<Integer>();
        for (String localObject2 : paramJSONObject.keySet()) {
            if (!StringUtils.isNotEmpty((CharSequence)localObject2) || "NaN".equals(localObject2)) continue;
            localArrayList.add(Integer.parseInt(localObject2));
        }
        Collections.sort(localArrayList);
        localObject2 = new JSONArray();
        JSONObject localJSONObject1 = new JSONObject(true);
        for (Integer localInteger : localArrayList) {
            JSONObject localJSONObject2 = paramJSONObject.getJSONObject(String.valueOf(localInteger));
            ((JSONArray)localObject2).add((Object)localJSONObject2);
            localJSONObject1.put(String.valueOf(localInteger), (Object)localJSONObject2);
        }
        return localJSONObject1;
    }

    private void fillChartList(Sheet sheet, XSSFWorkbook xssWorkbook, JSONArray jsonArray) {
        XSSFDrawing xssfDrawing = (XSSFDrawing)sheet.createDrawingPatriarch();
        try {
            for (int i = 0; i < jsonArray.size(); ++i) {
                Row rowBean;
                int rowIndex;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                int col = Integer.valueOf(jsonObject.getString("col"));
                int row = Integer.valueOf(jsonObject.getString("row"));
                String url = (String)jsonObject.get((Object)"url");
                String width = (String)jsonObject.get((Object)"width");
                String height = (String)jsonObject.get((Object)"height");
                byte[] urlByte = Base64.decode((CharSequence)url);
                int heightIndex = 0;
                float heightInPoints = Float.parseFloat(height);
                for (rowIndex = row; rowIndex < row + 99 && (rowBean = sheet.getRow(i)) != null; ++rowIndex) {
                    ++heightIndex;
                    heightInPoints -= rowBean.getHeightInPoints();
                }
                rowIndex = Integer.parseInt(String.format("%.0f", Float.valueOf(Float.parseFloat(width) / 100.0f)));
                XSSFClientAnchor xssfClientAnchor = new XSSFClientAnchor(0, 0, Integer.parseInt(width), Integer.parseInt(height), col, row, col + rowIndex, row + (heightIndex += Integer.parseInt(String.format("%.0f", Float.valueOf(heightInPoints / 25.0f)))));
                xssfDrawing.createPicture(xssfClientAnchor, xssWorkbook.addPicture(urlByte, 5)).resize(1.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillImgList(Sheet sheet, XSSFWorkbook xssWorkbook, JSONArray jsonArray, Map<String, String> paramMap) {
        XSSFDrawing xssfDrawing = (XSSFDrawing)sheet.createDrawingPatriarch();
        HttpURLConnection httpUrlConnection = null;
        try {
            for (int i = 0; i < jsonArray.size(); ++i) {
                byte[] bytes;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                int colInt = Integer.valueOf(jsonObject.getString("col"));
                int rowInt = Integer.valueOf(jsonObject.getString("row"));
                String src = (String)jsonObject.get((Object)"src");
                String width = (String)jsonObject.get((Object)"width");
                String height = (String)jsonObject.get((Object)"height");
                if (height.contains("px") && width.contains("px")) {
                    height = height.substring(0, height.lastIndexOf("px"));
                    width = width.substring(0, width.lastIndexOf("px"));
                }
                URL url = new URL(src);
                if (src.contains("https")) {
                    bytes = HttpUtils.string2Byte(src);
                } else {
                    httpUrlConnection = (HttpURLConnection)url.openConnection();
                    httpUrlConnection.setRequestMethod("GET");
                    httpUrlConnection.setConnectTimeout(50000);
                    InputStream inputStream = httpUrlConnection.getInputStream();
                    bytes = ReportServiceImpl.parseInputStream(inputStream);
                }
                String resultStr = paramMap.get(rowInt + "," + colInt);
                int cellInt = StringUtils.isNotEmpty((CharSequence)resultStr) ? Integer.parseInt(resultStr) : rowInt + Integer.parseInt(String.format("%.0f", Float.valueOf(Float.parseFloat(height) / 25.0f)));
                Integer sheetInt = this.sheetCalcute(sheet, rowInt, Integer.parseInt(height));
                cellInt = sheetInt > 0 ? sheetInt : (cellInt += rowInt);
                int widthInt = Integer.parseInt(String.format("%.0f", Float.valueOf(Float.parseFloat(width) / 100.0f)));
                Object isBackEndImg = jsonObject.get((Object)"isBackendImg");
                if (null != isBackEndImg && ((Boolean)isBackEndImg).booleanValue()) {
                    int imgNum = xssWorkbook.addPicture(bytes, 6);
                    POIXMLDocumentPart docPart = (POIXMLDocumentPart)xssWorkbook.getAllPictures().get(imgNum);
                    try {
                        for (int k = 0; k < xssWorkbook.getNumberOfSheets(); ++k) {
                            XSSFSheet xssfSheet = xssWorkbook.getSheetAt(k);
                            PackagePartName partName = docPart.getPackagePart().getPartName();
                            String relationStr = XSSFRelation.IMAGES.getRelation();
                            PackageRelationship arg26 = xssfSheet.getPackagePart().addRelationship(partName, TargetMode.EXTERNAL, relationStr, (String)null);
                            xssfSheet.getCTWorksheet().addNewPicture().setId(arg26.getId());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        XSSFClientAnchor clientAnchor = new XSSFClientAnchor(0, 0, Integer.parseInt(width), Integer.parseInt(height), colInt, rowInt, colInt + widthInt, cellInt);
                        xssfDrawing.createPicture(clientAnchor, xssWorkbook.addPicture(bytes, 5));
                        continue;
                    }
                }
                XSSFClientAnchor clientAnchor = new XSSFClientAnchor(0, 0, Integer.parseInt(width), Integer.parseInt(height), colInt, rowInt, colInt + widthInt, cellInt);
                xssfDrawing.createPicture(clientAnchor, xssWorkbook.addPicture(bytes, 5));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static byte[] parseInputStream(InputStream paramInputStream) throws Exception {
        ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
        byte[] arrayOfByte = new byte[1024];
        int i = 0;
        while ((i = paramInputStream.read(arrayOfByte)) != -1) {
            localByteArrayOutputStream.write(arrayOfByte, 0, i);
        }
        paramInputStream.close();
        return localByteArrayOutputStream.toByteArray();
    }

    public Integer sheetCalcute(Sheet paramSheet, Integer paramInteger, float paramFloat) {
        int i = 0;
        Double localDouble = 0.0;
        for (Row localRow : paramSheet) {
            if (paramInteger <= i) {
                localDouble = localDouble + (double)localRow.getHeightInPoints();
            }
            if (localDouble != 0.0 && (double)paramFloat - localDouble <= 10.0 && i > 0) {
                return i;
            }
            if (localDouble >= (double)paramFloat && i > 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Integer sheetCalcute2(Sheet paramSheet, Integer paramInteger1, Integer paramInteger2, float paramFloat) {
        float f1 = 0.0f;
        Row localRow = paramSheet.getRow(paramInteger1.intValue());
        for (Cell localCell : localRow) {
            if (localCell.getColumnIndex() < paramInteger2) continue;
            float f2 = paramSheet.getColumnWidthInPixels(localCell.getColumnIndex());
            if ((f1 += f2) >= paramFloat) {
                return localCell.getColumnIndex();
            }
            float f3 = paramFloat - f1;
            if (!(f3 < 30.0f)) continue;
            return localCell.getColumnIndex();
        }
        return 0;
    }
}

