/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.datav.util;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelUtil {
    public static boolean isHave(String[] strs, String s) {
        for (int arg1 = 0; arg1 < strs.length; ++arg1) {
            if (!StringUtils.isNotEmpty((String)s) || !s.contains(strs[arg1])) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> isExistence(List<String> list, String[] text, String[] symbols, Integer n) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            int arg11;
            String[] arg8;
            String arg4 = list.get(n);
            String arg5 = ExcelUtil.ifHaveEnglish(text, arg4);
            String arg6 = ExcelUtil.ifHaveSysbom(symbols, arg4);
            if (StringUtils.isEmpty((String)arg6)) {
                return null;
            }
            if (!arg4.contains(arg5)) {
                return null;
            }
            String arg7 = arg4.replace(arg5, "");
            String[] arg9 = arg8 = arg6.split("__");
            int arg10 = arg8.length;
            for (arg11 = 0; arg11 < arg10; ++arg11) {
                String arg12 = arg9[arg11];
                arg7 = arg7.replace(arg12, "");
            }
            String arg14 = arg7.replaceAll("[^A-Z]", "");
            String arg15 = "";
            for (arg11 = 0; arg11 < arg14.length(); ++arg11) {
                arg15 = arg15 + arg14.charAt(arg11) + ",";
            }
            resultMap.put("newFirstWord", arg15.substring(0, arg15.lastIndexOf(",")));
            resultMap.put("english", arg5);
            resultMap.put("sysbom", arg6);
            return resultMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String ifHaveSysbom(String[] strs, String str) {
        String content = "";
        for (int i = 0; i < strs.length; ++i) {
            if (!str.contains(strs[i])) continue;
            content = content + strs[i] + "__";
        }
        if (StringUtils.isNotEmpty((String)content)) {
            content = content.substring(0, content.lastIndexOf("__"));
        }
        return content;
    }

    public static String ifHaveEnglish(String[] strs, String str) {
        for (int i = 0; i < strs.length; ++i) {
            if (!str.contains(strs[i].split("=")[1])) continue;
            return strs[i].split("=")[1];
        }
        return "";
    }

    public static String getCellValueByCell(Cell cell) {
        if (cell != null && !cell.toString().trim().equals("")) {
            String str = "";
            switch (cell.getCellType()) {
                case 1: {
                    str = cell.getStringCellValue();
                    break;
                }
                case 2: {
                    str = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    str = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 4: {
                    str = String.valueOf(cell.getCellFormula());
                    break;
                }
                default: {
                    str = "";
                }
            }
            return str;
        }
        return "";
    }

    public static String isHaveText(String[] strs, String str) {
        for (int i = 0; i < strs.length; ++i) {
            if (!StringUtils.isNotEmpty((String)str) || !str.contains(strs[i])) continue;
            return strs[i];
        }
        return "";
    }

    public static SimpleDateFormat getFormat(String dataText) {
        SimpleDateFormat localObject = null;
        SimpleDateFormat localSimpleDateFormat1 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat localSimpleDateFormat2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        SimpleDateFormat localSimpleDateFormat3 = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat localSimpleDateFormat4 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        switch (dataText) {
            case "date": {
                localObject = localSimpleDateFormat1;
                break;
            }
            case "date2": {
                localObject = localSimpleDateFormat2;
                break;
            }
            case "time": {
                localObject = localSimpleDateFormat3;
                break;
            }
            case "datetime": {
                localObject = localSimpleDateFormat4;
                break;
            }
            default: {
                localObject = null;
            }
        }
        return localObject;
    }

    public static SimpleDateFormat getDataFormat(String text) {
        SimpleDateFormat simpleDateFormat = null;
        if (text.contains("-") && text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (text.contains("-")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        }
        return simpleDateFormat;
    }
}

