package com.ejianc.business.design.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.design.vo.DesignCheckDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 设计检查
 *
 * @author generator
 *
 */
public class DesignCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String code; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 项目名称
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private String name; // 检查名称
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date checkDate; // 检查日期
    private Long supplierId; // 受检单位
    private String supplierName; // 受检单位
    private Long checkId; // 检查人
    private String checkPerson; // 检查人
    private String reviewId; // 复查人
    private String reviewPerson; // 复查人
    private String reformDutyId; // 整改责任人
    private String reformDutyPerson; // 整改责任人
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date finishDate; // 整改限期
    private String notifRelevantId; // 抄送人
    private String notifRelevantPerson; // 抄送人
    private String conclusion; // 检查结论
    private Integer billState; // 单据状态（审批必须字段）

    private List<DesignCheckDetailVO> designCheckDetailList = new ArrayList<>(); // 设计检查-明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }


    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCheckId() {
        return checkId;
    }

    @ReferDeserialTransfer
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    public String getCheckPerson() {
        return checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public String getReviewId() {
        return reviewId;
    }

    @ReferDeserialTransfer
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }

    public String getReviewPerson() {
        return reviewPerson;
    }

    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public String getReformDutyId() {
        return reformDutyId;
    }

    @ReferDeserialTransfer
    public void setReformDutyId(String reformDutyId) {
        this.reformDutyId = reformDutyId;
    }

    public String getReformDutyPerson() {
        return reformDutyPerson;
    }

    public void setReformDutyPerson(String reformDutyPerson) {
        this.reformDutyPerson = reformDutyPerson;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    @ReferDeserialTransfer
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }

    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }

    public String getConclusion() {
        return conclusion;
    }

    public void setConclusion(String conclusion) {
        this.conclusion = conclusion;
    }

    public List<DesignCheckDetailVO> getDesignCheckDetailList() {
        return designCheckDetailList;
    }

    public void setDesignCheckDetailList(List<DesignCheckDetailVO> designCheckDetailList) {
        this.designCheckDetailList = designCheckDetailList;
    }
}
