/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.doc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.doc.bean.KbmCategoryEntity;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.bean.KbmRecordEntity;
import com.ejianc.business.doc.enums.KbmBillStateEnum;
import com.ejianc.business.doc.enums.KbmRecordTypeEnum;
import com.ejianc.business.doc.enums.KbmSourceEnum;
import com.ejianc.business.doc.mapper.KbmMapper;
import com.ejianc.business.doc.service.IKbmCategoryService;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmRecordService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.business.doc.vo.KbmBatchVO;
import com.ejianc.business.doc.vo.KbmEsVO;
import com.ejianc.business.doc.vo.KbmVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="kbmService")
public class KbmServiceImpl
extends BaseServiceImpl<KbmMapper, KbmEntity>
implements IKbmService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INDEX_NAME = "ejc_kbm_es";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private IKbmRecordService kbmRecordService;
    @Autowired
    private IKbmCollectDetailService kbmCollectDetailService;
    @Autowired
    private IKbmCategoryService kbmCategoryService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserApi userApi;
    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public KbmVO saveOrUpdate(KbmVO kbmVO) {
        KbmVO newVO;
        KbmEntity entity;
        kbmVO.setCreateUserId(InvocationInfoProxy.getUserid());
        kbmVO.setCreateUserName(this.getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
        if (kbmVO.getCategoryId() != null) {
            KbmCategoryEntity categoryEntity = (KbmCategoryEntity)((Object)this.kbmCategoryService.getById(kbmVO.getCategoryId()));
            kbmVO.setCategoryInnerCode(categoryEntity.getInnerCode());
            kbmVO.setCategoryName(categoryEntity.getCategoryName());
        }
        if (KbmSourceEnum.\u4f01\u4e1a\u6587\u4ef6.getCode().equals(kbmVO.getSource())) {
            entity = (KbmEntity)((Object)BeanMapper.map((Object)kbmVO, KbmEntity.class));
            this.saveOrUpdate((Object)entity, false);
            newVO = this.insertOrUpdateEs(entity.getId());
            entity.setBillState(KbmBillStateEnum.\u5df2\u53d1\u5e03.getCode());
            newVO.setBillState(KbmBillStateEnum.\u5df2\u53d1\u5e03.getCode());
        } else {
            kbmVO.setBillState(KbmBillStateEnum.\u6682\u5b58.getCode());
            entity = (KbmEntity)((Object)BeanMapper.map((Object)kbmVO, KbmEntity.class));
            this.saveOrUpdate((Object)entity, false);
            newVO = this.fullFileData(entity.getId());
        }
        entity.setFileNum(newVO.getFileNum());
        this.saveOrUpdate((Object)entity, false);
        return newVO;
    }

    @Override
    public void delete(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new BusinessException("\u6240\u9009Id\u4e3a\u7a7a");
        }
        this.removeByIds(idList, false);
        this.deleteEs(idList);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(KbmRecordEntity::getKbmId, idList);
        this.kbmRecordService.remove((Wrapper)wrapper, false);
    }

    @Override
    public KbmVO push(Long id) {
        KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(id));
        kbmEntity.setBillState(KbmBillStateEnum.\u5df2\u53d1\u5e03.getCode());
        this.saveOrUpdate((Object)kbmEntity, false);
        return this.insertOrUpdateEs(id);
    }

    @Override
    public KbmVO back(Long id) {
        KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(id));
        KbmVO newVO = this.fullFileData(id);
        kbmEntity.setBillState(KbmBillStateEnum.\u6682\u5b58.getCode());
        kbmEntity.setFileNum(newVO.getFileNum());
        this.saveOrUpdate((Object)kbmEntity, false);
        ArrayList<Long> pkList = new ArrayList<Long>();
        pkList.add(id);
        this.deleteEs(pkList);
        return newVO;
    }

    @Override
    public KbmVO scanDetailCenter(Long id, Integer fromList) {
        KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(id));
        if (kbmEntity == null) {
            throw new BusinessException("\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse<Boolean> response = this.kbmCategoryService.kbmAccess(InvocationInfoProxy.getUserid(), kbmEntity.getCategoryId());
        if (!response.isSuccess() || !((Boolean)response.getData()).booleanValue()) {
            throw new BusinessException("\u65e0\u8be5\u5355\u636e\u8bbf\u95ee\u6743\u9650\uff01");
        }
        if (null != fromList && 1 == fromList) {
            this.addScanNum(kbmEntity);
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(id);
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(this.getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.\u67e5\u770b\u6587\u4ef6.getCode());
            this.kbmRecordService.save((Object)kbmRecordEntity);
        }
        return this.fullCollectState((KbmVO)BeanMapper.map((Object)((Object)kbmEntity), KbmVO.class));
    }

    private KbmVO fullCollectState(KbmVO kbmVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(KbmCollectDetailEntity::getKbmId, (Object)kbmVO.getId());
        queryWrapper.eq(KbmCollectDetailEntity::getCreateUserId, (Object)InvocationInfoProxy.getUserid());
        List collectDetailEntities = this.kbmCollectDetailService.list((Wrapper)queryWrapper);
        kbmVO.setCollectState(Integer.valueOf(CollectionUtils.isEmpty((Collection)collectDetailEntities) ? 0 : 1));
        return kbmVO;
    }

    @Override
    public void scanFile(Long kbmId, String fileId) {
        Long fileIdLong = Long.valueOf(fileId);
        CommonResponse response = this.attachmentApi.queryAttachmentDetail(fileIdLong);
        if (response.isSuccess() && response.getData() != null) {
            AttachmentVO attachmentVO = (AttachmentVO)response.getData();
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setFileId(fileIdLong);
            kbmRecordEntity.setFileName(attachmentVO.getFileName());
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(this.getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.\u6d4f\u89c8\u9644\u4ef6.getCode());
            this.kbmRecordService.save((Object)kbmRecordEntity);
        }
    }

    @Override
    public void batchDownloadFile(KbmBatchVO batchVO) {
        if (null == batchVO.getMainId()) {
            throw new BusinessException("\u77e5\u8bc6\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)batchVO.getIdList())) {
            throw new BusinessException("\u6240\u9009\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long fileId : batchVO.getIdList()) {
            this.downloadFile(batchVO.getMainId(), String.valueOf(fileId));
        }
    }

    @Override
    public void downloadFile(Long kbmId, String fileId) {
        Long fileIdLong = Long.valueOf(fileId);
        CommonResponse response = this.attachmentApi.queryAttachmentDetail(fileIdLong);
        if (response.isSuccess() && response.getData() != null) {
            AttachmentVO attachmentVO = (AttachmentVO)response.getData();
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setFileId(fileIdLong);
            kbmRecordEntity.setFileName(attachmentVO.getFileName());
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(this.getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.\u4e0b\u8f7d.getCode());
            this.kbmRecordService.save((Object)kbmRecordEntity);
        }
    }

    @Override
    public void uploadFile(Long kbmId) {
        if (null != kbmId) {
            KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(kbmId));
            KbmVO newVO = KbmSourceEnum.\u4f01\u4e1a\u6587\u4ef6.getCode().equals(kbmEntity.getSource()) ? this.insertOrUpdateEs(kbmEntity.getId()) : this.fullFileData(kbmEntity.getId());
            kbmEntity.setFileNum(newVO.getFileNum());
            this.saveOrUpdate((Object)kbmEntity, false);
        }
    }

    @Override
    public void deleteFile(Long kbmId) {
        if (null != kbmId) {
            KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(kbmId));
            KbmVO newVO = KbmSourceEnum.\u4f01\u4e1a\u6587\u4ef6.getCode().equals(kbmEntity.getSource()) ? this.insertOrUpdateEs(kbmEntity.getId()) : this.fullFileData(kbmEntity.getId());
            kbmEntity.setFileNum(newVO.getFileNum());
            this.saveOrUpdate((Object)kbmEntity, false);
        }
    }

    @Override
    public void updateColletNum(Long kbmId, boolean isAdd) {
        KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(kbmId));
        BigDecimal collectNum = kbmEntity.getCollectNum();
        if (isAdd) {
            KbmRecordEntity kbmRecordEntity = new KbmRecordEntity();
            kbmRecordEntity.setKbmId(kbmId);
            kbmRecordEntity.setCreateUserId(InvocationInfoProxy.getUserid());
            kbmRecordEntity.setCreateUserName(this.getUserNameById(String.valueOf(InvocationInfoProxy.getUserid())));
            kbmRecordEntity.setType(KbmRecordTypeEnum.\u6536\u85cf.getCode());
            this.kbmRecordService.save((Object)kbmRecordEntity);
            kbmEntity.setCollectNum(null != collectNum ? collectNum.add(BigDecimal.ONE) : BigDecimal.ONE);
        } else {
            kbmEntity.setCollectNum(collectNum.subtract(BigDecimal.ONE));
        }
        this.saveOrUpdate((Object)kbmEntity);
        this.insertOrUpdateEs(kbmEntity.getId());
    }

    @Override
    public KbmEsVO queryListEs(Map<String, String> params) {
        KbmEsVO kbmEsVO = new KbmEsVO();
        IPage<KbmVO> page = new IPage<KbmVO>();
        ArrayList categoryList = new ArrayList();
        Integer pageSize = Integer.valueOf(params.get("pageSize"));
        Integer pageNumber = Integer.valueOf(params.get("pageIndex"));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        Integer queryType = params.get("queryType") != null ? Integer.valueOf(params.get("queryType")) : -1;
        Integer filterType = params.get("filterType") != null ? Integer.valueOf(params.get("filterType")) : -1;
        String searchText = params.get("searchText");
        List<Long> longList = new ArrayList();
        if (2 == queryType) {
            if (params.get("categoryId") != null) {
                String categoryIdStr = params.get("categoryId");
                if (categoryIdStr.contains(",")) {
                    String[] arr;
                    for (String str : arr = categoryIdStr.split(",")) {
                        longList.add(Long.valueOf(str));
                    }
                } else {
                    CommonResponse<List<Long>> response = this.kbmCategoryService.userFindChildrenId(Long.valueOf(categoryIdStr));
                    if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                        longList = (List)response.getData();
                    }
                }
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"categoryId", longList));
            }
        } else {
            CommonResponse<List<Long>> response = this.kbmCategoryService.userAccessQueryList(InvocationInfoProxy.getUserid());
            if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
                longList = (List)response.getData();
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"categoryId", longList));
            }
        }
        if (StringUtils.isNotBlank((String)searchText)) {
            if (0 == filterType) {
                MatchQueryBuilder qb1 = QueryBuilders.matchQuery((String)"title", (Object)searchText);
                MatchQueryBuilder qb2 = QueryBuilders.matchQuery((String)"fileName", (Object)searchText);
                MatchQueryBuilder qb3 = QueryBuilders.matchQuery((String)"createUserName", (Object)searchText);
                MatchQueryBuilder qb4 = QueryBuilders.matchQuery((String)"kbmDescribe", (Object)searchText);
                boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)qb1).should((QueryBuilder)qb2).should((QueryBuilder)qb3).should((QueryBuilder)qb4));
            } else if (1 == filterType) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"title", (Object)searchText));
            } else if (2 == filterType) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"createUserName", (Object)searchText));
            } else if (3 == filterType) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"fileName", (Object)searchText));
            }
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.field("title");
        highlightBuilder.field("fileName");
        highlightBuilder.field("createUserName");
        highlightBuilder.field("kbmDescribe");
        highlightBuilder.requireFieldMatch(Boolean.valueOf(true));
        highlightBuilder.preTags(new String[]{"<span style='color:red'>"});
        highlightBuilder.postTags(new String[]{"</span>"});
        sourceBuilder.highlighter(highlightBuilder);
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.kbmEsPage(searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.kbmEsPage(searchRequest);
            }
            catch (IOException e1) {
                this.logger.error(e1.getMessage());
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        page.setCurrent((long)pageNumber.intValue());
        kbmEsVO.setPage(page);
        this.fullCategoryData(kbmEsVO, longList, queryType);
        return kbmEsVO;
    }

    @Override
    public void batchMoveKbm(KbmBatchVO batchVO) {
        if (null == batchVO.getMainId()) {
            throw new BusinessException("\u6240\u9009\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)batchVO.getIdList())) {
            throw new BusinessException("\u6240\u9009\u77e5\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KbmCategoryEntity categoryEntity = (KbmCategoryEntity)((Object)this.kbmCategoryService.getById(batchVO.getMainId()));
        for (Long kbmId : batchVO.getIdList()) {
            KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(kbmId));
            kbmEntity.setCategoryId(batchVO.getMainId());
            kbmEntity.setCategoryInnerCode(categoryEntity.getInnerCode());
            kbmEntity.setCategoryName(categoryEntity.getCategoryName());
            this.saveOrUpdate((Object)kbmEntity, false);
            this.insertOrUpdateEs(kbmEntity.getId());
        }
    }

    private void fullCategoryData(KbmEsVO kbmEsVO, List<Long> longList, Integer queryType) {
        IPage page = kbmEsVO.getPage();
        List kbmVOList = page.getRecords();
        if (1 == queryType) {
            longList = kbmVOList.stream().map(KbmVO::getCategoryId).collect(Collectors.toList());
        }
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        for (Long pk : longList) {
            if (map.containsKey(pk)) continue;
            map.put(pk, 0);
        }
        for (KbmVO kbmVO : kbmVOList) {
            if (!map.containsKey(kbmVO.getCategoryId())) continue;
            map.put(kbmVO.getCategoryId(), (Integer)map.get(kbmVO.getCategoryId()) + 1);
        }
        CommonResponse<JSONObject> response = this.kbmCategoryService.accessToTreeList(map);
        if (response.isSuccess()) {
            kbmEsVO.setCategoryData((JSONObject)response.getData());
        }
    }

    private IPage<KbmVO> kbmEsPage(SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<KbmVO> list = new ArrayList<KbmVO>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            Map highlightFieldMap = hit.getHighlightFields();
            String sourceAsString = hit.getSourceAsString();
            KbmVO kbmVO = (KbmVO)JSON.parseObject((String)sourceAsString, KbmVO.class);
            kbmVO.setId(Long.valueOf(hit.getId()));
            if (highlightFieldMap != null) {
                for (String key : highlightFieldMap.keySet()) {
                    HighlightField highlightField = (HighlightField)highlightFieldMap.get(key);
                    String newTitle = "";
                    if (highlightFieldMap.get(key) != null) {
                        Text[] fragments;
                        for (Text text : fragments = highlightField.fragments()) {
                            newTitle = newTitle + text;
                        }
                    }
                    try {
                        PropertyDescriptor pd = new PropertyDescriptor(key, kbmVO.getClass());
                        Method setMethod = pd.getWriteMethod();
                        setMethod.invoke((Object)kbmVO, newTitle);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage());
                    }
                }
            }
            list.add(kbmVO);
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }

    private void addScanNum(KbmEntity kbmEntity) {
        BigDecimal scanNum = kbmEntity.getScanNum();
        kbmEntity.setScanNum(null != scanNum ? scanNum.add(BigDecimal.ONE) : BigDecimal.ONE);
        this.saveOrUpdate((Object)kbmEntity, false);
        this.insertOrUpdateEs(kbmEntity.getId());
    }

    private String getUserNameById(String userId) {
        String[] arr = new String[]{userId};
        CommonResponse response = this.userApi.queryListByIds(arr);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            return ((UserVO)((List)response.getData()).get(0)).getUserName();
        }
        return null;
    }

    private KbmVO fullFileData(Long id) {
        KbmEntity kbmEntity = (KbmEntity)((Object)this.selectById(id));
        KbmVO kbmVO = (KbmVO)BeanMapper.map((Object)((Object)kbmEntity), KbmVO.class);
        CommonResponse response = this.attachmentApi.queryListBySourceId(id, null, null, null);
        if (response.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            List attachmentVOList = (List)response.getData();
            List nameList = attachmentVOList.stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
            kbmVO.setFileNum(new BigDecimal(attachmentVOList.size()));
            kbmVO.setFileName(StringUtils.join(nameList, (String)"@"));
        }
        return kbmVO;
    }

    private KbmVO insertOrUpdateEs(Long id) {
        KbmVO kbmVO = this.fullFileData(id);
        BulkRequest bulkRequest = new BulkRequest();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("tenantId", InvocationInfoProxy.getTenantid());
        dataMap.put("categoryId", kbmVO.getCategoryId());
        dataMap.put("categoryInnerCode", kbmVO.getCategoryInnerCode());
        dataMap.put("title", kbmVO.getTitle());
        dataMap.put("createUserName", kbmVO.getCreateUserName());
        dataMap.put("categoryName", kbmVO.getCategoryName());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dataMap.put("createTime", format.format(kbmVO.getCreateTime()));
        dataMap.put("kbmDescribe", kbmVO.getKbmDescribe());
        dataMap.put("fileName", kbmVO.getFileName());
        dataMap.put("scanNum", kbmVO.getScanNum());
        dataMap.put("collectNum", kbmVO.getCollectNum());
        dataMap.put("fileNum", kbmVO.getFileNum());
        IndexRequest indexRequest = new IndexRequest(INDEX_NAME);
        indexRequest.id(String.valueOf(kbmVO.getId()));
        indexRequest.source(dataMap, XContentType.JSON);
        bulkRequest.add(indexRequest);
        try {
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        return kbmVO;
    }

    private void deleteEs(List<Long> idList) {
        DeleteRequest deleteRequest = new DeleteRequest(INDEX_NAME);
        for (Long id : idList) {
            deleteRequest.id(String.valueOf(id));
            try {
                this.client.delete(deleteRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
    }
}

