package com.ejianc.business.doc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.doc.bean.KbmCollectDetailEntity;
import com.ejianc.business.doc.bean.KbmCollectEntity;
import com.ejianc.business.doc.bean.KbmEntity;
import com.ejianc.business.doc.mapper.KbmCollectDetailMapper;
import com.ejianc.business.doc.service.IKbmCollectDetailService;
import com.ejianc.business.doc.service.IKbmCollectService;
import com.ejianc.business.doc.service.IKbmService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 知识库收藏明细
 *
 * @author generator
 *
 */
@Service("kbmCollectDetailService")
public class KbmCollectDetailServiceImpl extends BaseServiceImpl<KbmCollectDetailMapper, KbmCollectDetailEntity> implements IKbmCollectDetailService{

    @Autowired
    private IKbmCollectService kbmCollectService;

    @Autowired
    private IKbmService kbmService;

    @Override
    public void collectKbm(Long collectId, Long kbmId) {
        //更新收藏主表最后收藏时间
        KbmCollectEntity collectEntity = kbmCollectService.selectById(collectId);
        collectEntity.setLastTime(new Date());
        kbmCollectService.saveOrUpdate(collectEntity, false);
        //更新知识的收藏量+1,并生成记录表数据
        kbmService.updateColletNum(kbmId, true);

        KbmEntity kbmEntity = kbmService.selectById(kbmId);
        KbmCollectDetailEntity detailEntity = new KbmCollectDetailEntity();
        copyVO(detailEntity, kbmEntity);
        detailEntity.setCollectId(collectId);
        detailEntity.setCreateUserId(InvocationInfoProxy.getUserid());
        save(detailEntity);
    }

    @Override
    public void cancelCollectKbm(Long kbmId) {
        LambdaUpdateWrapper<KbmCollectDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(KbmCollectDetailEntity::getKbmId, kbmId);
        updateWrapper.eq(KbmCollectDetailEntity::getCreateUserId, InvocationInfoProxy.getUserid());
        remove(updateWrapper);

        //更新知识的收藏量-1
        kbmService.updateColletNum(kbmId, false);
    }

    private void copyVO(KbmCollectDetailEntity detailEntity, KbmEntity kbmEntity){
        detailEntity.setKbmId(kbmEntity.getId());
        detailEntity.setOrgId(kbmEntity.getOrgId());
        detailEntity.setOrgName(kbmEntity.getOrgName());
        detailEntity.setCategoryId(kbmEntity.getCategoryId());
        detailEntity.setCategoryName(kbmEntity.getCategoryName());
        detailEntity.setTitle(kbmEntity.getTitle());
        detailEntity.setKbmDescribe(kbmEntity.getKbmDescribe());
        detailEntity.setSourceType(kbmEntity.getSourceType());
        detailEntity.setScanNum(kbmEntity.getScanNum());
        detailEntity.setCollectNum(kbmEntity.getCollectNum());
        detailEntity.setFileNum(kbmEntity.getFileNum());
    }
}
