package com.ejianc.business.dxcheck.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核指标
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class NormAddVo extends BaseVO {
    /**
     * 一级分类
     */
    @NotEmpty(message = "一级分类不能为空")
    private String firstClassify;

    /**
     * 二级分类
     */
    @NotEmpty(message = "二级分类不能为空")
    private String secondClassify;

    /**
     * 指标内容
     */
    @NotEmpty(message = "指标内容不能为空")
    private String normContent;

    /**
     * 加分上限
     */
    private String plusLimit;

    /**
     * 扣分上限
     */
    private String reduceLimit;

    /**
     * 本部部门（使用选√，不适用—，也可选择单位）
     */
    private String headquarterDepartment;

    /**
     * 分子公司（使用选√，不适用—，也可选择单位）
     */
    private String subsidiaryCompany;

    /**
     * 直管项目（使用选√，不适用—，也可选择单位）
     */
    private String straightProject;

    /**
     * 状态
     */
    @Builder.Default
    private Boolean state = Boolean.TRUE;
}
