package com.ejianc.business.dxcheck.service;


import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;

import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:36
 * @Description: 考核排名
 */
public interface RankServer {
    /**
     * 考核排名统计
     *
     * @return AssessmentRankRes
     */
    AssessmentRankRes assessmentRank();

    /**
     * 考核记录统计
     *
     * @param departmentCode 部门代码
     * @return 汇总数据
     */
    Map<Long, List<RecordSubEntity>> record(String departmentCode);

}
