/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServerImpl
implements StatisticsServer {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServerImpl.class);
    private final RecordSubDao recordSubDao;
    private static final DateTime QUARTER_START_TIME = DateUtil.beginOfQuarter((Date)new Date());
    private static final DateTime QUARTER_END_TIME = DateUtil.endOfQuarter((Date)new Date());
    private static final DateTime YEAR_START_TIME = DateUtil.beginOfYear((Date)new Date());
    private static final DateTime YEAR_END_TIME = DateUtil.endOfYear((Date)new Date());

    @Override
    public AssessmentRankRes assessmentRank() {
        List nowQuarterList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).isNotNull(RecordSubEntity::getFinalScore)).between(BaseEntity::getCreateTime, (Object)QUARTER_START_TIME, (Object)QUARTER_END_TIME)).list();
        List nowYearList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).isNotNull(RecordSubEntity::getFinalScore)).between(BaseEntity::getCreateTime, (Object)YEAR_START_TIME, (Object)YEAR_END_TIME)).list();
        List<RecordSubEntity> bbYearList = nowYearList.stream().filter(e -> e.getOrgType() == 4).collect(Collectors.toList());
        List<RecordSubEntity> bbQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 4).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> bbInfoList = this.disposeScores(bbQuarterList, bbYearList);
        List<RecordSubEntity> fzgsYearList = nowYearList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<RecordSubEntity> fzgsQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> fzgsInfoList = this.disposeScores(fzgsQuarterList, fzgsYearList);
        List<RecordSubEntity> xmYearList = nowYearList.stream().filter(e -> e.getOrgType() == 3 || e.getOrgType() == 5).collect(Collectors.toList());
        List<RecordSubEntity> xmQuarterList = nowQuarterList.stream().filter(e -> e.getOrgType() == 3 || e.getOrgType() == 5).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> xmInfoList = this.disposeScores(xmQuarterList, xmYearList);
        return AssessmentRankRes.builder().bb(bbInfoList).fzgs(fzgsInfoList).xm(xmInfoList).build();
    }

    @Override
    public RecordStatisticsRes record(String departmentCode) {
        List recordSubEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getAssessmentDepartmentCode, (Object)departmentCode)).isNotNull(RecordSubEntity::getFinalScore)).list();
        if (recordSubEntityList.isEmpty()) {
            return RecordStatisticsRes.builder().build();
        }
        int quarterScore = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)QUARTER_START_TIME) && e.getCreateTime().before((Date)QUARTER_END_TIME)).collect(Collectors.toList()).stream().mapToInt(RecordSubEntity::getFinalScore).sum();
        int yearScore = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)YEAR_START_TIME) && e.getCreateTime().before((Date)YEAR_END_TIME)).collect(Collectors.toList()).stream().mapToInt(RecordSubEntity::getFinalScore).sum();
        int totalAnnualScore = 100 + yearScore;
        Map<Long, List<RecordSubEntity>> recordSubMap = recordSubEntityList.stream().collect(Collectors.groupingBy(RecordSubEntity::getNormId));
        Integer orgType = ((RecordSubEntity)((Object)recordSubEntityList.get(0))).getOrgType();
        List orgTypeRecordSubList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getOrgType, (Object)orgType)).isNotNull(RecordSubEntity::getFinalScore)).list();
        int plateScoreSum = orgTypeRecordSubList.stream().mapToInt(RecordSubEntity::getFinalScore).sum();
        Map<String, List<RecordSubEntity>> collect = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentDepartmentCode));
        int plateSize = collect.size();
        BigDecimal plateAverageScore = BigDecimal.valueOf(NumberUtil.div((float)plateScoreSum, (float)plateSize));
        int rank = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentDepartmentCode, Collectors.summingInt(RecordSubEntity::getFinalScore))).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(Map.Entry::getKey).collect(Collectors.toList()).indexOf(departmentCode) + 1;
        return RecordStatisticsRes.builder().quarterScore(quarterScore).yearScore(yearScore).totalAnnualScore(totalAnnualScore).plateAverageScore(plateAverageScore).rank(rank).total(plateSize).recordSubMap(recordSubMap).build();
    }

    private List<AssessmentRankRes.AssessmentRankInfo> disposeScores(List<RecordSubEntity> quarterList, List<RecordSubEntity> yearList) {
        List infoList = Lists.newArrayList();
        Map<String, Map<String, List<RecordSubEntity>>> unitDepartmentYearMap = yearList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode, Collectors.groupingBy(RecordSubEntity::getAssessmentDepartmentCode)));
        Map<String, Map<String, List<RecordSubEntity>>> unitDepartmentQuarterMap = quarterList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode, Collectors.groupingBy(RecordSubEntity::getAssessmentDepartmentCode)));
        for (Map.Entry<String, Map<String, List<RecordSubEntity>>> stringMapEntry : unitDepartmentYearMap.entrySet()) {
            String unitCode = stringMapEntry.getKey();
            Map<String, List<RecordSubEntity>> value = stringMapEntry.getValue();
            for (Map.Entry<String, List<RecordSubEntity>> stringListEntry : value.entrySet()) {
                List<RecordSubEntity> recordSubEntityList;
                int totalAnnualScore = 100;
                String departmentCode = stringListEntry.getKey();
                List<RecordSubEntity> recordSubList = stringListEntry.getValue();
                int yearScore = recordSubList.stream().mapToInt(RecordSubEntity::getFinalScore).sum();
                totalAnnualScore += yearScore;
                int quarterScore = 0;
                Map<String, List<RecordSubEntity>> stringListMap = unitDepartmentQuarterMap.get(unitCode);
                if (Objects.nonNull(stringListMap) && (recordSubEntityList = stringListMap.get(departmentCode)) != null) {
                    quarterScore = recordSubEntityList.stream().mapToInt(RecordSubEntity::getFinalScore).reduce(Integer::sum).orElse(0);
                }
                AssessmentRankRes.AssessmentRankInfo infoRes = AssessmentRankRes.AssessmentRankInfo.builder().unitCode(unitCode).unitName(recordSubList.get(0).getAssessmentUnitName()).departmentCode(departmentCode).departmentName(recordSubList.get(0).getAssessmentDepartmentName()).quarterScore(quarterScore).yearScore(yearScore).totalAnnualScore(totalAnnualScore).build();
                infoList.add(infoRes);
            }
        }
        infoList.sort(Comparator.comparing(AssessmentRankRes.AssessmentRankInfo::getTotalAnnualScore).reversed());
        return infoList;
    }

    public StatisticsServerImpl(RecordSubDao recordSubDao) {
        this.recordSubDao = recordSubDao;
    }
}

