package com.ejianc.business.dxcheck.model.res;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/4 下午4:33
 * @Description: 考核记录排名
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AssessmentRankRes {
    private List<AssessmentRankInfo> bb;
    private List<AssessmentRankInfo> fzgs;
    private List<AssessmentRankInfo> xm;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class AssessmentRankInfo {
        private String unitCode;
        private String unitName;
        private String departmentCode;
        private String departmentName;
        private Integer quarterScore;
        private Integer yearScore;
        private Integer totalAnnualScore;
    }
}
