/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.NormDao;
import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.model.vo.NormAddVo;
import com.ejianc.business.dxcheck.model.vo.NormEditVo;
import com.ejianc.business.dxcheck.service.NormServer;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;

@Service
public class NormServerImpl
implements NormServer {
    private static final Logger log = LoggerFactory.getLogger(NormServerImpl.class);
    private final NormDao dao;
    private final JedisPool jedisPool;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<NormEntity> add(NormAddVo vo) {
        boolean locked = false;
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        String key = vo.getCreateUserCode() + "NormAdd";
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)RandomUtil.randomNumbers((int)10), (int)1000);
            if (!locked) {
                log.error("\u6307\u6807\u65b0\u589e\u5931\u8d25\uff0c\u91cd\u590d\u6dfb\u52a0\uff0c\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "\u6307\u6807\u65b0\u589e");
                CommonResponse commonResponse = CommonResponse.error((String)"\u6307\u6807\u65b0\u589e\u5931\u8d25\uff0c\u91cd\u590d\u6dfb\u52a0!");
                return commonResponse;
            }
            String firstClassify = vo.getFirstClassify();
            String secondClassify = vo.getSecondClassify();
            NormEntity normEntity = NormEntity.builder().build();
            BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)normEntity));
            String serialNum = this.dealSerialNum(firstClassify, secondClassify);
            normEntity.setSerialNum(serialNum);
            normEntity.setNormVersion("V1");
            this.dao.save((Object)normEntity);
            CommonResponse commonResponse = CommonResponse.success((String)"\u6307\u6807\u65b0\u589e\u6210\u529f", (Object)((Object)normEntity));
            return commonResponse;
        }
        catch (BeansException e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        finally {
            this.releaseLock(jedis, locked, key, "\u6307\u6807\u65b0\u589e");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids);
        }
        catch (BeansException e) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public NormEntity detail(Long id) {
        NormEntity one = (NormEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(BaseEntity::getId, (Object)id)).one());
        if (Objects.isNull((Object)one)) {
            throw new BusinessException("\u67e5\u8be2\u5931\u8d25,\u6570\u636e\u4e0d\u5b58\u5728");
        }
        return one;
    }

    @Override
    public Map<String, Map<String, List<NormEntity>>> list() {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().orderByAsc(NormEntity::getSerialNum)).list();
        return list.stream().collect(Collectors.groupingBy(e -> e.getSerialNum().split("\\.")[0], Collectors.groupingBy(e -> e.getSerialNum().split("\\.")[1])));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public NormEntity edit(NormEditVo vo) {
        Long oldNormId = vo.getId();
        try {
            NormEntity byId = (NormEntity)((Object)this.dao.getById(oldNormId));
            if (byId == null) {
                throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
            }
            NormEntity saveEntity = NormEntity.builder().build();
            BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)saveEntity));
            saveEntity.setId(null);
            saveEntity.setCreateTime((java.util.Date)new DateTime());
            int newNormVersion = ReUtil.getFirstNumber((CharSequence)byId.getNormVersion()) + 1;
            saveEntity.setNormVersion("V" + newNormVersion);
            saveEntity.setNormContent(vo.getNormContent());
            saveEntity.setPlusLimit(vo.getPlusLimit());
            saveEntity.setReduceLimit(vo.getReduceLimit());
            saveEntity.setHeadquarterDepartment(vo.getHeadquarterDepartment());
            saveEntity.setSubsidiaryCompany(vo.getSubsidiaryCompany());
            saveEntity.setStraightProject(vo.getStraightProject());
            saveEntity.setModifierJobNum(vo.getModifierJobNum());
            saveEntity.setModifierName(vo.getModifierName());
            saveEntity.setModifyTime(new Date(System.currentTimeMillis()));
            saveEntity.setOldNorm(oldNormId);
            this.dao.save((Object)saveEntity);
            byId.setModifierJobNum(vo.getModifierJobNum());
            byId.setModifierName(vo.getModifierName());
            byId.setModifyTime(new Date(System.currentTimeMillis()));
            this.dao.updateById((Object)byId);
            this.dao.removeById(byId.getId());
            return saveEntity;
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> move(Long id, String move) {
        List updateEntityList = Lists.newArrayList();
        NormEntity moveEntity = (NormEntity)((Object)this.dao.getById(id));
        if (Objects.isNull((Object)moveEntity)) {
            throw new BusinessException("\u79fb\u52a8\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String serialNum = moveEntity.getSerialNum();
        try {
            if ("up".equals(move)) {
                String thirdNumber = StrUtil.subAfter((CharSequence)serialNum, (CharSequence)".", (boolean)true);
                if ("1".equals(thirdNumber)) {
                    throw new BusinessException("\u4e0a\u79fb\u5931\u8d25\uff0c\u5e8f\u53f7\u4f4d\u4e8e\u7b2c\u4e00\u4f4d");
                }
                String[] parts = serialNum.split("\\.");
                int superThirdNumber = Integer.parseInt(parts[parts.length - 1]) - 1;
                String superVersion = parts[0] + "." + parts[1] + "." + superThirdNumber;
                NormEntity superEntity = (NormEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(NormEntity::getSerialNum, (Object)superVersion)).one());
                superEntity.setSerialNum(moveEntity.getSerialNum());
                moveEntity.setSerialNum(superVersion);
                updateEntityList.add(superEntity);
                updateEntityList.add(moveEntity);
                this.dao.updateBatchById(updateEntityList);
                return CommonResponse.success((String)"\u4e0a\u79fb\u6210\u529f");
            }
            if ("down".equals(move)) {
                String[] parts = serialNum.split("\\.");
                int lowerThirdNumber = Integer.parseInt(parts[parts.length - 1]) + 1;
                String lowerVersion = parts[0] + "." + parts[1] + "." + lowerThirdNumber;
                NormEntity lowerEntity = (NormEntity)((Object)((LambdaQueryChainWrapper)this.dao.lambdaQuery().eq(NormEntity::getSerialNum, (Object)lowerVersion)).one());
                if (Objects.isNull((Object)lowerEntity)) {
                    throw new BusinessException("\u4e0b\u79fb\u5931\u8d25\uff0c\u5e8f\u53f7\u4f4d\u65e0\u6cd5\u4e0b\u79fb");
                }
                moveEntity.setSerialNum(lowerEntity.getSerialNum());
                lowerEntity.setSerialNum(serialNum);
                updateEntityList.add(lowerEntity);
                updateEntityList.add(moveEntity);
                this.dao.updateBatchById(updateEntityList);
                return CommonResponse.success((String)"\u4e0b\u79fb\u6210\u529f");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return CommonResponse.error((String)"\u64cd\u4f5c\u4e0d\u5b58\u5728");
    }

    private String dealSerialNum(String firstClassify, String secondClassify) {
        String thirdSerialNum;
        String secondSerialNum;
        String firstSerialNum;
        List list = this.dao.list();
        Map<String, Map<String, List<NormEntity>>> firstAndSecondMap = list.stream().collect(Collectors.groupingBy(NormEntity::getFirstClassify, Collectors.groupingBy(NormEntity::getSecondClassify)));
        if (firstAndSecondMap.containsKey(firstClassify)) {
            firstSerialNum = firstAndSecondMap.get(firstClassify).values().stream().findFirst().get().get(0).getSerialNum().split("\\.")[0];
            Map<String, List<NormEntity>> secondMap = firstAndSecondMap.get(firstClassify);
            if (secondMap.containsKey(secondClassify)) {
                secondSerialNum = secondMap.get(secondClassify).get(0).getSerialNum().split("\\.")[1];
                List<NormEntity> firstSecondList = this.dao.getFirstSecondListOrderBySerialNum(firstClassify, secondClassify);
                String lastSerialNum = firstSecondList.get(firstSecondList.size() - 1).getSerialNum();
                thirdSerialNum = String.valueOf(NumberUtil.parseInt((String)StrUtil.subAfter((CharSequence)lastSerialNum, (CharSequence)".", (boolean)true)) + 1);
            } else {
                secondSerialNum = String.valueOf(secondMap.size() + 1);
                thirdSerialNum = "1";
            }
        } else {
            List<NormEntity> firstSecondListOrder = this.dao.getFirstSecondListOrder();
            String maxFirstSerialNum = firstSecondListOrder.get(firstSecondListOrder.size() - 1).getSerialNum().split("\\.")[0];
            firstSerialNum = String.valueOf(Integer.parseInt(maxFirstSerialNum) + 1);
            secondSerialNum = "1";
            thirdSerialNum = "1";
        }
        return StrUtil.join((CharSequence)".", (Object[])new Object[]{firstSerialNum, secondSerialNum, thirdSerialNum});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)operate);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public NormServerImpl(NormDao dao, JedisPool jedisPool) {
        this.dao = dao;
        this.jedisPool = jedisPool;
    }
}

