/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.dxcheck.dao.TeamDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.mapper.TeamMapper;
import com.ejianc.business.dxcheck.model.vo.TeamUserVO;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="teamService")
public class TeamServiceImpl
extends BaseServiceImpl<TeamMapper, TeamEntity>
implements TeamService {
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private TeamUserDao teamUserDao;
    @Autowired
    private TeamUserService teamUserService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public TeamVO searchDetail(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (id != null) {
            wrapper.eq(BaseEntity::getId, (Object)id);
        }
        TeamEntity teamEntity = (TeamEntity)((Object)this.teamDao.getOne((Wrapper)wrapper));
        TeamVO vo = (TeamVO)((Object)BeanMapper.map((Object)((Object)teamEntity), TeamVO.class));
        LambdaQueryWrapper wrapperTeamUser = new LambdaQueryWrapper();
        if (vo.getId() != null) {
            wrapperTeamUser.eq(TeamUserEntity::getTeamId, (Object)vo.getId());
        }
        List list = this.teamUserDao.list((Wrapper)wrapperTeamUser);
        List listVo = BeanMapper.mapList((Iterable)list, TeamUserVO.class);
        vo.setTeamUserList(listVo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TeamVO saveOrUpdateTeamUser(TeamVO saveOrUpdateVO) {
        TeamEntity entity = (TeamEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), TeamEntity.class));
        this.saveOrUpdate((Object)entity, false);
        TeamVO vo = (TeamVO)((Object)BeanMapper.map((Object)((Object)entity), TeamVO.class));
        if (saveOrUpdateVO.getTeamUserList() != null) {
            ArrayList<TeamUserVO> teamUserVOS = new ArrayList<TeamUserVO>();
            Map teamUserEntityMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.teamUserService.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).eq(TeamUserEntity::getTeamId, (Object)vo.getId())).list().stream().collect(Collectors.toMap(TeamUserEntity::getTeamUserId, Function.identity()));
            for (TeamUserVO teamUserVO : saveOrUpdateVO.getTeamUserList()) {
                if (teamUserEntityMap.containsKey(teamUserVO.getTeamUserId())) continue;
                teamUserVO.setTeamId(vo.getId());
                TeamUserEntity teamUserEntity = (TeamUserEntity)((Object)BeanMapper.map((Object)((Object)teamUserVO), TeamUserEntity.class));
                this.teamUserService.saveOrUpdate((Object)teamUserEntity, false);
                TeamUserVO map = (TeamUserVO)((Object)BeanMapper.map((Object)((Object)teamUserEntity), TeamUserVO.class));
                teamUserVOS.add(map);
            }
            vo.setTeamUserList(teamUserVOS);
        }
        return vo;
    }

    @Override
    public IPage<TeamVO> setTeamUserList(IPage<TeamVO> pageData) {
        pageData.getRecords().forEach(teamVO -> {
            System.out.println("\u5f00\u59cb\u904d\u5386");
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(TeamUserEntity::getTeamId, (Object)teamVO.getId());
            List list = this.teamUserDao.list((Wrapper)wrapper);
            List listVo = BeanMapper.mapList((Iterable)list, TeamUserVO.class);
            System.out.println("\u5217\u8868\u957f\u5ea6" + listVo.size());
            if (!listVo.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < listVo.size(); ++i) {
                    sb.append(((TeamUserVO)((Object)((Object)listVo.get(i)))).getTeamUserId());
                    if (i >= listVo.size() - 1) continue;
                    sb.append(",");
                }
                teamVO.setTeamUsersId(sb.toString());
            }
        });
        return pageData;
    }

    @Override
    public CommonResponse<List<TeamVO>> getAssessmentTeam() {
        Long userId = this.sessionManager.getUserContext().getUserId();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.teamUserService.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).eq(TeamUserEntity::getTeamUserId, (Object)userId)).list();
        if (CollUtil.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u5f53\u524d\u767b\u5f55\u4eba\u6240\u5728\u7684\u8003\u8bc4\u7ec4\u5217\u8868", (Object)Lists.newArrayList());
        }
        Set teamIds = list.stream().map(TeamUserEntity::getTeamId).collect(Collectors.toSet());
        List list1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).in(BaseEntity::getId, teamIds)).eq(TeamEntity::getTeamType, (Object)1)).list();
        if (CollUtil.isEmpty((Collection)list1)) {
            return CommonResponse.success((String)"\u5f53\u524d\u767b\u5f55\u4eba\u6240\u5728\u7684\u8003\u8bc4\u7ec4\u5217\u8868", (Object)Lists.newArrayList());
        }
        return CommonResponse.success((String)"\u5f53\u524d\u767b\u5f55\u4eba\u6240\u5728\u7684\u8003\u8bc4\u7ec4\u5217\u8868", (Object)BeanMapper.mapList((Iterable)list1, TeamVO.class));
    }
}

