package com.ejianc.business.dxcheck.service;

import cn.hutool.json.JSONArray;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:36
 * @Description: 考核排名
 */
public interface StatisticsServer {
    /**
     * 获取排名组织树
     *
     * @return JSONArray
     */
    JSONArray getTree();

    /**
     * 考核排名统计
     *
     * @param year year
     * @return AssessmentRankRes
     */
    AssessmentRankRes assessmentRank(String year);

    /**
     * 考核记录统计
     *
     * @param unitCode 部门代码
     * @param year year
     * @return 汇总数据
     */
    JSONArray record(String unitCode, String year);

    /**
     * 考评工作处理提示
     *
     * @param year year
     * @return JSONArray
     */
    JSONArray tips(String year);

    /**
     * 获取最新记录（加分、减分）
     *
     * @return 数据
     */
    JSONArray getNewRecord(Integer pageNo, Integer pageSize);
}
