package com.ejianc.business.dxcheck.util;

import cn.hutool.core.util.PageUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections4.CollectionUtils;

/**
 * @Author: LCL
 * @Date: 2024/7/26 下午3:06
 * @Description: 分页t拓展工具类
 */
public class PageExtUtil extends PageUtil {

    public static <S, T> PageInfo<T> buildPage(PageInfo<S> source, Class<T> clazz) {
        PageInfo<T> result = (PageInfo<T>)source;
        if (CollectionUtils.isNotEmpty(source.getList())) {
            result.setList(BeanMapper.mapList(source.getList(), clazz));
        }
        return result;
    }

    public static <S, T> Page<T> buildPage(Page<S> source, Class<T> clazz) {
        Page<T> result = (Page<T>)source;
        if (CollectionUtils.isNotEmpty(source.getRecords())) {
            result.setRecords(BeanMapper.mapList(source.getRecords(), clazz));
        }
        return result;
    }

}
