/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.NormDao;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.dao.UserDao;
import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.enums.OrgTypeEnums;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.NormScoreRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;
import com.ejianc.business.dxcheck.model.vo.NormScoreVo;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.business.dxcheck.util.DateExtUtil;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServerImpl
implements StatisticsServer {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServerImpl.class);
    private final RecordDao recordDao;
    private final RecordSubDao recordSubDao;
    private final UserDao userDao;
    private final NormDao normDao;
    private final TeamUserDao teamUserDao;
    private final SessionManager sessionManager;
    @Qualifier(value="com.ejianc.foundation.permission.api.IRoleApi")
    private final IRoleApi iRoleApi;

    @Override
    public JSONArray getTree() {
        List userEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().select(new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitName, UserEntity::getAssessmentUnitCode}).eq(UserEntity::getStatus, (Object)"\u542f\u7528")).groupBy((Object[])new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitCode})).list();
        return this.buildTree(userEntities);
    }

    @Override
    public AssessmentRankRes assessmentRank(String year) {
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        List userEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().select(new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitName, UserEntity::getAssessmentUnitShortName, UserEntity::getAssessmentUnitCode}).eq(UserEntity::getStatus, (Object)"\u542f\u7528")).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).groupBy((Object[])new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitCode})).list();
        List nowYearList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        List<UserEntity> bbList = userEntities.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<RecordSubEntity> bbYearList = nowYearList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> bbInfoList = this.disposeScores(bbList, bbYearList, year);
        List<UserEntity> zgxmList = userEntities.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<RecordSubEntity> zgxmYearList = nowYearList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> zgxmInfoList = this.disposeScores(zgxmList, zgxmYearList, year);
        List<UserEntity> fzgList = userEntities.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<RecordSubEntity> fzgsYearList = nowYearList.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> fzgsInfoList = this.disposeScores(fzgList, fzgsYearList, year);
        return AssessmentRankRes.builder().bb(bbInfoList).zgxm(zgxmInfoList).fzgs(fzgsInfoList).build();
    }

    @Override
    public JSONArray record(String unitCode, String year) {
        JSONArray res = JSONUtil.createArray();
        JSONObject other = JSONUtil.createObj();
        if (StrUtil.isBlank((CharSequence)unitCode) || "null".equals(unitCode)) {
            List<NormEntity> normList = this.normDao.getFirstSecondListOrder();
            Map<String, Map<String, List<NormEntity>>> collect1 = normList.stream().collect(Collectors.groupingBy(NormEntity::getFirstClassify, Collectors.groupingBy(NormEntity::getSecondClassify)));
            List firstSet = normList.stream().map(NormEntity::getFirstClassify).distinct().collect(Collectors.toList());
            JSONArray normArray = JSONUtil.createArray();
            for (String first : firstSet) {
                JSONArray childrenArray = JSONUtil.createArray();
                JSONObject firstNode = JSONUtil.createObj();
                firstNode.put("id", (Object)RandomUtil.randomString((int)7));
                firstNode.put("key", (Object)first);
                firstNode.put("normContent", (Object)first);
                Map<String, List<NormEntity>> stringListMap = collect1.get(first);
                TreeMap sort = MapUtil.sort(stringListMap);
                Set secondSet = sort.keySet();
                for (String second : secondSet) {
                    JSONObject secondNode = JSONUtil.createObj();
                    secondNode.put("id", (Object)RandomUtil.randomString((int)7));
                    secondNode.put("key", (Object)second);
                    secondNode.put("normContent", (Object)second);
                    if (stringListMap.containsKey(second)) {
                        List<NormEntity> secondList = stringListMap.get(second);
                        List normRes = BeanMapper.mapList(secondList, RecordStatisticsRes.NormRes.class);
                        normRes.forEach(e -> e.setRecordSubList(Collections.emptyList()));
                        secondNode.put("children", (Object)normRes);
                    }
                    childrenArray.add((Object)secondNode);
                }
                firstNode.put("children", (Object)childrenArray);
                normArray.put((Object)firstNode);
            }
            res.add((Object)normArray);
            other.put("q1", (Object)0);
            other.put("q2", (Object)0);
            other.put("q3", (Object)0);
            other.put("q4", (Object)0);
            other.put("yearScore", (Object)0);
            other.put("totalAnnualScore", (Object)0);
            other.put("plateAverageScore", (Object)0);
            other.put("rank", (Object)0);
            other.put("total", (Object)0);
            res.add((Object)other);
            return res;
        }
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        UserEntity one = (UserEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().eq(UserEntity::getAssessmentUnitCode, (Object)unitCode)).eq(UserEntity::getYear, (Object)year)).one());
        if (Objects.isNull((Object)one)) {
            List<NormEntity> normList = this.normDao.getFirstSecondListOrder();
            Map<String, Map<String, List<NormEntity>>> collect1 = normList.stream().collect(Collectors.groupingBy(NormEntity::getFirstClassify, Collectors.groupingBy(NormEntity::getSecondClassify)));
            List firstSet = normList.stream().map(NormEntity::getFirstClassify).distinct().collect(Collectors.toList());
            JSONArray normArray = JSONUtil.createArray();
            for (String first : firstSet) {
                JSONArray childrenArray = JSONUtil.createArray();
                JSONObject firstNode = JSONUtil.createObj();
                firstNode.put("id", (Object)RandomUtil.randomString((int)7));
                firstNode.put("key", (Object)first);
                firstNode.put("normContent", (Object)first);
                Map<String, List<NormEntity>> stringListMap = collect1.get(first);
                TreeMap treeMap = MapUtil.sort(stringListMap);
                Set secondSet = treeMap.keySet();
                for (String second : secondSet) {
                    JSONObject secondNode = JSONUtil.createObj();
                    secondNode.put("id", (Object)RandomUtil.randomString((int)7));
                    secondNode.put("key", (Object)second);
                    secondNode.put("normContent", (Object)second);
                    if (stringListMap.containsKey(second)) {
                        List<NormEntity> secondList = stringListMap.get(second);
                        List normRes = BeanMapper.mapList(secondList, RecordStatisticsRes.NormRes.class);
                        normRes.forEach(e -> e.setRecordSubList(Collections.emptyList()));
                        secondNode.put("children", (Object)normRes);
                    }
                    childrenArray.add((Object)secondNode);
                }
                firstNode.put("children", (Object)childrenArray);
                normArray.put((Object)firstNode);
            }
            res.add((Object)normArray);
            other.put("q1", (Object)0);
            other.put("q2", (Object)0);
            other.put("q3", (Object)0);
            other.put("q4", (Object)0);
            other.put("yearScore", (Object)0);
            other.put("totalAnnualScore", (Object)0);
            other.put("plateAverageScore", (Object)0);
            other.put("rank", (Object)0);
            other.put("total", (Object)0);
            res.add((Object)other);
            return res;
        }
        Integer orgType = one.getOrgType();
        List orgTypeRecordSubList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getOrgType, (Object)orgType)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        BigDecimal plateScore = orgTypeRecordSubList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        List orgTypeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().eq(UserEntity::getOrgType, (Object)orgType)).eq(UserEntity::getYear, (Object)year)).orderByAsc(UserEntity::getSerialNum)).list();
        BigDecimal plateSum = plateScore.add(BigDecimal.valueOf((long)orgTypeList.size() * 100L));
        BigDecimal plateAverageScore = plateSum.divide(orgTypeList.isEmpty() ? BigDecimal.ONE : BigDecimal.valueOf(orgTypeList.size()), 2, RoundingMode.HALF_UP);
        LinkedHashMap assessmentMap = new LinkedHashMap();
        orgTypeList.forEach(e -> assessmentMap.put(e.getAssessmentUnitCode(), BigDecimal.valueOf(100L)));
        Map<String, BigDecimal> scoreMap = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode, Collectors.mapping(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (Map.Entry entry : assessmentMap.entrySet()) {
            String unitCodeKey = (String)entry.getKey();
            if (!scoreMap.containsKey(unitCodeKey)) continue;
            BigDecimal score = scoreMap.get(unitCodeKey);
            BigDecimal value = (BigDecimal)entry.getValue();
            BigDecimal add = NumberUtil.add((Number)value, (Number)score);
            entry.setValue(add);
        }
        int rank = 0;
        if (CollUtil.isNotEmpty(assessmentMap)) {
            rank = assessmentMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).collect(Collectors.toList()).indexOf(unitCode) + 1;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getAssessmentUnitCode, (Object)unitCode)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        BigDecimal yearScore = list.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAnnualScore = NumberUtil.add((Number)yearScore, (Number)100);
        DateExtUtil.QuarterStartEndTime quarterStartEndTime = DateExtUtil.getQuarterStartEndTime(year);
        BigDecimal q1 = list.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ1StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ1EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q2 = list.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ2StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ2EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q3 = list.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ3StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ3EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q4 = list.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ4StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ4EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        other.put("q1", (Object)q1);
        other.put("q2", (Object)q2);
        other.put("q3", (Object)q3);
        other.put("q4", (Object)q4);
        other.put("yearScore", (Object)yearScore);
        other.put("totalAnnualScore", (Object)totalAnnualScore);
        other.put("plateAverageScore", (Object)plateAverageScore);
        other.put("rank", (Object)rank);
        other.put("total", (Object)Math.toIntExact(orgTypeList.size()));
        List<NormEntity> normList = this.normDao.getFirstSecondListOrder();
        Map<String, Map<String, List<NormEntity>>> collect1 = normList.stream().collect(Collectors.groupingBy(NormEntity::getFirstClassify, Collectors.groupingBy(NormEntity::getSecondClassify)));
        List firstSet = normList.stream().map(NormEntity::getFirstClassify).distinct().collect(Collectors.toList());
        JSONArray normArray = JSONUtil.createArray();
        Map<Long, List<RecordSubEntity>> normIdAndSubListMap = list.stream().filter(e -> e.getNormId() != null).collect(Collectors.groupingBy(RecordSubEntity::getNormId));
        String userCode = String.valueOf(this.sessionManager.getUserContext().getUserCode());
        for (String first : firstSet) {
            JSONArray childrenArray = JSONUtil.createArray();
            JSONObject firstNode = JSONUtil.createObj();
            firstNode.put("id", (Object)RandomUtil.randomString((int)7));
            firstNode.put("key", (Object)first);
            firstNode.put("normContent", (Object)first);
            Map<String, List<NormEntity>> stringListMap = collect1.get(first);
            TreeMap sort = MapUtil.sort(stringListMap);
            Set secondSet = sort.keySet();
            for (String second : secondSet) {
                JSONObject secondNode = JSONUtil.createObj();
                secondNode.put("id", (Object)RandomUtil.randomString((int)7));
                secondNode.put("key", (Object)second);
                secondNode.put("normContent", (Object)second);
                if (stringListMap.containsKey(second)) {
                    List<NormEntity> secondList = stringListMap.get(second);
                    List normRes = BeanMapper.mapList(secondList, RecordStatisticsRes.NormRes.class);
                    for (RecordStatisticsRes.NormRes normRes1 : normRes) {
                        BigDecimal deductionRate;
                        Long normId = normRes1.getId();
                        List recordSubList = Lists.newArrayList();
                        normRes1.setRecordSubList(recordSubList);
                        if (!normIdAndSubListMap.containsKey(normId)) continue;
                        List<RecordSubEntity> subList = normIdAndSubListMap.get(normId);
                        subList.forEach(e -> {
                            RecordStatisticsRes.RecordSubStatisticsRes recordSubStatisticsRes = new RecordStatisticsRes.RecordSubStatisticsRes();
                            BeanUtils.copyProperties((Object)e, (Object)((Object)recordSubStatisticsRes));
                            recordSubList.add(recordSubStatisticsRes);
                        });
                        BigDecimal deductionYear = subList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                        normRes1.setDeductionYear(deductionYear);
                        BigDecimal reduceLimit = NumberUtil.toBigDecimal((String)((RecordStatisticsRes.RecordSubStatisticsRes)((Object)recordSubList.get(0))).getReduceLimit());
                        BigDecimal plusLimit = NumberUtil.toBigDecimal((String)((RecordStatisticsRes.RecordSubStatisticsRes)((Object)recordSubList.get(0))).getPlusLimit());
                        BigDecimal dividend = NumberUtil.sub((Number)plusLimit, (Number)reduceLimit);
                        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
                            deductionRate = BigDecimal.ZERO;
                            normRes1.setDeductionRate(deductionRate + "%");
                        } else {
                            deductionRate = NumberUtil.div((Number)NumberUtil.sub((Number)deductionYear, (Number)reduceLimit), (Number)dividend).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                            normRes1.setDeductionRate(deductionRate + "%");
                        }
                        recordSubList.forEach(e -> {
                            e.setDeductionYear(deductionYear);
                            e.setDeductionRate(deductionRate + "%");
                            e.setIsH(false);
                            if (StrUtil.isNotEmpty((CharSequence)e.getApproveUserCode())) {
                                List list = Lists.newArrayList((Object[])e.getApproveUserCode().split(","));
                                Integer state = e.getState();
                                if (list.contains(userCode) && state != 6) {
                                    e.setIsH(true);
                                }
                            }
                        });
                        normRes1.setRecordSubList(recordSubList);
                    }
                    secondNode.put("children", (Object)normRes);
                }
                childrenArray.add((Object)secondNode);
            }
            firstNode.put("children", (Object)childrenArray);
            normArray.put((Object)firstNode);
        }
        res.add((Object)normArray);
        res.add((Object)other);
        return res;
    }

    @Override
    public JSONArray tips(String year) {
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        JSONArray jsonArray = JSONUtil.createArray();
        JSONObject node = JSONUtil.createObj();
        String userCode = this.sessionManager.getUserContext().getUserCode();
        Long userId = this.sessionManager.getUserContext().getUserId();
        List agent = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().ne(RecordSubEntity::getState, (Object)6)).like(RecordSubEntity::getApproveUserCode, (Object)userCode)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        Set collect = agent.stream().map(RecordSubEntity::getAssessmentUnitName).collect(Collectors.toSet());
        node.put("agent", (Object)agent.size());
        if (!agent.isEmpty()) {
            int count = collect.size();
            node.put("unit", (Object)count);
        }
        List comingAgent = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordDao.lambdaQuery().like(RecordEntity::getProfessionalGroupMembers, (Object)userId)).ne(RecordEntity::getState, (Object)6)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).or()).like(RecordEntity::getEvaluationGroupMembers, (Object)userId)).ne(RecordEntity::getState, (Object)6)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        node.put("comingAgent", (Object)comingAgent.size());
        List<Long> roleIdList = this.iRoleApi.toString().contains("test.ztpc.com") ? Collections.singletonList(856893004038828089L) : Collections.singletonList(860556490367316055L);
        try {
            CommonResponse roleUser = this.iRoleApi.getRoleUser(roleIdList, null);
            Set teamLeaderIdSet = ((List)roleUser.getData()).stream().map(RoleUserRelationVO::getUserId).collect(Collectors.toSet());
            List<TeamUserEntity> allInfoListByTeamType = this.teamUserDao.getAllInfoListByTeamType(1);
            Set teamUserIdSet = allInfoListByTeamType.stream().map(TeamUserEntity::getTeamUserId).collect(Collectors.toSet());
            if (teamUserIdSet.contains(userId) || teamLeaderIdSet.contains(userId)) {
                node.put("isView", (Object)true);
            } else {
                node.put("isView", (Object)false);
            }
            jsonArray.put((Object)node);
            return jsonArray;
        }
        catch (Exception e) {
            return jsonArray;
        }
    }

    @Override
    public JSONArray getNewRecord(Integer pageNo, Integer pageSize) {
        JSONArray jsonArray = JSONUtil.createArray();
        JSONObject node = JSONUtil.createObj();
        List recordSubEntityList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().isNotNull(RecordSubEntity::getFinalScore)).list();
        List addList = recordSubEntityList.stream().filter(e -> e.getFinalScore().compareTo(BigDecimal.ZERO) > 0).sorted(Comparator.comparing(RecordSubEntity::getFinalScore).reversed()).collect(Collectors.toList());
        List addSubList = addList.subList(0, Math.min(addList.size(), 5));
        List subtractList = recordSubEntityList.stream().filter(e -> e.getFinalScore().compareTo(BigDecimal.ZERO) < 0).sorted(Comparator.comparing(RecordSubEntity::getFinalScore).reversed()).collect(Collectors.toList());
        List subtractSubList = subtractList.subList(0, Math.min(subtractList.size(), 5));
        node.put("add", addSubList);
        node.put("subtract", subtractSubList);
        recordSubEntityList.sort(Comparator.comparing(BaseEntity::getCreateTime).reversed());
        Page page = new Page(Objects.isNull(pageNo) ? 1L : (long)pageNo.intValue(), Objects.isNull(pageSize) ? 10L : (long)pageSize.intValue());
        IPage allPage = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().isNotNull(RecordSubEntity::getFinalScore)).page((IPage)page);
        node.put("all", (Object)allPage);
        jsonArray.put((Object)node);
        return jsonArray;
    }

    @Override
    public JSONArray normScore(NormScoreVo vo) {
        String year = vo.getYear();
        HashSet<Long> normIds = new HashSet<Long>(vo.getNormIds());
        HashSet<String> unitIds = new HashSet<String>(vo.getUnitIds());
        if (CollUtil.isEmpty(normIds) || CollUtil.isEmpty(unitIds)) {
            throw new BusinessException("\u6307\u6807\u4fe1\u606f\u6216\u5355\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List recordSubEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).eq(RecordSubEntity::getScoreOfYear, (Object)year)).in(RecordSubEntity::getAssessmentUnitId, unitIds)).in(RecordSubEntity::getNormId, normIds)).list();
        JSONArray array = JSONUtil.createArray();
        Map normMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.normDao.lambdaQuery().eq(BaseEntity::getDr, (Object)0L)).in(BaseEntity::getId, normIds)).list().stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (Long normId : normIds) {
            JSONObject obj = JSONUtil.createObj();
            Map<String, List<RecordSubEntity>> groupedByUnit = recordSubEntityList.stream().filter(e -> e.getNormId().equals(normId)).collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitId));
            NormEntity normEntity = (NormEntity)((Object)normMap.get(normId));
            if (normEntity == null) continue;
            BigDecimal plusLimit = new BigDecimal(normEntity.getPlusLimit());
            BigDecimal reduceLimit = new BigDecimal(normEntity.getReduceLimit());
            ArrayList<NormScoreRes> objects = new ArrayList<NormScoreRes>();
            if (CollUtil.isEmpty(groupedByUnit)) {
                obj.put("minAa", (Object)plusLimit);
                obj.put("minSs", (Object)reduceLimit);
                obj.put("normId", (Object)normId);
                array.add((Object)obj);
                continue;
            }
            for (List<RecordSubEntity> recordsForUnit : groupedByUnit.values()) {
                BigDecimal add = this.calculateScore(recordsForUnit, true);
                BigDecimal sub = this.calculateScore(recordsForUnit, false);
                NormScoreRes build = NormScoreRes.builder().aa(NumberUtil.sub((Number)plusLimit, (Number)add)).ss(NumberUtil.sub((Number)reduceLimit, (Number)sub)).build();
                objects.add(build);
            }
            BigDecimal minAa = objects.stream().map(NormScoreRes::getAa).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            BigDecimal minSs = objects.stream().map(NormScoreRes::getSs).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
            obj.put("minAa", (Object)minAa);
            obj.put("minSs", (Object)minSs);
            obj.put("normId", (Object)normId);
            array.add((Object)obj);
        }
        return array;
    }

    private BigDecimal calculateScore(List<RecordSubEntity> records, boolean isAddition) {
        return records.stream().map(RecordSubEntity::getFinalScore).filter(finalScore -> finalScore != null && (isAddition ? finalScore.compareTo(BigDecimal.ZERO) > 0 : finalScore.compareTo(BigDecimal.ZERO) < 0)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private JSONArray buildTree(List<UserEntity> list) {
        String deptId = String.valueOf(this.sessionManager.getUserContext().getDeptId());
        Map<Integer, List<UserEntity>> orgTypeAndUnitInfoListMap = list.stream().collect(Collectors.groupingBy(UserEntity::getOrgType));
        JSONArray jsonArray = JSONUtil.createArray();
        for (Map.Entry<Integer, List<UserEntity>> orgTypeAndUnitInfoList : orgTypeAndUnitInfoListMap.entrySet()) {
            Integer orgType = orgTypeAndUnitInfoList.getKey();
            JSONObject node = JSONUtil.createObj();
            node.put("title", (Object)OrgTypeEnums.getNameByCode(orgType));
            node.put("key", (Object)orgType);
            List<UserEntity> unitInfoList = orgTypeAndUnitInfoList.getValue();
            JSONArray childrenArray = JSONUtil.createArray();
            for (UserEntity userEntity : unitInfoList) {
                JSONObject childNode = JSONUtil.createObj();
                childNode.put("title", (Object)userEntity.getAssessmentUnitName());
                childNode.put("key", (Object)userEntity.getAssessmentUnitCode());
                if (userEntity.getAssessmentUnitCode().equals(deptId)) {
                    childNode.put("isH", (Object)true);
                } else {
                    childNode.put("isH", (Object)false);
                }
                childrenArray.add((Object)childNode);
            }
            node.put("children", (Object)childrenArray);
            jsonArray.add((Object)node);
        }
        return jsonArray;
    }

    private List<AssessmentRankRes.AssessmentRankInfo> disposeScores(List<UserEntity> userList, List<RecordSubEntity> recordSubList, String year) {
        List infoList = Lists.newArrayList();
        Map<String, List<RecordSubEntity>> unitRecordSubMap = recordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode));
        for (UserEntity userEntity : userList) {
            String assessmentUnitCode = userEntity.getAssessmentUnitCode();
            String assessmentUnitName = userEntity.getAssessmentUnitName();
            String assessmentUnitShortName = userEntity.getAssessmentUnitShortName();
            AssessmentRankRes.AssessmentRankInfo res = AssessmentRankRes.AssessmentRankInfo.builder().unitCode(assessmentUnitCode).unitName(assessmentUnitName).unitShortName(assessmentUnitShortName).build();
            if (!unitRecordSubMap.containsKey(assessmentUnitCode)) {
                res.setQ1(BigDecimal.ZERO);
                res.setQ2(BigDecimal.ZERO);
                res.setQ3(BigDecimal.ZERO);
                res.setQ4(BigDecimal.ZERO);
                res.setYearScore(BigDecimal.ZERO);
                res.setTotalAnnualScore(BigDecimal.valueOf(100L));
                infoList.add(res);
                continue;
            }
            List<RecordSubEntity> recordSubEntityList = unitRecordSubMap.get(assessmentUnitCode);
            BigDecimal totalAnnualScore = BigDecimal.valueOf(100L);
            BigDecimal yearScore = recordSubEntityList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            totalAnnualScore = totalAnnualScore.add(yearScore).setScale(2, RoundingMode.HALF_UP);
            DateExtUtil.QuarterStartEndTime quarterStartEndTime = DateExtUtil.getQuarterStartEndTime(year);
            BigDecimal q1 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ1StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ1EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q2 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ2StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ2EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q3 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ3StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ3EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q4 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ4StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ4EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            res.setQ1(q1);
            res.setQ2(q2);
            res.setQ3(q3);
            res.setQ4(q4);
            res.setYearScore(yearScore);
            res.setTotalAnnualScore(totalAnnualScore);
            infoList.add(res);
        }
        infoList.sort(Comparator.comparing(AssessmentRankRes.AssessmentRankInfo::getTotalAnnualScore).reversed());
        return infoList;
    }

    public StatisticsServerImpl(RecordDao recordDao, RecordSubDao recordSubDao, UserDao userDao, NormDao normDao, TeamUserDao teamUserDao, SessionManager sessionManager, IRoleApi iRoleApi) {
        this.recordDao = recordDao;
        this.recordSubDao = recordSubDao;
        this.userDao = userDao;
        this.normDao = normDao;
        this.teamUserDao = teamUserDao;
        this.sessionManager = sessionManager;
        this.iRoleApi = iRoleApi;
    }
}

