/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.controller;

import cn.hutool.json.JSONArray;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.vo.NormScoreVo;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statistics"})
public class StatisticsController {
    private final StatisticsServer server;

    @RequestMapping(value={"tips"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> tips(@RequestParam(value="year") String year) {
        return CommonResponse.success((String)"\u8003\u8bc4\u5de5\u4f5c\u5904\u7406\u63d0\u793a", (Object)this.server.tips(year));
    }

    @RequestMapping(value={"getTree"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> getTree() {
        return CommonResponse.success((String)"\u83b7\u53d6\u6392\u540d\u7ec4\u7ec7\u6811", (Object)this.server.getTree());
    }

    @RequestMapping(value={"assessmentRank"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssessmentRankRes> assessmentRank(@RequestParam(value="year") String year) {
        return CommonResponse.success((String)"\u8003\u6838\u6392\u540d\u7edf\u8ba1", (Object)this.server.assessmentRank(year));
    }

    @RequestMapping(value={"record"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> record(@RequestParam(value="unitCode") String unitCode, @RequestParam(value="year") String year) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55\u7edf\u8ba1", (Object)this.server.record(unitCode, year));
    }

    @RequestMapping(value={"getNewRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> getNewRecord(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        return CommonResponse.success((String)"\u8003\u6838\u8bb0\u5f55\u7edf\u8ba1", (Object)this.server.getNewRecord(pageNo, pageSize));
    }

    @RequestMapping(value={"normScore"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONArray> normScore(@RequestBody NormScoreVo vo) {
        return CommonResponse.success((String)"\u6307\u6807\u8ba1\u7b97", (Object)this.server.normScore(vo));
    }

    public StatisticsController(StatisticsServer server) {
        this.server = server;
    }
}

