package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.desktop.api.IAllProjectSetPoolApi;
import com.ejianc.business.desktop.vo.WeixineeUserVO;
import com.ejianc.business.ecard.bean.UserInfoEntity;
import com.ejianc.business.ecard.service.IWorkWxService;
import com.ejianc.business.ecard.vo.UserInfoVO;
import com.ejianc.business.ecard.vo.workWx.ContentsDTO;
import com.ejianc.business.ecard.vo.workWx.LeaveRequestDTO;
import com.ejianc.business.weixinee.bean.LeaveRequestEntity;
import com.ejianc.business.weixinee.service.ILeaveRequestService;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import org.springframework.data.redis.core.RedisTemplate;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/workWx/")
public class WorkWxController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IWorkWxService workWxService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ILeaveRequestService leaveRequestService;
    @Autowired
    private IAllProjectSetPoolApi allProjectSetPoolApi;
    private static final long serialVersionUID = 1L;

    /**
     * @Description 同步微信请假数据
     * @param
     */
    @RequestMapping(value = "/queryLeaveRequestData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryLeaveRequestData(HttpServletRequest request) {
        long time = System.currentTimeMillis();

        //获取AccessToken
        String accessToken = workWxService.getAccessToken("dqeBQs_XyhYBjBibJrovaqW87pvNofHr5wYqYMC3wXo");
        //批量获取审批单号
        String startTime =  String.valueOf((time-1000*60*60) / 1000);
        String endTime = String.valueOf(time / 1000);
        if (redisTemplate.opsForValue().get("leave_data_last_time") != null) {
            startTime =  redisTemplate.opsForValue().get("leave_data_last_time").toString();
            redisTemplate.opsForValue().set("leave_data_last_time",endTime);
        }else {
            redisTemplate.opsForValue().set("leave_data_last_time",endTime);
        }
        JSONObject getBillCodes = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovalinfo?access_token=" + accessToken,
                "{\"starttime\" : "+startTime+",\"endtime\" : "+endTime+",\"new_cursor\" : \"\" ,\"size\" : 100 ,\"filters\" : [{\"key\": \"template_id\",\"value\": \"1970325056025175_1688851392291681_98642968_1501744141\"}]}");

        //先将JsonArray转为String
        String newIds = getBillCodes.getJSONArray("sp_no_list").toString();
        //再将String转为List<String>
        List<String> spNoList = JSONObject.parseArray(newIds,String.class);


        //JSONArray spNoList = getBillCodes.getJSONArray("sp_no_list");
        if (!spNoList.isEmpty()){
            //List<String> stringList = BeanMapper.mapList(spNoList, String.class);

            for (String s : spNoList) {
                //获取审批申请详情
                JSONObject jsonObject = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovaldetail?access_token=" + accessToken, "{\"sp_no\" : "+s+"}");
                LeaveRequestDTO map = BeanMapper.map(jsonObject, LeaveRequestDTO.class);
                if (map.getErrcode() == 0 && map.getInfo() != null){
                    LeaveRequestEntity leaveRequestEntity = new LeaveRequestEntity();
                    leaveRequestEntity.setSpNo(map.getInfo().getSp_no());//企微编号
                    leaveRequestEntity.setSpStatus(map.getInfo().getSp_status());//审批状态
                    leaveRequestEntity.setApplyTime(map.getInfo().getApply_time());//提交时间
                    leaveRequestEntity.setWeixineeUsercode(map.getInfo().getApplyer().getUserid());//企微人员id

                    CommonResponse<WeixineeUserVO> weixineeUserVOCommonResponse = allProjectSetPoolApi.queryUserByWeixineeId(map.getInfo().getApplyer().getUserid());
                    if (weixineeUserVOCommonResponse.getCode() == 0){
                        WeixineeUserVO data = weixineeUserVOCommonResponse.getData();
                        leaveRequestEntity.setUserId(data.getId());//用户id
                        leaveRequestEntity.setUserName(data.getUserName());//
                        leaveRequestEntity.setDeptId(data.getDeptId());//部门
                        leaveRequestEntity.setDeptName(data.getName());//
                        leaveRequestEntity.setUserCode(data.getUserCode());
                    }
                    List<ContentsDTO> contents = map.getInfo().getApply_data().getContents();
                    for (ContentsDTO content : contents) {
                        if ("Vacation".equals(content.getControl())){
                            leaveRequestEntity.setLeaveType(content.getValue().getVacation().getSelector().getOptions().get(0).getValue().get(0).getText());//
                            leaveRequestEntity.setNewBegin(content.getValue().getVacation().getAttendance().getDate_range().getNew_begin());//开始时间
                            leaveRequestEntity.setNewEnd(content.getValue().getVacation().getAttendance().getDate_range().getNew_end());//结束时间
                            leaveRequestEntity.setNewDuration(content.getValue().getVacation().getAttendance().getDate_range().getNew_duration());//
                        }else if ("Textarea".equals(content.getControl())){
                            leaveRequestEntity.setMemo(content.getValue().getText());//
                        }
                    }
                    leaveRequestService.saveOrUpdate(leaveRequestEntity);
                }
                //暂停0.1秒
                try {
                    Thread.sleep (100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        //获取近一天审批中的单据
        String yesterday =  String.valueOf((time-1000*60*60*24*1) / 1000);
        QueryWrapper<LeaveRequestEntity> wrapper = new QueryWrapper<>();
        wrapper.between("apply_time",yesterday,startTime);
        wrapper.eq("sp_status",1);
        List<LeaveRequestEntity> list = leaveRequestService.list(wrapper);
        if (CollectionUtils.isNotEmpty(list)){
            for (LeaveRequestEntity leaveRequestEntity : list) {
                //获取审批申请详情
                JSONObject jsonObject = doPost("https://qyapi.weixin.qq.com/cgi-bin/oa/getapprovaldetail?access_token=" + accessToken, "{\"sp_no\" : "+leaveRequestEntity.getSpNo()+"}");
                LeaveRequestDTO map = BeanMapper.map(jsonObject, LeaveRequestDTO.class);
                if (map.getErrcode() == 0 && map.getInfo() != null){
                    leaveRequestEntity.setSpStatus(map.getInfo().getSp_status());//
                    leaveRequestService.saveOrUpdate(leaveRequestEntity);
                }
                //暂停0.1秒
                try {
                    Thread.sleep (100);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！");
    }



    public static JSONObject doPost(String url, String json) {
        HttpResponse jsonResponse = null;
        try {
            JsonNode jsonNode = new JsonNode(json);
            jsonResponse = Unirest.post(url)
                    .body(jsonNode)
                    .asJson();
        } catch (UnirestException e) {
            e.printStackTrace();
        }
        return JSONObject.parseObject(jsonResponse.getBody().toString());
    }

    public static void main(String[] args) {
        long time = System.currentTimeMillis();
        String s = String.valueOf(time / 1000);
        System.out.println(s);
    }
}

