package com.ejianc.business.ecard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.ecard.bean.UserInfoEntity;
import com.ejianc.business.ecard.mapper.UserInfoMapper;
import com.ejianc.business.ecard.service.IUserInfoService;
import com.ejianc.business.ecard.service.IWorkWxService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import okhttp3.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * 用户名片信息录入
 * 
 * @author generator
 * 
 */
@Service("workWxServiceService")
public class WorkWxServiceImpl implements IWorkWxService {

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    //@Value("${wx.config.appid}")
    private String corpid = "wxcc9a690e5c66855c";//

    @Override
    public String getAccessToken(String corpsecret) {

        if(redisTemplate.opsForValue().get("access_token_"+corpsecret) != null){
            return redisTemplate.opsForValue().get("access_token_" + corpsecret).toString();
        }else {
            Unirest.setTimeouts(0, 0);
            try {
                HttpResponse<String> response = Unirest.get("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid="+corpid+"&corpsecret=" + corpsecret)
                        .header("User-Agent", "Apifox/1.0.0 (https://apifox.com)")
                        .asString();
                String body = response.getBody();
                JSONObject jsonObject = JSONObject.parseObject(body);
                String accessToken = jsonObject.getString("access_token");
                Integer expiresIn = jsonObject.getInteger("expires_in");//有效时长
                if(expiresIn > 600){
                    expiresIn = expiresIn - 600;//有效时长比最大时长小于10分钟
                }
                //将获取到的放入redis中（注意：设置的过期时间要小于等于）
                redisTemplate.opsForValue().set("access_token_" + corpsecret, accessToken,expiresIn, TimeUnit.SECONDS);
            return accessToken;
            } catch (UnirestException e) {
                e.printStackTrace();
            }
            return null;
        }
    }


    public static void main(String[] args) {
        Unirest.setTimeouts(0, 0);
        try {
            HttpResponse<String> response = Unirest.get("https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=wxcc9a690e5c66855c&corpsecret=dqeBQs_XyhYBjBibJrovaqW87pvNofHr5wYqYMC3wXo")
                    .header("User-Agent", "Apifox/1.0.0 (https://apifox.com)")
                    .asString();
            String body = response.getBody();
            JSONObject jsonObject = JSONObject.parseObject(body);
            String accessToken = jsonObject.getString("access_token");

            System.out.println(body);
        } catch (UnirestException e) {
            e.printStackTrace();
        }
    }
}
