package com.ejianc.business.weixinee.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.ecard.vo.workWx.LeaveRequestDTO;
import com.ejianc.business.hr.api.IBaseUserApi;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.business.weixinee.vo.LeaveRequestLeaderDTO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.weixinee.bean.LeaveRequestEntity;
import com.ejianc.business.weixinee.service.ILeaveRequestService;
import com.ejianc.business.weixinee.vo.LeaveRequestVO;

/**
 * 企业微信请假记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("leaveRequest")
public class LeaveRequestController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ILeaveRequestService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBaseUserApi baseUserApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LeaveRequestVO> saveOrUpdate(@RequestBody LeaveRequestVO saveOrUpdateVO) {
    	LeaveRequestEntity entity = BeanMapper.map(saveOrUpdateVO, LeaveRequestEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	LeaveRequestVO vo = BeanMapper.map(entity, LeaveRequestVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LeaveRequestVO> queryDetail(Long id) {
    	LeaveRequestEntity entity = service.selectById(id);
    	LeaveRequestVO vo = BeanMapper.map(entity, LeaveRequestVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LeaveRequestVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LeaveRequestVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(LeaveRequestVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //审批状态已通过
        param.getParams().put("spStatus", new Parameter(QueryParam.EQ, 2));

        IPage<LeaveRequestEntity> page = service.queryPage(param,false);
        IPage<LeaveRequestVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LeaveRequestVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<LeaveRequestEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LeaveRequest-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLeaveRequestData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestVO>> refLeaveRequestData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LeaveRequestEntity> page = service.queryPage(param,false);
        IPage<LeaveRequestVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LeaveRequestVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryList 查询列表领导
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListLeader", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestLeaderDTO>> queryListLeader(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");

        QueryParam param2 = new QueryParam();
        //审批状态已通过
        param2.getParams().put("spStatus", new Parameter(QueryParam.EQ, 2));
        long timestamp = (new Date().getTime()) / 1000;
        param2.getParams().put("newBegin", new Parameter(QueryParam.LE, timestamp));
        param2.getParams().put("newEnd", new Parameter(QueryParam.GE, timestamp));

        IPage<LeaveRequestEntity> page = service.queryPage(param2,false);
        Map<String, LeaveRequestEntity> collect = page.getRecords().stream().collect(Collectors.toMap(LeaveRequestEntity::getUserName, Function.identity(), (key1, key2) -> key2));



        //获取中层及以上人员名单
        List<LeaveRequestLeaderDTO> leaveRequestDTOS = new ArrayList<>();
        QueryParam param1 = new QueryParam();
        param1.setSearchText(param.getSearchText());
        List<String> fuzzyFields1 = param1.getFuzzyFields();
        fuzzyFields1.add("name");

        param1.setPageSize(50);
        param1.setPageIndex(1);
        param1.getParams().put("orgId", new Parameter(QueryParam.EQ, "1502571152642412546"));
        param1.getParams().put("orgType", new Parameter(QueryParam.EQ, 4));
        param1.getParams().put("postNameNew", new Parameter(QueryParam.IN, "副经理级,经理级,总助级,副总级"));
        CommonResponse<List<UserDataVO>> iPageCommonResponse = baseUserApi.queryAllUserDataApi(param1);
        logger.info("人力接口返回结果：{}", JSON.toJSONString(iPageCommonResponse));
        if (iPageCommonResponse.getCode() == 0){
            List<UserDataVO> records = iPageCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(records)){
                for (UserDataVO record : records) {
                    LeaveRequestLeaderDTO leaveRequestLeaderDTO = new LeaveRequestLeaderDTO();
                    leaveRequestLeaderDTO.setOrgSequence(Integer.parseInt(record.getOrgSequence()));
                    leaveRequestLeaderDTO.setDepartmentSequence(Integer.parseInt(record.getDepartmentSequence()));
                        leaveRequestLeaderDTO.setEmployeeSequence(Integer.parseInt(record.getEmployeeSequence()));
                        leaveRequestLeaderDTO.setUserName(record.getName());
                        leaveRequestLeaderDTO.setState("正常");

                        //有请假记录
                        if (collect.containsKey(record.getName())){
                            LeaveRequestEntity leaveRequestEntity = collect.get(record.getName());

                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            leaveRequestLeaderDTO.setDeptName(leaveRequestEntity.getDeptName());
                            leaveRequestLeaderDTO.setNewBegin(format.format(leaveRequestEntity.getNewBegin()*1000));
                            leaveRequestLeaderDTO.setNewEnd(format.format(leaveRequestEntity.getNewEnd()*1000));
                            leaveRequestLeaderDTO.setLeaveType(leaveRequestEntity.getLeaveType());
                            leaveRequestLeaderDTO.setMemo(leaveRequestEntity.getMemo());
                            leaveRequestLeaderDTO.setState("外出中");
                            leaveRequestLeaderDTO.setId(leaveRequestEntity.getId());
                        }

                        leaveRequestDTOS.add(leaveRequestLeaderDTO);
                }
            }
        }
        //根据状态过滤
        if (param.getParams().containsKey("state")){

            String state = param.getParams().get("state").getValue().toString();
            leaveRequestDTOS = leaveRequestDTOS.stream().filter(entity -> entity.getState().equals(state)).collect(Collectors.toList());
        }
        //排序
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getEmployeeSequence()-y.getEmployeeSequence());
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getDepartmentSequence()-y.getDepartmentSequence());
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getOrgSequence()-y.getOrgSequence());
        IPage<LeaveRequestLeaderDTO> pageData = new Page<>(1,50, leaveRequestDTOS.size());

//        IPage<LeaveRequestLeaderDTO> pageData = new Page<>(param.getPageIndex(),param.getPageSize(), leaveRequestDTOS.size());
//        List<LeaveRequestLeaderDTO> leaveRequestLeaderDTOS = new ArrayList<>();
//        if (param.getPageIndex()*param.getPageSize()<=leaveRequestDTOS.size()){
//            leaveRequestLeaderDTOS  = leaveRequestDTOS.subList((param.getPageIndex() - 1) * param.getPageSize(), param.getPageIndex() * param.getPageSize());
//        }else {
//            leaveRequestLeaderDTOS  = leaveRequestDTOS.subList((param.getPageIndex()-1)*param.getPageSize(),leaveRequestDTOS.size());
//        }

        pageData.setRecords(leaveRequestDTOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description queryList 查询列表普通员工
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestLeaderDTO>> queryListUser(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");

        QueryParam param2 = new QueryParam();
        //审批状态已通过
        param2.getParams().put("spStatus", new Parameter(QueryParam.EQ, 2));
        long timestamp = (new Date().getTime()) / 1000;
        param2.getParams().put("newBegin", new Parameter(QueryParam.LE, timestamp));
        param2.getParams().put("newEnd", new Parameter(QueryParam.GE, timestamp));

        IPage<LeaveRequestEntity> page = service.queryPage(param2,false);
        Map<String, LeaveRequestEntity> collect = page.getRecords().stream().collect(Collectors.toMap(LeaveRequestEntity::getUserCode, Function.identity(), (key1, key2) -> key2));



        //获取中层及以上人员名单
        List<LeaveRequestLeaderDTO> leaveRequestDTOS = new ArrayList<>();
        QueryParam param1 = new QueryParam();
        param1.setSearchText(param.getSearchText());
        List<String> fuzzyFields1 = param1.getFuzzyFields();
        fuzzyFields1.add("name");

        param1.setPageSize(200);
        param1.setPageIndex(1);
        param1.getParams().put("orgId", new Parameter(QueryParam.EQ, "1502571152642412546"));
        param1.getParams().put("orgType", new Parameter(QueryParam.EQ, 4));
        param1.getParams().put("postNameNew", new Parameter(QueryParam.NOT_IN, "副经理级,经理级,总助级,副总级"));
        CommonResponse<List<UserDataVO>> iPageCommonResponse = baseUserApi.queryAllUserDataApi(param1);
        if (iPageCommonResponse.getCode() == 0){
            List<UserDataVO> records = iPageCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(records)){
                for (UserDataVO record : records) {
                    LeaveRequestLeaderDTO leaveRequestLeaderDTO = new LeaveRequestLeaderDTO();
                    leaveRequestLeaderDTO.setOrgSequence(Integer.parseInt(record.getOrgSequence()));
                    leaveRequestLeaderDTO.setDepartmentSequence(Integer.parseInt(record.getDepartmentSequence()));
                    leaveRequestLeaderDTO.setEmployeeSequence(Integer.parseInt(record.getEmployeeSequence()));
                    leaveRequestLeaderDTO.setUserName(record.getName());
                    leaveRequestLeaderDTO.setState("正常");

                    //有请假记录
                    if (collect.containsKey(record.getUserCode())){
                        LeaveRequestEntity leaveRequestEntity = collect.get(record.getName());

                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        leaveRequestLeaderDTO.setDeptName(leaveRequestEntity.getDeptName());
                        leaveRequestLeaderDTO.setNewBegin(format.format(leaveRequestEntity.getNewBegin()*1000));
                        leaveRequestLeaderDTO.setNewEnd(format.format(leaveRequestEntity.getNewEnd()*1000));
                        leaveRequestLeaderDTO.setLeaveType(leaveRequestEntity.getLeaveType());
                        leaveRequestLeaderDTO.setMemo(leaveRequestEntity.getMemo());
                        leaveRequestLeaderDTO.setState("外出中");
                        leaveRequestLeaderDTO.setId(leaveRequestEntity.getId());
                    }

                    leaveRequestDTOS.add(leaveRequestLeaderDTO);
                }
            }
        }
        //根据状态过滤
        if (param.getParams().containsKey("state")){

            String state = param.getParams().get("state").getValue().toString();
            leaveRequestDTOS = leaveRequestDTOS.stream().filter(entity -> entity.getState().equals(state)).collect(Collectors.toList());
        }
        //排序
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getEmployeeSequence()-y.getEmployeeSequence());
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getDepartmentSequence()-y.getDepartmentSequence());
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getOrgSequence()-y.getOrgSequence());
        //IPage<LeaveRequestLeaderDTO> pageData = new Page<>(1,50, leaveRequestDTOS.size());

        IPage<LeaveRequestLeaderDTO> pageData = new Page<>(param.getPageIndex(),param.getPageSize(), leaveRequestDTOS.size());
        List<LeaveRequestLeaderDTO> leaveRequestLeaderDTOS = new ArrayList<>();
        if (param.getPageIndex()*param.getPageSize()<=leaveRequestDTOS.size()){
            leaveRequestLeaderDTOS  = leaveRequestDTOS.subList((param.getPageIndex() - 1) * param.getPageSize(), param.getPageIndex() * param.getPageSize());
        }else {
            leaveRequestLeaderDTOS  = leaveRequestDTOS.subList((param.getPageIndex()-1)*param.getPageSize(),leaveRequestDTOS.size());
        }

        pageData.setRecords(leaveRequestLeaderDTOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    public static void main(String[] args) {
        List<LeaveRequestLeaderDTO> leaveRequestDTOS = new ArrayList<>();
        LeaveRequestLeaderDTO leaveRequestLeaderDTO = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO.setId(1L);
        leaveRequestLeaderDTO.setEmployeeSequence(2);
        leaveRequestDTOS.add(leaveRequestLeaderDTO);
        LeaveRequestLeaderDTO leaveRequestLeaderDTO1 = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO1.setId(2L);
        leaveRequestLeaderDTO1.setEmployeeSequence(1);
        leaveRequestDTOS.add(leaveRequestLeaderDTO1);
        LeaveRequestLeaderDTO leaveRequestLeaderDTO2 = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO2.setId(3L);
        leaveRequestLeaderDTO2.setEmployeeSequence(3);
        leaveRequestDTOS.add(leaveRequestLeaderDTO2);
        Collections.sort(leaveRequestDTOS,(x,y) -> x.getEmployeeSequence()-y.getEmployeeSequence());
        leaveRequestDTOS.forEach((a)->System.out.print(a.getEmployeeSequence()));
    }
}
