package com.ejianc.business.equipment.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
public class PurchaseSettlementFeeVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long settlementId;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 备注
     */
    private String memo;
    /**
     * 成本科目主键
     */
    private Long feeSubjectId;

    /**
     * 成本科目名称
     */
    private String feeSubjectName;

    /**
     * 成本科目集团主键
     */
    private Long feeOrgSubjectId;

    /**
     * 税率
     */
    private BigDecimal freeTaxRate;

    /**
     * 金额（含税）
     */
    private BigDecimal taxMoney;

    /**
     * 核算对象主键
     */
    private Long feeAccountingId;

    /**
     * 核算对象名称
     */
    private String feeAccountingName;

    /**
     * 核算对象集团主键
     */
    private Long feeOrgAccountingId;

    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="subject-project-ref")
    public Long getFeeSubjectId() {
        return feeSubjectId;
    }

    @ReferDeserialTransfer
    public void setFeeSubjectId(Long feeSubjectId) {
        this.feeSubjectId = feeSubjectId;
    }

    public String getFeeSubjectName() {
        return feeSubjectName;
    }

    public void setFeeSubjectName(String feeSubjectName) {
        this.feeSubjectName = feeSubjectName;
    }

    public Long getFeeOrgSubjectId() {
        return feeOrgSubjectId;
    }

    public void setFeeOrgSubjectId(Long feeOrgSubjectId) {
        this.feeOrgSubjectId = feeOrgSubjectId;
    }

    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getFeeAccountingId() {
        return feeAccountingId;
    }

    @ReferDeserialTransfer
    public void setFeeAccountingId(Long feeAccountingId) {
        this.feeAccountingId = feeAccountingId;
    }

    public String getFeeAccountingName() {
        return feeAccountingName;
    }

    public void setFeeAccountingName(String feeAccountingName) {
        this.feeAccountingName = feeAccountingName;
    }

    public Long getFeeOrgAccountingId() {
        return feeOrgAccountingId;
    }

    public void setFeeOrgAccountingId(Long feeOrgAccountingId) {
        this.feeOrgAccountingId = feeOrgAccountingId;
    }
}
