package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_equipment_rent_settlement_detail")
public class RentSettlementDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    private Long settlementId;

    /**
     * 设备档案主键
     */
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    private Long contractDetailId;

    /**
     * 合同使用记录主键
     */
    private Long useId;

    /**
     * 合同使用记录子表主键
     */
    private Long useDetailId;

    /**
     * 使用记录编码
     */
    private String useCode;

    /**
     *
     */
    private Integer source;

    /**
     * 设备编码
     */
    private String code;

    /**
     * 设备名称
     */
    private String name;

    /**
     * 规格型号
     */
    private String spec;

    /**
     * 计量单位名称
     */
    private String unitName;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 金额
     */
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 起租日期
     */
    private Date startDate;

    /**
     * 停租日期
     */
    private Date endDate;
    /**
     * 来源名称
     */
    private String sourceName;
    /**
     * 租期
     */
    private String rentTerm;
    /**
     * 成本科目主键
     */
    private Long subjectId;
    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 单价(含税)
     */
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    private BigDecimal tax;

    /**
     * 本期结算金额(含税)
     */
    private BigDecimal settlementTaxMny;

    /**
     * 核算对象主键
     */
    private java.lang.Long accountingId;

    /**
     * 核算对象名称
     */
    private java.lang.String accountingName;

    /**
     * 集团成本科目主键
     */
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    private java.lang.Long orgAccountingId;

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }



    @ReferSerialTransfer(referCode="subject-project-ref")
    public Long getSubjectId() {
        return subjectId;
    }
    @ReferDeserialTransfer
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(String rentTerm) {
        this.rentTerm = rentTerm;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getUseDetailId() {
        return useDetailId;
    }

    public void setUseDetailId(Long useDetailId) {
        this.useDetailId = useDetailId;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /**
     * 核算对象主键
     */
    @ReferSerialTransfer(referCode="accounting-project-ref")
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象主键
     */
    @ReferDeserialTransfer
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    /**
     * 集团核算对象主键
     */
    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    /**
     * 集团核算对象主键
     */
    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }

}
